/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs;

import com.logicalclocks.hsfs.DataFormat;
import com.logicalclocks.hsfs.FeatureGroup;
import com.logicalclocks.hsfs.FeatureStore;
import com.logicalclocks.hsfs.HopsworksConnection;
import com.logicalclocks.hsfs.Split;
import com.logicalclocks.hsfs.TrainingDataset;
import com.logicalclocks.hsfs.constructor.Query;
import com.logicalclocks.hsfs.engine.SparkEngine;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainClass {
    private static final Logger LOGGER = LoggerFactory.getLogger(MainClass.class);

    public static void main(String[] args) throws Exception {
        HopsworksConnection connection = HopsworksConnection.builder().build();
        FeatureStore fs = connection.getFeatureStore();
        LOGGER.info("Feature Store " + fs);
        FeatureGroup housingFeatureGroup = fs.createFeatureGroup().name("housing").description("House pricing model features").version(1).primaryKeys(Arrays.asList("house_id", "date")).partitionKeys(Arrays.asList("country")).onlineEnabled(true).build();
        FeatureGroup attendance = fs.getFeatureGroup("attendances_features", 1);
        FeatureGroup players = fs.getFeatureGroup("players_features", 1);
        Query query = attendance.selectAll().join(players.selectAll());
        ArrayList<Split> splits = new ArrayList<Split>();
        splits.add(new Split("test", Float.valueOf(0.8f)));
        TrainingDataset td = fs.createTrainingDataset().name("new_api_td").description("This is a test").version(1).dataFormat(DataFormat.CSV).splits(splits).build();
        td.save(query);
        SparkEngine.getInstance().getSparkSession().close();
    }
}

