/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.metadata;

import com.damnhandy.uri.template.UriTemplate;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.metadata.HopsworksClient;
import com.logicalclocks.hsfs.metadata.RuleDefinition;
import com.logicalclocks.hsfs.metadata.validation.RuleName;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpGet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.JavaConverters;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;

public class RulesApi {
    public static final String RULE_DEFINITIONS_PATH = "/hopsworks-api/api/rules{/name}{/predicate}{?filter_by,sort_by,offset,limit}";
    private static final Logger LOGGER = LoggerFactory.getLogger(RulesApi.class);

    public Seq<RuleDefinition> get() throws FeatureStoreException, IOException {
        return ((Buffer)JavaConverters.asScalaBufferConverter(this.getRules(null)).asScala()).toSeq();
    }

    public RuleDefinition get(RuleName name) throws FeatureStoreException, IOException {
        return this.getRules(name).get(0);
    }

    private List<RuleDefinition> getRules(RuleName name) throws FeatureStoreException, IOException {
        List<RuleDefinition> rules;
        UriTemplate uriTemplate = UriTemplate.fromTemplate((String)RULE_DEFINITIONS_PATH);
        if (name != null) {
            uriTemplate.set("name", (Object)name);
        }
        String uri = uriTemplate.expand();
        LOGGER.info("Sending metadata request: " + uri);
        HttpGet getRequest = new HttpGet(uri);
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        RuleDefinition rulesDto = hopsworksClient.handleRequest((HttpRequest)getRequest, RuleDefinition.class);
        if (rulesDto.getCount() == null) {
            rules = new ArrayList();
            rules.add(rulesDto);
        } else {
            rules = rulesDto.getItems();
        }
        LOGGER.info("Received ruleDefinitions: " + rules);
        return rules;
    }
}

