/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.constructor;

import com.logicalclocks.hsfs.Feature;
import com.logicalclocks.hsfs.FeatureGroup;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.OnDemandFeatureGroup;
import com.logicalclocks.hsfs.Storage;
import com.logicalclocks.hsfs.StorageConnector;
import com.logicalclocks.hsfs.constructor.Filter;
import com.logicalclocks.hsfs.constructor.FilterLogic;
import com.logicalclocks.hsfs.constructor.FsQuery;
import com.logicalclocks.hsfs.constructor.HudiFeatureGroupAlias;
import com.logicalclocks.hsfs.constructor.Join;
import com.logicalclocks.hsfs.constructor.JoinType;
import com.logicalclocks.hsfs.constructor.OnDemandFeatureGroupAlias;
import com.logicalclocks.hsfs.engine.SparkEngine;
import com.logicalclocks.hsfs.engine.Utils;
import com.logicalclocks.hsfs.metadata.FeatureGroupBase;
import com.logicalclocks.hsfs.metadata.QueryConstructorApi;
import com.logicalclocks.hsfs.metadata.StorageConnectorApi;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Query {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureGroup.class);
    private FeatureGroupBase leftFeatureGroup;
    private List<Feature> leftFeatures;
    private Long leftFeatureGroupStartTime;
    private Long leftFeatureGroupEndTime;
    private List<Join> joins = new ArrayList<Join>();
    private FilterLogic filter;
    private Boolean hiveEngine = false;
    private QueryConstructorApi queryConstructorApi;
    private StorageConnectorApi storageConnectorApi;
    private Utils utils = new Utils();

    public Query(FeatureGroupBase leftFeatureGroup, List<Feature> leftFeatures) {
        this.leftFeatureGroup = leftFeatureGroup;
        this.leftFeatures = leftFeatures;
        this.queryConstructorApi = new QueryConstructorApi();
        this.storageConnectorApi = new StorageConnectorApi();
    }

    public Query join(Query subquery) {
        return this.join(subquery, JoinType.INNER);
    }

    public Query join(Query subquery, List<String> on) {
        return this.joinFeatures(subquery, on.stream().map(Feature::new).collect(Collectors.toList()), JoinType.INNER);
    }

    public Query join(Query subquery, List<String> leftOn, List<String> rightOn) {
        return this.joinFeatures(subquery, leftOn.stream().map(Feature::new).collect(Collectors.toList()), rightOn.stream().map(Feature::new).collect(Collectors.toList()), JoinType.INNER);
    }

    public Query join(Query subquery, JoinType joinType) {
        this.joins.add(new Join(subquery, joinType));
        return this;
    }

    public Query join(Query subquery, List<String> on, JoinType joinType) {
        this.joins.add(new Join(subquery, on.stream().map(Feature::new).collect(Collectors.toList()), joinType));
        return this;
    }

    public Query join(Query subquery, List<String> leftOn, List<String> rightOn, JoinType joinType) {
        this.joins.add(new Join(subquery, leftOn.stream().map(Feature::new).collect(Collectors.toList()), rightOn.stream().map(Feature::new).collect(Collectors.toList()), joinType));
        return this;
    }

    public Query joinFeatures(Query subquery, List<Feature> on) {
        return this.joinFeatures(subquery, on, JoinType.INNER);
    }

    public Query joinFeatures(Query subquery, List<Feature> leftOn, List<Feature> rightOn) {
        return this.joinFeatures(subquery, leftOn, rightOn, JoinType.INNER);
    }

    public Query joinFeatures(Query subquery, List<Feature> on, JoinType joinType) {
        this.joins.add(new Join(subquery, on, joinType));
        return this;
    }

    public Query joinFeatures(Query subquery, List<Feature> leftOn, List<Feature> rightOn, JoinType joinType) {
        this.joins.add(new Join(subquery, leftOn, rightOn, joinType));
        return this;
    }

    public Query asOf(String wallclockTime) throws FeatureStoreException, ParseException {
        Long wallclockTimestamp = this.utils.getTimeStampFromDateString(wallclockTime);
        for (Join join : this.joins) {
            Query queryWithTimeStamp = join.getQuery();
            queryWithTimeStamp.setLeftFeatureGroupEndTime(wallclockTimestamp);
            join.setQuery(queryWithTimeStamp);
        }
        this.setLeftFeatureGroupEndTime(wallclockTimestamp);
        return this;
    }

    public Query pullChanges(String wallclockStartTime, String wallclockEndTime) throws FeatureStoreException, ParseException {
        this.setLeftFeatureGroupStartTime(this.utils.getTimeStampFromDateString(wallclockStartTime));
        this.setLeftFeatureGroupEndTime(this.utils.getTimeStampFromDateString(wallclockEndTime));
        return this;
    }

    public Dataset<Row> read() throws FeatureStoreException, IOException {
        return this.read(false, null);
    }

    public Dataset<Row> read(boolean online) throws FeatureStoreException, IOException {
        return this.read(online, null);
    }

    public Dataset<Row> read(boolean online, Map<String, String> readOptions) throws FeatureStoreException, IOException {
        FsQuery fsQuery = this.queryConstructorApi.constructQuery(this.leftFeatureGroup.getFeatureStore(), this);
        if (online) {
            LOGGER.info("Executing query: " + fsQuery.getStorageQuery(Storage.ONLINE));
            StorageConnector.JdbcConnector onlineConnector = this.storageConnectorApi.getOnlineStorageConnector(this.leftFeatureGroup.getFeatureStore());
            return ((StorageConnector)onlineConnector).read(fsQuery.getStorageQuery(Storage.ONLINE), null, null, null);
        }
        this.registerOnDemandFeatureGroups(fsQuery.getOnDemandFeatureGroups());
        this.registerHudiFeatureGroups(fsQuery.getHudiCachedFeatureGroups(), readOptions);
        LOGGER.info("Executing query: " + fsQuery.getStorageQuery(Storage.OFFLINE));
        return SparkEngine.getInstance().sql(fsQuery.getStorageQuery(Storage.OFFLINE));
    }

    public void show(int numRows) throws FeatureStoreException, IOException {
        this.show(false, numRows);
    }

    public void show(boolean online, int numRows) throws FeatureStoreException, IOException {
        this.read(online).show(numRows);
    }

    public String toString() {
        return this.toString(Storage.OFFLINE);
    }

    public String toString(Storage storage) {
        try {
            return this.queryConstructorApi.constructQuery(this.leftFeatureGroup.getFeatureStore(), this).getStorageQuery(storage);
        }
        catch (FeatureStoreException | IOException e) {
            return e.getMessage();
        }
    }

    private void registerOnDemandFeatureGroups(List<OnDemandFeatureGroupAlias> onDemandFeatureGroups) throws FeatureStoreException, IOException {
        if (onDemandFeatureGroups == null || onDemandFeatureGroups.isEmpty()) {
            return;
        }
        for (OnDemandFeatureGroupAlias onDemandFeatureGroupAlias : onDemandFeatureGroups) {
            String alias = onDemandFeatureGroupAlias.getAlias();
            OnDemandFeatureGroup onDemandFeatureGroup = onDemandFeatureGroupAlias.getOnDemandFeatureGroup();
            SparkEngine.getInstance().registerOnDemandTemporaryTable(onDemandFeatureGroup, alias);
        }
    }

    private void registerHudiFeatureGroups(List<HudiFeatureGroupAlias> hudiFeatureGroups, Map<String, String> readOptions) {
        for (HudiFeatureGroupAlias hudiFeatureGroupAlias : hudiFeatureGroups) {
            String alias = hudiFeatureGroupAlias.getAlias();
            FeatureGroup featureGroup = hudiFeatureGroupAlias.getFeatureGroup();
            SparkEngine.getInstance().registerHudiTemporaryTable(featureGroup, alias, hudiFeatureGroupAlias.getLeftFeatureGroupStartTimestamp(), hudiFeatureGroupAlias.getLeftFeatureGroupEndTimestamp(), readOptions);
        }
    }

    public Query filter(Filter filter) {
        this.filter = this.filter == null ? new FilterLogic(filter) : this.filter.and(filter);
        return this;
    }

    public Query filter(FilterLogic filter) {
        this.filter = this.filter == null ? filter : this.filter.and(filter);
        return this;
    }

    public FeatureGroupBase getLeftFeatureGroup() {
        return this.leftFeatureGroup;
    }

    public void setLeftFeatureGroup(FeatureGroupBase leftFeatureGroup) {
        this.leftFeatureGroup = leftFeatureGroup;
    }

    public List<Feature> getLeftFeatures() {
        return this.leftFeatures;
    }

    public void setLeftFeatures(List<Feature> leftFeatures) {
        this.leftFeatures = leftFeatures;
    }

    public Long getLeftFeatureGroupStartTime() {
        return this.leftFeatureGroupStartTime;
    }

    public void setLeftFeatureGroupStartTime(Long leftFeatureGroupStartTime) {
        this.leftFeatureGroupStartTime = leftFeatureGroupStartTime;
    }

    public Long getLeftFeatureGroupEndTime() {
        return this.leftFeatureGroupEndTime;
    }

    public void setLeftFeatureGroupEndTime(Long leftFeatureGroupEndTime) {
        this.leftFeatureGroupEndTime = leftFeatureGroupEndTime;
    }

    public List<Join> getJoins() {
        return this.joins;
    }

    public void setJoins(List<Join> joins) {
        this.joins = joins;
    }

    public FilterLogic getFilter() {
        return this.filter;
    }

    public void setFilter(FilterLogic filter) {
        this.filter = filter;
    }

    public Boolean getHiveEngine() {
        return this.hiveEngine;
    }

    public void setHiveEngine(Boolean hiveEngine) {
        this.hiveEngine = hiveEngine;
    }
}

