/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.engine;

import com.logicalclocks.hsfs.EntityEndpointType;
import com.logicalclocks.hsfs.Feature;
import com.logicalclocks.hsfs.FeatureGroup;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.metadata.FeatureGroupApi;
import com.logicalclocks.hsfs.metadata.FeatureGroupBase;
import com.logicalclocks.hsfs.metadata.TagsApi;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class FeatureGroupBaseEngine {
    protected FeatureGroupApi featureGroupApi = new FeatureGroupApi();
    protected TagsApi tagsApi = new TagsApi(EntityEndpointType.FEATURE_GROUP);

    public void delete(FeatureGroupBase featureGroupBase) throws FeatureStoreException, IOException {
        this.featureGroupApi.delete(featureGroupBase);
    }

    public void addTag(FeatureGroupBase featureGroupBase, String name, Object value) throws FeatureStoreException, IOException {
        this.tagsApi.add(featureGroupBase, name, value);
    }

    public Object getTag(FeatureGroupBase featureGroupBase, String name) throws FeatureStoreException, IOException {
        return this.tagsApi.get(featureGroupBase, name);
    }

    public Map<String, Object> getTags(FeatureGroupBase featureGroupBase) throws FeatureStoreException, IOException {
        return this.tagsApi.get(featureGroupBase);
    }

    public void deleteTag(FeatureGroupBase featureGroupBase, String name) throws FeatureStoreException, IOException {
        this.tagsApi.deleteTag(featureGroupBase, name);
    }

    public void updateDescription(FeatureGroupBase featureGroup, String description) throws FeatureStoreException, IOException {
        FeatureGroupBase fgBaseSend = new FeatureGroupBase(featureGroup.getFeatureStore(), featureGroup.getId());
        fgBaseSend.setDescription(description);
        FeatureGroup apiFG = this.featureGroupApi.updateMetadata(fgBaseSend, "updateMetadata");
        featureGroup.setDescription(apiFG.getDescription());
    }

    public void appendFeatures(FeatureGroupBase featureGroup, List<Feature> features) throws FeatureStoreException, IOException {
        FeatureGroupBase fgBaseSend = new FeatureGroupBase(featureGroup.getFeatureStore(), featureGroup.getId());
        features.addAll(featureGroup.getFeatures());
        fgBaseSend.setFeatures(features);
        FeatureGroup apiFG = this.featureGroupApi.updateMetadata(fgBaseSend, "updateMetadata");
        featureGroup.setFeatures(apiFG.getFeatures());
    }

    public void updateStatisticsConfig(FeatureGroup featureGroup) throws FeatureStoreException, IOException {
        FeatureGroup apiFG = this.featureGroupApi.updateMetadata(featureGroup, "updateStatsConfig");
        featureGroup.getStatisticsConfig().setCorrelations(apiFG.getStatisticsConfig().getCorrelations());
        featureGroup.getStatisticsConfig().setHistograms(apiFG.getStatisticsConfig().getHistograms());
    }
}

