/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.metadata;

import com.damnhandy.uri.template.UriTemplate;
import com.logicalclocks.hsfs.FeatureStore;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.TrainingDataset;
import com.logicalclocks.hsfs.constructor.FsQuery;
import com.logicalclocks.hsfs.constructor.ServingPreparedStatement;
import com.logicalclocks.hsfs.metadata.HopsworksClient;
import com.logicalclocks.hsfs.metadata.TransformationFunctionAttached;
import java.io.IOException;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrainingDatasetApi {
    private static final String TRAINING_DATASETS_PATH = "/trainingdatasets";
    private static final String TRAINING_DATASET_PATH = "/trainingdatasets{/tdName}{?version}";
    private static final String TRAINING_QUERY_PATH = "/trainingdatasets{/tdId}/query{?withLabel}";
    public static final String TRAINING_DATASET_ID_PATH = "/trainingdatasets{/fgId}{?updateStatsConfig,updateMetadata}";
    private static final String PREP_STATEMENT_PATH = "/trainingdatasets{/tdId}/preparedstatements";
    private static final String TRANSFORMATION_FUNCTION_PATH = "/trainingdatasets{/tdId}/transformationfunctions";
    private static final Logger LOGGER = LoggerFactory.getLogger(TrainingDatasetApi.class);

    public TrainingDataset get(FeatureStore featureStore, String tdName, Integer tdVersion) throws IOException, FeatureStoreException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}/trainingdatasets{/tdName}{?version}";
        String uri = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)featureStore.getProjectId()).set("fsId", (Object)featureStore.getId()).set("tdName", (Object)tdName).set("version", (Object)tdVersion).expand();
        LOGGER.info("Sending metadata request: " + uri);
        TrainingDataset[] trainingDatasets = hopsworksClient.handleRequest((HttpRequest)new HttpGet(uri), TrainingDataset[].class);
        TrainingDataset resultTd = trainingDatasets[0];
        resultTd.setFeatureStore(featureStore);
        resultTd.getFeatures().stream().filter(f -> f.getFeaturegroup() != null).forEach(f -> f.getFeaturegroup().setFeatureStore(featureStore));
        return resultTd;
    }

    public TrainingDataset createTrainingDataset(TrainingDataset trainingDataset) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}/trainingdatasets";
        String uri = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)trainingDataset.getFeatureStore().getProjectId()).set("fsId", (Object)trainingDataset.getFeatureStore().getId()).expand();
        String trainingDatasetJson = hopsworksClient.getObjectMapper().writeValueAsString((Object)trainingDataset);
        HttpPost postRequest = new HttpPost(uri);
        postRequest.setHeader("Content-Type", "application/json");
        postRequest.setEntity((HttpEntity)new StringEntity(trainingDatasetJson));
        LOGGER.info("Sending metadata request: " + uri);
        LOGGER.info(trainingDatasetJson);
        return hopsworksClient.handleRequest((HttpRequest)postRequest, TrainingDataset.class);
    }

    public FsQuery getQuery(TrainingDataset trainingDataset, boolean withLabel) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}/trainingdatasets{/tdId}/query{?withLabel}";
        String uri = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)trainingDataset.getFeatureStore().getProjectId()).set("fsId", (Object)trainingDataset.getFeatureStore().getId()).set("tdId", (Object)trainingDataset.getId()).set("withLabel", (Object)withLabel).expand();
        HttpGet getRequest = new HttpGet(uri);
        LOGGER.info("Sending metadata request: " + uri);
        return hopsworksClient.handleRequest((HttpRequest)getRequest, FsQuery.class);
    }

    public List<ServingPreparedStatement> getServingPreparedStatement(TrainingDataset trainingDataset) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}/trainingdatasets{/tdId}/preparedstatements";
        String uri = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)trainingDataset.getFeatureStore().getProjectId()).set("fsId", (Object)trainingDataset.getFeatureStore().getId()).set("tdId", (Object)trainingDataset.getId()).expand();
        HttpGet getRequest = new HttpGet(uri);
        LOGGER.info("Sending metadata request: " + uri);
        ServingPreparedStatement servingPreparedStatement = hopsworksClient.handleRequest((HttpRequest)getRequest, ServingPreparedStatement.class);
        return servingPreparedStatement.getItems();
    }

    public TrainingDataset updateMetadata(TrainingDataset trainingDataset, String queryParameter) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}/trainingdatasets{/fgId}{?updateStatsConfig,updateMetadata}";
        String uri = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)trainingDataset.getFeatureStore().getProjectId()).set("fsId", (Object)trainingDataset.getFeatureStore().getId()).set("fgId", (Object)trainingDataset.getId()).set(queryParameter, (Object)true).expand();
        String trainingDatasetJson = hopsworksClient.getObjectMapper().writeValueAsString((Object)trainingDataset);
        HttpPut putRequest = new HttpPut(uri);
        putRequest.setHeader("Content-Type", "application/json");
        putRequest.setEntity((HttpEntity)new StringEntity(trainingDatasetJson));
        LOGGER.info("Sending metadata request: " + uri);
        LOGGER.info(trainingDatasetJson);
        return hopsworksClient.handleRequest((HttpRequest)putRequest, TrainingDataset.class);
    }

    public void delete(TrainingDataset trainingDataset) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}/trainingdatasets{/fgId}{?updateStatsConfig,updateMetadata}";
        String uri = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)trainingDataset.getFeatureStore().getProjectId()).set("fsId", (Object)trainingDataset.getFeatureStore().getId()).set("fgId", (Object)trainingDataset.getId()).expand();
        HttpDelete deleteRequest = new HttpDelete(uri);
        LOGGER.info("Sending metadata request: " + uri);
        hopsworksClient.handleRequest((HttpRequest)deleteRequest);
    }

    public List<TransformationFunctionAttached> getTransformationFunctions(TrainingDataset trainingDataset) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}/trainingdatasets{/tdId}/transformationfunctions";
        String uri = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)trainingDataset.getFeatureStore().getProjectId()).set("fsId", (Object)trainingDataset.getFeatureStore().getId()).set("tdId", (Object)trainingDataset.getId()).expand();
        LOGGER.info("Sending metadata request: " + uri);
        TransformationFunctionAttached transformationFunctionAttached = hopsworksClient.handleRequest((HttpRequest)new HttpGet(uri), TransformationFunctionAttached.class);
        return transformationFunctionAttached.getItems();
    }
}

