/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.constructor;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.common.base.Strings;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.Storage;
import com.logicalclocks.hsfs.constructor.HudiFeatureGroupAlias;
import com.logicalclocks.hsfs.constructor.OnDemandFeatureGroupAlias;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class FsQuery {
    private String query;
    private String queryOnline;
    private String pitQuery;
    private List<OnDemandFeatureGroupAlias> onDemandFeatureGroups;
    private List<HudiFeatureGroupAlias> hudiCachedFeatureGroups;

    public void removeNewLines() {
        this.query = this.query != null ? this.query.replace("\n", " ") : null;
        this.queryOnline = this.queryOnline != null ? this.queryOnline.replace("\n", " ") : null;
    }

    public String getStorageQuery(Storage storage) throws FeatureStoreException {
        switch (storage) {
            case OFFLINE: {
                if (!Strings.isNullOrEmpty((String)this.pitQuery)) {
                    return this.pitQuery;
                }
                return this.query;
            }
            case ONLINE: {
                return this.queryOnline;
            }
        }
        throw new FeatureStoreException("Cannot run query on ALL storages");
    }

    public FsQuery(String query, String queryOnline, String pitQuery, List<OnDemandFeatureGroupAlias> onDemandFeatureGroups, List<HudiFeatureGroupAlias> hudiCachedFeatureGroups) {
        this.query = query;
        this.queryOnline = queryOnline;
        this.pitQuery = pitQuery;
        this.onDemandFeatureGroups = onDemandFeatureGroups;
        this.hudiCachedFeatureGroups = hudiCachedFeatureGroups;
    }

    public FsQuery() {
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getQueryOnline() {
        return this.queryOnline;
    }

    public void setQueryOnline(String queryOnline) {
        this.queryOnline = queryOnline;
    }

    public String getPitQuery() {
        return this.pitQuery;
    }

    public void setPitQuery(String pitQuery) {
        this.pitQuery = pitQuery;
    }

    public List<OnDemandFeatureGroupAlias> getOnDemandFeatureGroups() {
        return this.onDemandFeatureGroups;
    }

    public void setOnDemandFeatureGroups(List<OnDemandFeatureGroupAlias> onDemandFeatureGroups) {
        this.onDemandFeatureGroups = onDemandFeatureGroups;
    }

    public List<HudiFeatureGroupAlias> getHudiCachedFeatureGroups() {
        return this.hudiCachedFeatureGroups;
    }

    public void setHudiCachedFeatureGroups(List<HudiFeatureGroupAlias> hudiCachedFeatureGroups) {
        this.hudiCachedFeatureGroups = hudiCachedFeatureGroups;
    }
}

