/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.engine;

import com.amazon.deequ.checks.Check;
import com.amazon.deequ.checks.CheckResult;
import com.amazon.deequ.constraints.ConstraintResult;
import com.amazon.deequ.metrics.Metric;
import com.logicalclocks.hsfs.EntityEndpointType;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.engine.Constraint;
import com.logicalclocks.hsfs.engine.ConstraintGroup;
import com.logicalclocks.hsfs.engine.DeequEngine;
import com.logicalclocks.hsfs.metadata.Expectation;
import com.logicalclocks.hsfs.metadata.ExpectationResult;
import com.logicalclocks.hsfs.metadata.FeatureGroupBase;
import com.logicalclocks.hsfs.metadata.FeatureGroupValidation;
import com.logicalclocks.hsfs.metadata.FeatureGroupValidationsApi;
import com.logicalclocks.hsfs.metadata.ValidationResult;
import com.logicalclocks.hsfs.metadata.validation.AcceptedType;
import com.logicalclocks.hsfs.metadata.validation.Level;
import com.logicalclocks.hsfs.metadata.validation.Rule;
import com.logicalclocks.hsfs.metadata.validation.RuleName;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import scala.Option;
import scala.collection.Iterator;
import scala.collection.JavaConverters;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;

public class DataValidationEngine {
    private static DataValidationEngine INSTANCE = null;
    private final FeatureGroupValidationsApi featureGroupValidationsApi = new FeatureGroupValidationsApi(EntityEndpointType.FEATURE_GROUP);

    public static synchronized DataValidationEngine getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DataValidationEngine();
        }
        return INSTANCE;
    }

    public FeatureGroupValidation validate(Dataset<Row> data, FeatureGroupBase featureGroupBase, List<Expectation> expectations) throws FeatureStoreException, IOException {
        List<ExpectationResult> expectationResults = this.validate(data, expectations);
        return this.featureGroupValidationsApi.put(featureGroupBase, FeatureGroupValidation.builder().validationTime(Instant.now().toEpochMilli()).expectationResults(expectationResults).build());
    }

    public List<ExpectationResult> validate(Dataset<Row> data, List<Expectation> expectations) {
        ArrayList<ExpectationResult> expectationResults = new ArrayList<ExpectationResult>();
        for (Expectation expectation : expectations) {
            ArrayList<ConstraintGroup> constraintGroups = new ArrayList<ConstraintGroup>();
            HashMap constraintGroupLevels = new HashMap();
            ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
            for (Rule rule : expectation.getRules()) {
                boolean pair = this.isRuleAppliedToFeaturePairs(rule);
                if (pair) {
                    Constraint constraint = new Constraint(rule.getName().name(), (Option<String>)Option.apply((Object)rule.getName().name()), (Option<Seq<String>>)Option.apply((Object)((Buffer)JavaConverters.asScalaBufferConverter(expectation.getFeatures().subList(0, 2)).asScala()).toSeq()), (Option<Object>)Option.apply((Object)rule.getMin()), (Option<Object>)Option.apply((Object)rule.getMax()), (Option<String>)Option.apply(null), (Option<String>)Option.apply(null), (Option<AcceptedType>)Option.apply(null), (Option<String[]>)Option.apply(null));
                    if (!constraintGroupLevels.containsKey((Object)rule.getLevel())) {
                        constraintGroupLevels.put(rule.getLevel(), new ArrayList());
                    }
                    ((List)constraintGroupLevels.get((Object)rule.getLevel())).add(constraint);
                    continue;
                }
                for (String feature : expectation.getFeatures()) {
                    String[] legalValues = null;
                    if (rule.getLegalValues() != null && !rule.getLegalValues().isEmpty()) {
                        legalValues = rule.getLegalValues().toArray(new String[0]);
                    }
                    Constraint constraint = new Constraint(rule.getName().name(), (Option<String>)Option.apply((Object)rule.getName().name()), (Option<Seq<String>>)Option.apply((Object)((Buffer)JavaConverters.asScalaBufferConverter(Collections.singletonList(feature)).asScala()).toSeq()), (Option<Object>)Option.apply((Object)rule.getMin()), (Option<Object>)Option.apply((Object)rule.getMax()), (Option<String>)Option.apply((Object)rule.getValue()), (Option<String>)Option.apply((Object)rule.getPattern()), (Option<AcceptedType>)Option.apply((Object)((Object)rule.getAcceptedType())), (Option<String[]>)Option.apply((Object)legalValues));
                    if (!constraintGroupLevels.containsKey((Object)rule.getLevel())) {
                        constraintGroupLevels.put(rule.getLevel(), new ArrayList());
                    }
                    ((List)constraintGroupLevels.get((Object)rule.getLevel())).add(constraint);
                }
            }
            if (!constraintGroupLevels.isEmpty()) {
                for (Level level : constraintGroupLevels.keySet()) {
                    ConstraintGroup constraintGroup = new ConstraintGroup(level.name(), level.name(), (Seq<Constraint>)((Iterator)JavaConverters.asScalaIteratorConverter(((List)constraintGroupLevels.get((Object)level)).iterator()).asScala()).toSeq());
                    constraintGroups.add(constraintGroup);
                }
            }
            Map<Check, CheckResult> deequResults = DeequEngine.runVerification(data, (Seq<ConstraintGroup>)((Iterator)JavaConverters.asScalaIteratorConverter(constraintGroups.iterator()).asScala()).toSeq());
            for (Check check : deequResults.keySet()) {
                List<ConstraintResult> constraintResultsList = DeequEngine.getConstraintResults((Seq<ConstraintResult>)deequResults.get(check).constraintResults());
                for (ConstraintResult constraintResult : constraintResultsList) {
                    boolean featuresEqual;
                    String deequRule;
                    String[] constraintInfo = constraintResult.constraint().toString().split("\\W+");
                    String constraintType = constraintInfo[1];
                    ArrayList<String> deequFeatures = new ArrayList<String>();
                    boolean constraintTypeComplex = false;
                    if (constraintType.equals("Compliance")) {
                        constraintTypeComplex = true;
                        if (constraintResult.constraint().toString().contains("contained in")) {
                            deequRule = "iscontainedin";
                            deequFeatures.add(constraintInfo[2]);
                            featuresEqual = deequFeatures.stream().anyMatch(expectation.getFeatures()::contains);
                        } else if (constraintResult.constraint().toString().contains("is positive")) {
                            deequRule = "ispositive";
                            deequFeatures.add(constraintInfo[2]);
                            featuresEqual = deequFeatures.stream().anyMatch(expectation.getFeatures()::contains);
                        } else {
                            deequRule = String.join((CharSequence)"", (CharSequence[])Arrays.stream(constraintInfo, 3, 6).toArray(String[]::new));
                            deequFeatures.addAll(Arrays.asList(Arrays.stream(constraintInfo, constraintInfo.length - 3, constraintInfo.length - 2 + 1).toArray(String[]::new)));
                            featuresEqual = new ArrayList(deequFeatures).equals(new ArrayList<String>(expectation.getFeatures()).subList(0, 2));
                        }
                    } else {
                        deequRule = constraintInfo[1];
                        if (deequRule.equalsIgnoreCase("MutualInformation") || constraintType.equals("Correlation")) {
                            constraintTypeComplex = true;
                            if (constraintType.equals("MutualInformation")) {
                                deequFeatures.add(constraintInfo[3]);
                                deequFeatures.add(constraintInfo[4]);
                            } else {
                                deequFeatures.add(constraintInfo[2]);
                                deequFeatures.add(constraintInfo[3]);
                            }
                            featuresEqual = new ArrayList(deequFeatures).equals(new ArrayList<String>(expectation.getFeatures()).subList(0, 2));
                        } else {
                            deequFeatures.add(constraintInfo[2]);
                            featuresEqual = deequFeatures.stream().anyMatch(expectation.getFeatures()::contains);
                        }
                    }
                    RuleName ruleName = this.getRuleNameFromDeequ(deequRule);
                    if (constraintTypeComplex) {
                        for (Rule rule : expectation.getRules()) {
                            if (rule.getName() != ruleName || !featuresEqual) continue;
                            validationResults.add(ValidationResult.builder().status(ExpectationResult.Status.fromDeequStatus(constraintResult.status(), rule.getLevel())).features(deequFeatures).rule(rule).message(!constraintResult.message().isEmpty() ? (String)constraintResult.message().get() : "Success").value(String.valueOf(((Metric)constraintResult.metric().get()).value().get())).build());
                        }
                        continue;
                    }
                    block7: for (String feature : expectation.getFeatures()) {
                        for (Rule rule : expectation.getRules()) {
                            if (rule.getName() != ruleName || !feature.equals(constraintInfo[2])) continue;
                            validationResults.add(ValidationResult.builder().status(ExpectationResult.Status.fromDeequStatus(constraintResult.status(), rule.getLevel())).features(Collections.singletonList(feature)).rule(rule).message(!constraintResult.message().isEmpty() ? (String)constraintResult.message().get() : "Success").value(String.valueOf(((Metric)constraintResult.metric().get()).value().get())).build());
                            continue block7;
                        }
                    }
                }
            }
            expectationResults.add(ExpectationResult.builder().expectation(expectation).results(validationResults).build());
        }
        return expectationResults;
    }

    public List<FeatureGroupValidation> getValidations(FeatureGroupBase featureGroupBase) throws FeatureStoreException, IOException {
        return this.featureGroupValidationsApi.get(featureGroupBase);
    }

    public FeatureGroupValidation getValidation(FeatureGroupBase featureGroupBase, ImmutablePair<ValidationTimeType, Long> pair) throws FeatureStoreException, IOException {
        return this.featureGroupValidationsApi.get(featureGroupBase, pair);
    }

    public RuleName getRuleNameFromDeequ(String rule) {
        switch (rule.toLowerCase()) {
            case "maximum": {
                return RuleName.HAS_MAX;
            }
            case "minimum": {
                return RuleName.HAS_MIN;
            }
            case "mean": {
                return RuleName.HAS_MEAN;
            }
            case "size": {
                return RuleName.HAS_SIZE;
            }
            case "sum": {
                return RuleName.HAS_SUM;
            }
            case "completeness": {
                return RuleName.HAS_COMPLETENESS;
            }
            case "uniqueness": {
                return RuleName.HAS_UNIQUENESS;
            }
            case "distinctness": {
                return RuleName.HAS_DISTINCTNESS;
            }
            case "uniquevalueratio": {
                return RuleName.HAS_UNIQUE_VALUE_RATIO;
            }
            case "histogram": {
                return RuleName.HAS_NUMBER_OF_DISTINCT_VALUES;
            }
            case "entropy": {
                return RuleName.HAS_ENTROPY;
            }
            case "mutualinformation": {
                return RuleName.HAS_MUTUAL_INFORMATION;
            }
            case "approxquantile": {
                return RuleName.HAS_APPROX_QUANTILE;
            }
            case "standarddeviation": {
                return RuleName.HAS_STANDARD_DEVIATION;
            }
            case "approxcountdistinct": {
                return RuleName.HAS_APPROX_COUNT_DISTINCT;
            }
            case "correlation": {
                return RuleName.HAS_CORRELATION;
            }
            case "patternmatch": {
                return RuleName.HAS_PATTERN;
            }
            case "minlength": {
                return RuleName.HAS_MIN_LENGTH;
            }
            case "maxlength": {
                return RuleName.HAS_MAX_LENGTH;
            }
            case "datatype": {
                return RuleName.HAS_DATATYPE;
            }
            case "isnonnegative": {
                return RuleName.IS_NON_NEGATIVE;
            }
            case "ispositive": {
                return RuleName.IS_POSITIVE;
            }
            case "islessthan": {
                return RuleName.IS_LESS_THAN;
            }
            case "islessthanorequalto": {
                return RuleName.IS_LESS_THAN_OR_EQUAL_TO;
            }
            case "isgreaterthan": {
                return RuleName.IS_GREATER_THAN;
            }
            case "isgreaterthanorequalto": {
                return RuleName.IS_GREATER_THAN_OR_EQUAL_TO;
            }
            case "iscontainedin": {
                return RuleName.IS_CONTAINED_IN;
            }
        }
        throw new UnsupportedOperationException("Deequ rule not supported: " + rule);
    }

    public boolean isRuleAppliedToFeaturePairs(Rule rule) {
        return rule.getName() == RuleName.IS_GREATER_THAN_OR_EQUAL_TO || rule.getName() == RuleName.IS_GREATER_THAN || rule.getName() == RuleName.IS_LESS_THAN || rule.getName() == RuleName.IS_LESS_THAN_OR_EQUAL_TO || rule.getName() == RuleName.HAS_MUTUAL_INFORMATION || rule.getName() == RuleName.HAS_CORRELATION;
    }

    public static enum ValidationTimeType {
        VALIDATION_TIME,
        COMMIT_TIME;

    }
}

