/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.metadata;

import com.damnhandy.uri.template.UriTemplate;
import com.logicalclocks.hsfs.EntityEndpointType;
import com.logicalclocks.hsfs.FeatureStore;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.metadata.Expectation;
import com.logicalclocks.hsfs.metadata.FeatureGroupBase;
import com.logicalclocks.hsfs.metadata.HopsworksClient;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpectationsApi {
    public static final String ENTITY_ROOT_PATH = "{/entityType}";
    public static final String ENTITY_ID_PATH = "{/entityType}{/entityId}";
    public static final String EXPECTATIONS_PATH = "{/entityType}{/entityId}/expectations{/name}{?engine,filter_by,sort_by,offset,limit,expand}";
    private static final Logger LOGGER = LoggerFactory.getLogger(ExpectationsApi.class);
    private EntityEndpointType entityType;

    public ExpectationsApi() {
    }

    public ExpectationsApi(EntityEndpointType entityType) {
        this.entityType = entityType;
        LOGGER.info("ExpectationsApi.EXPECTATIONS_PATH:{/entityType}{/entityId}/expectations{/name}{?engine,filter_by,sort_by,offset,limit,expand}");
    }

    public Expectation put(FeatureStore featureStore, Expectation expectation) throws FeatureStoreException, IOException {
        return this.put(featureStore.getProjectId(), featureStore.getId(), expectation);
    }

    public Expectation put(FeatureGroupBase featureGroupBase, String name) throws FeatureStoreException, IOException {
        return this.put(featureGroupBase.getFeatureStore().getProjectId(), featureGroupBase.getId(), featureGroupBase.getFeatureStore().getId(), name);
    }

    private Expectation put(Integer projectId, Integer featurestoreId, Expectation expectation) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}{/entityType}{/entityId}/expectations{/name}{?engine,filter_by,sort_by,offset,limit,expand}";
        String uri = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)projectId).set("fsId", (Object)featurestoreId).expand();
        String expectationStr = hopsworksClient.getObjectMapper().writeValueAsString((Object)expectation);
        HttpPut putRequest = new HttpPut(uri);
        putRequest.setHeader("Content-Type", "application/json");
        putRequest.setEntity((HttpEntity)new StringEntity(expectationStr));
        LOGGER.info("Sending metadata request: " + uri);
        LOGGER.info(expectationStr);
        return hopsworksClient.handleRequest((HttpRequest)putRequest, Expectation.class);
    }

    private Expectation put(Integer projectId, Integer entityId, Integer featurestoreId, String name) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}{/entityType}{/entityId}/expectations{/name}{?engine,filter_by,sort_by,offset,limit,expand}";
        LOGGER.info("pathTemplate: " + pathTemplate);
        String uri = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)projectId).set("fsId", (Object)featurestoreId).set("entityType", (Object)this.entityType.getValue()).set("entityId", (Object)entityId).set("name", (Object)name).expand();
        HttpPut putRequest = new HttpPut(uri);
        LOGGER.info("Sending metadata request: " + uri);
        return hopsworksClient.handleRequest((HttpRequest)putRequest, Expectation.class);
    }

    public void detach(FeatureGroupBase featureGroupBase) throws FeatureStoreException, IOException {
        for (Expectation expectation : this.get(featureGroupBase)) {
            this.detach(featureGroupBase, expectation);
        }
    }

    public void detach(FeatureGroupBase featureGroupBase, Expectation expectation) throws FeatureStoreException, IOException {
        this.delete(featureGroupBase.getFeatureStore().getProjectId(), featureGroupBase.getId(), featureGroupBase.getFeatureStore().getId(), expectation.getName());
    }

    public void detach(FeatureGroupBase featureGroupBase, String name) throws FeatureStoreException, IOException {
        this.delete(featureGroupBase.getFeatureStore().getProjectId(), featureGroupBase.getId(), featureGroupBase.getFeatureStore().getId(), name);
    }

    public void delete(FeatureStore featureStore) throws FeatureStoreException, IOException {
        for (Expectation expectation : this.get(featureStore)) {
            this.delete(featureStore, expectation);
        }
    }

    public void delete(FeatureStore featureStore, Expectation expectation) throws FeatureStoreException, IOException {
        this.delete(featureStore.getProjectId(), null, featureStore.getId(), expectation.getName());
    }

    public void delete(FeatureStore featureStore, String name) throws FeatureStoreException, IOException {
        this.delete(featureStore.getProjectId(), null, featureStore.getId(), name);
    }

    private void delete(Integer projectId, Integer entityId, Integer featurestoreId, String name) throws FeatureStoreException, IOException {
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}{/entityType}{/entityId}/expectations{/name}{?engine,filter_by,sort_by,offset,limit,expand}";
        LOGGER.info("pathTemplate: " + pathTemplate);
        UriTemplate uriTemplate = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)projectId).set("fsId", (Object)featurestoreId).set("name", (Object)name);
        if (entityId != null) {
            uriTemplate.set("entityType", (Object)this.entityType.getValue()).set("entityId", (Object)entityId);
        }
        String uri = uriTemplate.expand();
        HttpDelete deleteRequest = new HttpDelete(uri);
        LOGGER.info("Sending metadata request: " + uri);
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        hopsworksClient.handleRequest((HttpRequest)deleteRequest);
    }

    public List<Expectation> get(FeatureStore featureStore) throws FeatureStoreException, IOException {
        return this.get(featureStore.getProjectId(), null, featureStore.getId(), null);
    }

    public Expectation get(FeatureStore featureStore, String name) throws FeatureStoreException, IOException {
        List<Expectation> expectations = this.get(featureStore.getProjectId(), null, featureStore.getId(), name);
        return !expectations.isEmpty() ? expectations.get(0) : null;
    }

    public List<Expectation> get(FeatureGroupBase featureGroupBase) throws FeatureStoreException, IOException {
        return this.get(featureGroupBase.getFeatureStore().getProjectId(), featureGroupBase.getId(), featureGroupBase.getFeatureStore().getId(), null);
    }

    public List<Expectation> get(Integer projectId, Integer featuregroupId, Integer featurestoreId) throws FeatureStoreException, IOException {
        return this.get(projectId, featuregroupId, featurestoreId, null);
    }

    public Expectation get(FeatureGroupBase featureGroupBase, String name) throws FeatureStoreException, IOException {
        List<Expectation> expectations = this.get(featureGroupBase.getFeatureStore().getProjectId(), null, featureGroupBase.getFeatureStore().getId(), name);
        return !expectations.isEmpty() ? expectations.get(0) : null;
    }

    private List<Expectation> get(Integer projectId, Integer entityId, Integer featurestoreId, String name) throws FeatureStoreException, IOException {
        List<Expectation> expectations;
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}{/entityType}{/entityId}/expectations{/name}{?engine,filter_by,sort_by,offset,limit,expand}";
        UriTemplate uriTemplate = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)projectId).set("fsId", (Object)featurestoreId).set("expand", (Object)"rules");
        if (entityId != null) {
            uriTemplate.set("entityType", (Object)this.entityType.getValue()).set("entityId", (Object)entityId);
        }
        if (name != null) {
            uriTemplate.set("name", (Object)name);
        }
        String uri = uriTemplate.expand();
        LOGGER.info("Sending metadata request: " + uri);
        HttpGet getRequest = new HttpGet(uri);
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        Expectation dto = hopsworksClient.handleRequest((HttpRequest)getRequest, Expectation.class);
        LOGGER.info("Received expectations dto: " + dto);
        if (dto.getCount() == null) {
            expectations = new ArrayList();
            expectations.add(dto);
        } else {
            expectations = dto.getItems();
        }
        LOGGER.info("Received expectations: " + expectations);
        return expectations;
    }
}

