/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.engine;

import com.google.common.base.Strings;
import com.logicalclocks.hsfs.EntityEndpointType;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.TrainingDataset;
import com.logicalclocks.hsfs.metadata.Code;
import com.logicalclocks.hsfs.metadata.CodeApi;
import com.logicalclocks.hsfs.metadata.FeatureGroupBase;
import java.io.IOException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeEngine {
    private CodeApi codeApi;
    private static final String KERNEL_ENV = "HOPSWORKS_KERNEL_ID";
    private static final String WEB_PROXY_ENV = "APPLICATION_WEB_PROXY_BASE";
    private static final Logger LOGGER = LoggerFactory.getLogger(CodeEngine.class);

    public CodeEngine(EntityEndpointType entityType) {
        this.codeApi = new CodeApi(entityType);
    }

    public Code saveCode(TrainingDataset trainingDataset) throws FeatureStoreException, IOException {
        String kernelId = System.getenv(KERNEL_ENV);
        if (Strings.isNullOrEmpty((String)kernelId)) {
            return null;
        }
        return this.codeApi.post(trainingDataset, this.saveCode(), kernelId, Code.RunType.JUPYTER);
    }

    public Code saveCode(FeatureGroupBase featureGroup) throws FeatureStoreException, IOException {
        String kernelId = System.getenv(KERNEL_ENV);
        if (Strings.isNullOrEmpty((String)kernelId)) {
            return null;
        }
        return this.codeApi.post(featureGroup, this.saveCode(), kernelId, Code.RunType.JUPYTER);
    }

    private Code saveCode() {
        Long commitTime = Timestamp.valueOf(LocalDateTime.now()).getTime();
        String applicationId = null;
        String webProxy = System.getenv(WEB_PROXY_ENV);
        if (!Strings.isNullOrEmpty((String)webProxy)) {
            applicationId = webProxy.substring(7);
        }
        return new Code(commitTime, applicationId);
    }
}

