/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.metadata;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.logicalclocks.hsfs.FeatureStore;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.engine.ExpectationsEngine;
import com.logicalclocks.hsfs.metadata.RestDto;
import com.logicalclocks.hsfs.metadata.validation.Rule;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import scala.collection.JavaConverters;
import scala.collection.Seq;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Expectation
extends RestDto<Expectation> {
    private String name;
    private String description;
    private List<String> features = new ArrayList<String>();
    private List<Rule> rules;
    @JsonIgnore
    private FeatureStore featureStore;
    private final ExpectationsEngine expectationsEngine = new ExpectationsEngine();

    public void save() throws FeatureStoreException, IOException {
        this.expectationsEngine.save(this);
    }

    public static ExpectationBuilder builder() {
        return new ExpectationBuilder();
    }

    public Expectation() {
    }

    public Expectation(String name, String description, List<String> features, List<Rule> rules, FeatureStore featureStore) {
        this.name = name;
        this.description = description;
        this.features = features;
        this.rules = rules;
        this.featureStore = featureStore;
    }

    public String toString() {
        return "Expectation(name=" + this.getName() + ", description=" + this.getDescription() + ", features=" + this.getFeatures() + ", rules=" + this.getRules() + ", featureStore=" + this.getFeatureStore() + ", expectationsEngine=" + this.expectationsEngine + ")";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<String> getFeatures() {
        return this.features;
    }

    public void setFeatures(List<String> features) {
        this.features = features;
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    public void setRules(List<Rule> rules) {
        this.rules = rules;
    }

    public FeatureStore getFeatureStore() {
        return this.featureStore;
    }

    public void setFeatureStore(FeatureStore featureStore) {
        this.featureStore = featureStore;
    }

    public static class ExpectationBuilder {
        private String name;
        private String description;
        private List<String> features;
        private List<Rule> rules;
        private FeatureStore featureStore;

        public ExpectationBuilder features(List<String> features) {
            this.features = features;
            return this;
        }

        public ExpectationBuilder features(Seq<String> features) {
            this.features = (List)JavaConverters.seqAsJavaListConverter(features).asJava();
            return this;
        }

        public ExpectationBuilder rules(Seq<Rule> rules) {
            this.rules = (List)JavaConverters.seqAsJavaListConverter(rules).asJava();
            return this;
        }

        public ExpectationBuilder rules(List<Rule> rules) {
            this.rules = rules;
            return this;
        }

        ExpectationBuilder() {
        }

        public ExpectationBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ExpectationBuilder description(String description) {
            this.description = description;
            return this;
        }

        public ExpectationBuilder featureStore(FeatureStore featureStore) {
            this.featureStore = featureStore;
            return this;
        }

        public Expectation build() {
            return new Expectation(this.name, this.description, this.features, this.rules, this.featureStore);
        }

        public String toString() {
            return "Expectation.ExpectationBuilder(name=" + this.name + ", description=" + this.description + ", features=" + this.features + ", rules=" + this.rules + ", featureStore=" + this.featureStore + ")";
        }
    }
}

