/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.engine;

import com.logicalclocks.hsfs.EntityEndpointType;
import com.logicalclocks.hsfs.Feature;
import com.logicalclocks.hsfs.FeatureGroup;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.HudiOperationType;
import com.logicalclocks.hsfs.OnDemandFeatureGroup;
import com.logicalclocks.hsfs.engine.SparkEngine;
import com.logicalclocks.hsfs.metadata.FeatureGroupApi;
import com.logicalclocks.hsfs.metadata.FeatureGroupBase;
import com.logicalclocks.hsfs.metadata.TagsApi;
import java.io.IOException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

public class FeatureGroupBaseEngine {
    protected FeatureGroupApi featureGroupApi = new FeatureGroupApi();
    protected TagsApi tagsApi = new TagsApi(EntityEndpointType.FEATURE_GROUP);

    public void delete(FeatureGroupBase featureGroupBase) throws FeatureStoreException, IOException {
        this.featureGroupApi.delete(featureGroupBase);
    }

    public void addTag(FeatureGroupBase featureGroupBase, String name, Object value) throws FeatureStoreException, IOException {
        this.tagsApi.add(featureGroupBase, name, value);
    }

    public Object getTag(FeatureGroupBase featureGroupBase, String name) throws FeatureStoreException, IOException {
        return this.tagsApi.get(featureGroupBase, name);
    }

    public Map<String, Object> getTags(FeatureGroupBase featureGroupBase) throws FeatureStoreException, IOException {
        return this.tagsApi.get(featureGroupBase);
    }

    public void deleteTag(FeatureGroupBase featureGroupBase, String name) throws FeatureStoreException, IOException {
        this.tagsApi.deleteTag(featureGroupBase, name);
    }

    public void updateDescription(FeatureGroupBase featureGroup, String description) throws FeatureStoreException, IOException {
        FeatureGroupBase fgBaseSend = this.initFeatureGroupBase(featureGroup);
        fgBaseSend.setDescription(description);
        FeatureGroupBase apiFG = this.featureGroupApi.updateMetadata(fgBaseSend, "updateMetadata");
        featureGroup.setDescription(apiFG.getDescription());
    }

    public void appendFeatures(FeatureGroupBase featureGroup, List<Feature> features) throws FeatureStoreException, IOException, ParseException {
        Dataset<Row> emptyDataframe = SparkEngine.getInstance().getEmptyAppendedDataframe(featureGroup.read(), features);
        FeatureGroupBase fgBaseSend = this.initFeatureGroupBase(featureGroup);
        features.addAll(featureGroup.getFeatures());
        fgBaseSend.setFeatures(features);
        FeatureGroupBase apiFG = this.featureGroupApi.updateMetadata(fgBaseSend, "updateMetadata");
        featureGroup.setFeatures(apiFG.getFeatures());
        if (featureGroup instanceof FeatureGroup) {
            SparkEngine.getInstance().writeOfflineDataframe((FeatureGroup)featureGroup, emptyDataframe, HudiOperationType.UPSERT, new HashMap<String, String>(), null);
        }
    }

    public void updateStatisticsConfig(FeatureGroupBase featureGroup) throws FeatureStoreException, IOException {
        FeatureGroupBase apiFG = this.featureGroupApi.updateMetadata(featureGroup, "updateStatsConfig");
        featureGroup.getStatisticsConfig().setCorrelations(apiFG.getStatisticsConfig().getCorrelations());
        featureGroup.getStatisticsConfig().setHistograms(apiFG.getStatisticsConfig().getHistograms());
    }

    private FeatureGroupBase initFeatureGroupBase(FeatureGroupBase featureGroup) {
        if (featureGroup instanceof FeatureGroup) {
            return new FeatureGroup(featureGroup.getFeatureStore(), (int)featureGroup.getId());
        }
        if (featureGroup instanceof OnDemandFeatureGroup) {
            return new OnDemandFeatureGroup(featureGroup.getFeatureStore(), (int)featureGroup.getId());
        }
        return new FeatureGroupBase();
    }

    public void updateValidationType(FeatureGroupBase featureGroupBase) throws FeatureStoreException, IOException {
        this.featureGroupApi.updateMetadata(featureGroupBase, "validationType", (Object)featureGroupBase.getValidationType());
    }
}

