/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.metadata;

import com.damnhandy.uri.template.UriTemplate;
import com.logicalclocks.hsfs.EntityEndpointType;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.engine.DataValidationEngine;
import com.logicalclocks.hsfs.metadata.FeatureGroupBase;
import com.logicalclocks.hsfs.metadata.FeatureGroupValidation;
import com.logicalclocks.hsfs.metadata.FeatureGroupValidations;
import com.logicalclocks.hsfs.metadata.HopsworksClient;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureGroupValidationsApi {
    public static final String ENTITY_ROOT_PATH = "{/entityType}";
    public static final String ENTITY_ID_PATH = "{/entityType}{/entityId}";
    public static final String RESULTS_PATH = "{/entityType}{/entityId}/validations{/id}{?filter_by,sort_by,offset,limit}";
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureGroupValidationsApi.class);
    private final EntityEndpointType entityType;

    public FeatureGroupValidationsApi(@NonNull EntityEndpointType entityType) {
        if (entityType == null) {
            throw new NullPointerException("entityType is marked non-null but is null");
        }
        this.entityType = entityType;
    }

    public List<FeatureGroupValidation> get(FeatureGroupBase featureGroupBase) throws FeatureStoreException, IOException {
        return this.get(featureGroupBase.getFeatureStore().getProjectId(), featureGroupBase.getFeatureStore().getId(), featureGroupBase.getId(), null);
    }

    public FeatureGroupValidation get(FeatureGroupBase featureGroupBase, ImmutablePair<DataValidationEngine.ValidationTimeType, Long> pair) throws FeatureStoreException, IOException {
        return this.get(featureGroupBase.getFeatureStore().getProjectId(), featureGroupBase.getFeatureStore().getId(), featureGroupBase.getId(), pair).get(0);
    }

    private List<FeatureGroupValidation> get(Integer projectId, Integer featurestoreId, Integer entityId, ImmutablePair<DataValidationEngine.ValidationTimeType, Long> pair) throws FeatureStoreException, IOException {
        List<FeatureGroupValidation> validations;
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}{/entityType}{/entityId}/validations{/id}{?filter_by,sort_by,offset,limit}";
        UriTemplate uriTemplate = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)projectId).set("fsId", (Object)featurestoreId).set("entityType", (Object)this.entityType.getValue()).set("entityId", (Object)entityId);
        if (pair != null) {
            if (pair.getLeft() == DataValidationEngine.ValidationTimeType.VALIDATION_TIME) {
                uriTemplate.set("filter_by", (Object)("validation_time_eq:" + pair.getRight()));
            } else if (pair.getLeft() == DataValidationEngine.ValidationTimeType.COMMIT_TIME) {
                uriTemplate.set("filter_by", (Object)("commit_time_eq:" + pair.getRight()));
            }
        }
        String uri = uriTemplate.expand();
        LOGGER.info("Sending metadata request: " + uri);
        HttpGet getRequest = new HttpGet(uri);
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        FeatureGroupValidation dto = hopsworksClient.handleRequest((HttpRequest)getRequest, FeatureGroupValidation.class);
        if (dto.getCount() == null) {
            validations = new ArrayList();
            validations.add(dto);
        } else {
            validations = dto.getItems();
        }
        LOGGER.info("Received validations: " + validations);
        return validations;
    }

    public FeatureGroupValidation put(FeatureGroupBase featureGroupBase, FeatureGroupValidation featureGroupValidation) throws FeatureStoreException, IOException {
        return this.put(featureGroupBase.getFeatureStore().getProjectId(), featureGroupBase.getFeatureStore().getId(), featureGroupBase.getId(), featureGroupValidation);
    }

    private FeatureGroupValidation put(Integer projectId, Integer featurestoreId, Integer entityId, FeatureGroupValidation featureGroupValidation) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}{/entityType}{/entityId}/validations{/id}{?filter_by,sort_by,offset,limit}";
        String uri = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)projectId).set("fsId", (Object)featurestoreId).set("entityType", (Object)this.entityType.getValue()).set("entityId", (Object)entityId).expand();
        FeatureGroupValidations validations = FeatureGroupValidations.builder().expectationResults(featureGroupValidation.getExpectationResults()).validationTime(featureGroupValidation.getValidationTime()).build();
        String results = hopsworksClient.getObjectMapper().writeValueAsString((Object)validations);
        HttpPut putRequest = new HttpPut(uri);
        putRequest.setHeader("Content-Type", "application/json");
        putRequest.setEntity((HttpEntity)new StringEntity(results));
        LOGGER.info("Sending metadata request: " + uri);
        LOGGER.info(results);
        return hopsworksClient.handleRequest((HttpRequest)putRequest, FeatureGroupValidation.class);
    }
}

