/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.engine;

import com.amazon.deequ.VerificationSuite$;
import com.amazon.deequ.checks.Check;
import com.amazon.deequ.checks.Check$;
import com.amazon.deequ.checks.CheckLevel$;
import com.amazon.deequ.checks.CheckResult;
import com.amazon.deequ.checks.CheckWithLastConstraintFilterable;
import com.amazon.deequ.constraints.ConstrainableDataTypes$;
import com.amazon.deequ.constraints.ConstraintResult;
import com.logicalclocks.hsfs.engine.Constraint;
import com.logicalclocks.hsfs.engine.ConstraintGroup;
import java.io.Serializable;
import java.util.List;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction1;

public final class DeequEngine$ {
    public static DeequEngine$ MODULE$;

    static {
        new DeequEngine$();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Function1<Object, Object> longBoundary(Option<Object> min, Option<Object> max) {
        Tuple2 tuple2 = new Tuple2(min, max);
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                double x = BoxesRunTime.unboxToDouble((Object)some.value());
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    double y = BoxesRunTime.unboxToDouble((Object)some2.value());
                    return (JFunction1.mcZJ.sp & Serializable & scala.Serializable)v -> (double)v >= x && (double)v <= y;
                }
            }
        }
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option3 = (Option)tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                double x = BoxesRunTime.unboxToDouble((Object)some.value());
                if (None$.MODULE$.equals(option3)) {
                    return (JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$1 -> (double)x$1 >= x;
                }
            }
        }
        if (tuple2 == null) return (JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$3 -> true;
        Option option = (Option)tuple2._1();
        Option option4 = (Option)tuple2._2();
        if (!None$.MODULE$.equals(option)) return (JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$3 -> true;
        if (!(option4 instanceof Some)) return (JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$3 -> true;
        Some some = (Some)option4;
        double y = BoxesRunTime.unboxToDouble((Object)some.value());
        return (JFunction1.mcZJ.sp & Serializable & scala.Serializable)x$2 -> (double)x$2 <= y;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Function1<Object, Object> doubleBoundary(Option<Object> min, Option<Object> max) {
        Tuple2 tuple2 = new Tuple2(min, max);
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                double x = BoxesRunTime.unboxToDouble((Object)some.value());
                if (option2 instanceof Some) {
                    Some some2 = (Some)option2;
                    double y = BoxesRunTime.unboxToDouble((Object)some2.value());
                    return (JFunction1.mcZD.sp & Serializable & scala.Serializable)v -> v >= x && v <= y;
                }
            }
        }
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option3 = (Option)tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                double x = BoxesRunTime.unboxToDouble((Object)some.value());
                if (None$.MODULE$.equals(option3)) {
                    return (JFunction1.mcZD.sp & Serializable & scala.Serializable)x$4 -> x$4 >= x;
                }
            }
        }
        if (tuple2 == null) return (JFunction1.mcZD.sp & Serializable & scala.Serializable)x$6 -> true;
        Option option = (Option)tuple2._1();
        Option option4 = (Option)tuple2._2();
        if (!None$.MODULE$.equals(option)) return (JFunction1.mcZD.sp & Serializable & scala.Serializable)x$6 -> true;
        if (!(option4 instanceof Some)) return (JFunction1.mcZD.sp & Serializable & scala.Serializable)x$6 -> true;
        Some some = (Some)option4;
        double y = BoxesRunTime.unboxToDouble((Object)some.value());
        return (JFunction1.mcZD.sp & Serializable & scala.Serializable)x$5 -> x$5 <= y;
    }

    public Check addConstraint(Check check, Constraint constraint) {
        CheckWithLastConstraintFilterable checkWithLastConstraintFilterable;
        String string = constraint.name();
        if ("HAS_MEAN".equals(string)) {
            checkWithLastConstraintFilterable = check.hasMean((String)((IterableLike)constraint.columns().get()).head(), this.doubleBoundary(constraint.min(), constraint.max()), constraint.hint());
        } else if ("HAS_MIN".equals(string)) {
            checkWithLastConstraintFilterable = check.hasMin((String)((IterableLike)constraint.columns().get()).head(), this.doubleBoundary(constraint.min(), constraint.max()), constraint.hint());
        } else if ("HAS_MAX".equals(string)) {
            checkWithLastConstraintFilterable = check.hasMax((String)((IterableLike)constraint.columns().get()).head(), this.doubleBoundary(constraint.min(), constraint.max()), constraint.hint());
        } else if ("HAS_SUM".equals(string)) {
            checkWithLastConstraintFilterable = check.hasSum((String)((IterableLike)constraint.columns().get()).head(), this.doubleBoundary(constraint.min(), constraint.max()), constraint.hint());
        } else if ("HAS_SIZE".equals(string)) {
            checkWithLastConstraintFilterable = check.hasSize(this.longBoundary(constraint.min(), constraint.max()), constraint.hint());
        } else if ("HAS_COMPLETENESS".equals(string)) {
            checkWithLastConstraintFilterable = check.hasCompleteness((String)((IterableLike)constraint.columns().get()).head(), this.doubleBoundary(constraint.min(), constraint.max()), constraint.hint());
        } else if ("HAS_UNIQUENESS".equals(string)) {
            checkWithLastConstraintFilterable = check.hasUniqueness((Seq)constraint.columns().get(), this.doubleBoundary(constraint.min(), constraint.max()), constraint.hint());
        } else if ("HAS_DISTINCTNESS".equals(string)) {
            checkWithLastConstraintFilterable = check.hasDistinctness((Seq)constraint.columns().get(), this.doubleBoundary(constraint.min(), constraint.max()), constraint.hint());
        } else if ("HAS_UNIQUE_VALUE_RATIO".equals(string)) {
            checkWithLastConstraintFilterable = check.hasUniqueValueRatio((Seq)constraint.columns().get(), this.doubleBoundary(constraint.min(), constraint.max()), constraint.hint());
        } else if ("HAS_NUMBER_OF_DISTINCT_VALUES".equals(string)) {
            String x$1 = (String)((IterableLike)constraint.columns().get()).head();
            Function1<Object, Object> x$2 = this.longBoundary(constraint.min(), constraint.max());
            Option<String> x$3 = constraint.hint();
            Option x$4 = check.hasNumberOfDistinctValues$default$3();
            Integer x$5 = check.hasNumberOfDistinctValues$default$4();
            checkWithLastConstraintFilterable = check.hasNumberOfDistinctValues(x$1, x$2, x$4, x$5, x$3);
        } else if ("HAS_ENTROPY".equals(string)) {
            checkWithLastConstraintFilterable = check.hasEntropy((String)((IterableLike)constraint.columns().get()).head(), this.doubleBoundary(constraint.min(), constraint.max()), constraint.hint());
        } else if ("HAS_MUTUAL_INFORMATION".equals(string)) {
            checkWithLastConstraintFilterable = check.hasMutualInformation((String)((IterableLike)constraint.columns().get()).head(), (String)((SeqLike)constraint.columns().get()).apply(1), this.doubleBoundary(constraint.min(), constraint.max()), constraint.hint());
        } else if ("HAS_APPROX_QUANTILE".equals(string)) {
            checkWithLastConstraintFilterable = check.hasApproxQuantile((String)((IterableLike)constraint.columns().get()).head(), new StringOps(Predef$.MODULE$.augmentString((String)constraint.value().get())).toDouble(), this.doubleBoundary(constraint.min(), constraint.max()), constraint.hint());
        } else if ("HAS_STANDARD_DEVIATION".equals(string)) {
            checkWithLastConstraintFilterable = check.hasStandardDeviation((String)((IterableLike)constraint.columns().get()).head(), this.doubleBoundary(constraint.min(), constraint.max()), constraint.hint());
        } else if ("HAS_APPROX_COUNT_DISTINCT".equals(string)) {
            checkWithLastConstraintFilterable = check.hasApproxCountDistinct((String)((IterableLike)constraint.columns().get()).head(), this.doubleBoundary(constraint.min(), constraint.max()), constraint.hint());
        } else if ("HAS_CORRELATION".equals(string)) {
            checkWithLastConstraintFilterable = check.hasCorrelation((String)((IterableLike)constraint.columns().get()).head(), (String)((SeqLike)constraint.columns().get()).apply(1), this.doubleBoundary(constraint.min(), constraint.max()), constraint.hint());
        } else if ("HAS_PATTERN".equals(string)) {
            checkWithLastConstraintFilterable = check.hasPattern((String)((IterableLike)constraint.columns().get()).head(), new StringOps(Predef$.MODULE$.augmentString((String)constraint.pattern().get())).r(), this.doubleBoundary(constraint.min(), constraint.max()), constraint.hint(), check.hasPattern$default$5());
        } else if ("HAS_MIN_LENGTH".equals(string)) {
            checkWithLastConstraintFilterable = check.hasMinLength((String)((IterableLike)constraint.columns().get()).head(), this.doubleBoundary(constraint.min(), constraint.max()), constraint.hint());
        } else if ("HAS_MAX_LENGTH".equals(string)) {
            checkWithLastConstraintFilterable = check.hasMaxLength((String)((IterableLike)constraint.columns().get()).head(), this.doubleBoundary(constraint.min(), constraint.max()), constraint.hint());
        } else if ("HAS_DATATYPE".equals(string)) {
            checkWithLastConstraintFilterable = check.hasDataType((String)((IterableLike)constraint.columns().get()).head(), ConstrainableDataTypes$.MODULE$.withName(((Enum)constraint.acceptedType().get()).name()), this.doubleBoundary(constraint.min(), constraint.max()), constraint.hint());
        } else if ("IS_NON_NEGATIVE".equals(string)) {
            checkWithLastConstraintFilterable = check.isNonNegative((String)((IterableLike)constraint.columns().get()).head(), this.doubleBoundary(constraint.min(), constraint.max()), constraint.hint());
        } else if ("IS_POSITIVE".equals(string)) {
            checkWithLastConstraintFilterable = check.isPositive((String)((IterableLike)constraint.columns().get()).head(), this.doubleBoundary(constraint.min(), constraint.max()), constraint.hint());
        } else if ("IS_LESS_THAN".equals(string)) {
            checkWithLastConstraintFilterable = check.isLessThan((String)((IterableLike)constraint.columns().get()).head(), (String)((SeqLike)constraint.columns().get()).apply(1), this.doubleBoundary(constraint.min(), constraint.max()), constraint.hint());
        } else if ("IS_LESS_THAN_OR_EQUAL_TO".equals(string)) {
            checkWithLastConstraintFilterable = check.isLessThanOrEqualTo((String)((IterableLike)constraint.columns().get()).head(), (String)((SeqLike)constraint.columns().get()).apply(1), this.doubleBoundary(constraint.min(), constraint.max()), constraint.hint());
        } else if ("IS_GREATER_THAN".equals(string)) {
            checkWithLastConstraintFilterable = check.isGreaterThan((String)((IterableLike)constraint.columns().get()).head(), (String)((SeqLike)constraint.columns().get()).apply(1), this.doubleBoundary(constraint.min(), constraint.max()), constraint.hint());
        } else if ("IS_GREATER_THAN_OR_EQUAL_TO".equals(string)) {
            checkWithLastConstraintFilterable = check.isGreaterThanOrEqualTo((String)((IterableLike)constraint.columns().get()).head(), (String)((SeqLike)constraint.columns().get()).apply(1), this.doubleBoundary(constraint.min(), constraint.max()), constraint.hint());
        } else if ("IS_CONTAINED_IN".equals(string)) {
            checkWithLastConstraintFilterable = check.isContainedIn((String)((IterableLike)constraint.columns().get()).head(), (String[])constraint.legalValues().get(), this.doubleBoundary(constraint.min(), constraint.max()), constraint.hint());
        } else {
            throw new MatchError((Object)string);
        }
        return checkWithLastConstraintFilterable;
    }

    public Seq<Check> checksFromRules(Seq<ConstraintGroup> constraintGroups) {
        return (Seq)constraintGroups.map((Function1 & Serializable & scala.Serializable)group -> {
            ObjectRef check = ObjectRef.create((Object)new Check(CheckLevel$.MODULE$.withName(new StringOps(Predef$.MODULE$.augmentString(group.level().toLowerCase())).capitalize()), group.description(), Check$.MODULE$.apply$default$3()));
            group.constraints().foreach((Function1 & Serializable & scala.Serializable)constraint -> {
                check.elem = DeequEngine$.MODULE$.addConstraint((Check)check.elem, constraint);
                return BoxedUnit.UNIT;
            });
            return (Check)check.elem;
        }, Seq$.MODULE$.canBuildFrom());
    }

    public java.util.Map<Check, CheckResult> runVerification(Dataset<Row> data, Seq<ConstraintGroup> constraintGroups) {
        Seq<Check> checks = this.checksFromRules(constraintGroups);
        return (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)VerificationSuite$.MODULE$.apply().onData(data).addChecks(checks).run().checkResults()).asJava();
    }

    public List<ConstraintResult> getConstraintResults(Seq<ConstraintResult> constraintResults) {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter(constraintResults).asJava();
    }

    private DeequEngine$() {
        MODULE$ = this;
    }
}

