/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.engine;

import com.logicalclocks.hsfs.EntityEndpointType;
import com.logicalclocks.hsfs.Feature;
import com.logicalclocks.hsfs.FeatureGroup;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.HudiOperationType;
import com.logicalclocks.hsfs.OnDemandFeatureGroup;
import com.logicalclocks.hsfs.engine.SparkEngine;
import com.logicalclocks.hsfs.metadata.FeatureGroupApi;
import com.logicalclocks.hsfs.metadata.FeatureGroupBase;
import com.logicalclocks.hsfs.metadata.TagsApi;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

public class FeatureGroupBaseEngine {
    protected FeatureGroupApi featureGroupApi = new FeatureGroupApi();
    protected TagsApi tagsApi = new TagsApi(EntityEndpointType.FEATURE_GROUP);

    public void delete(FeatureGroupBase featureGroupBase) throws FeatureStoreException, IOException {
        this.featureGroupApi.delete(featureGroupBase);
    }

    public void addTag(FeatureGroupBase featureGroupBase, String name, Object value) throws FeatureStoreException, IOException {
        this.tagsApi.add(featureGroupBase, name, value);
    }

    public Object getTag(FeatureGroupBase featureGroupBase, String name) throws FeatureStoreException, IOException {
        return this.tagsApi.get(featureGroupBase, name);
    }

    public Map<String, Object> getTags(FeatureGroupBase featureGroupBase) throws FeatureStoreException, IOException {
        return this.tagsApi.get(featureGroupBase);
    }

    public void deleteTag(FeatureGroupBase featureGroupBase, String name) throws FeatureStoreException, IOException {
        this.tagsApi.deleteTag(featureGroupBase, name);
    }

    public <T extends FeatureGroupBase> void updateDescription(FeatureGroupBase featureGroup, String description, Class<T> fgClass) throws FeatureStoreException, IOException {
        featureGroup.setDescription(description);
        T apiFG = this.featureGroupApi.updateMetadata(featureGroup, "updateMetadata", fgClass);
        featureGroup.setDescription(((FeatureGroupBase)apiFG).getDescription());
    }

    public <T extends FeatureGroupBase> void updateFeatures(FeatureGroupBase featureGroup, List<Feature> features, Class<T> fgClass) throws FeatureStoreException, IOException {
        ArrayList<Feature> newFeatures = new ArrayList<Feature>();
        for (Feature feature : featureGroup.getFeatures()) {
            Optional<Feature> match = features.stream().filter(updated -> updated.getName().equalsIgnoreCase(feature.getName())).findAny();
            if (!match.isPresent()) {
                newFeatures.add(feature);
                continue;
            }
            match.get().setType(feature.getType());
            newFeatures.add(match.get());
        }
        newFeatures.addAll(features);
        featureGroup.setFeatures(newFeatures);
        T apiFG = this.featureGroupApi.updateMetadata(featureGroup, "updateMetadata", fgClass);
        featureGroup.setFeatures(((FeatureGroupBase)apiFG).getFeatures());
    }

    public <T extends FeatureGroupBase> void appendFeatures(FeatureGroupBase featureGroup, List<Feature> features, Class<T> fgClass) throws FeatureStoreException, IOException, ParseException {
        Dataset<Row> emptyDataframe = SparkEngine.getInstance().getEmptyAppendedDataframe(featureGroup.read(), features);
        featureGroup.getFeatures().addAll(features);
        T apiFG = this.featureGroupApi.updateMetadata(featureGroup, "updateMetadata", fgClass);
        featureGroup.setFeatures(((FeatureGroupBase)apiFG).getFeatures());
        if (featureGroup instanceof FeatureGroup) {
            SparkEngine.getInstance().writeOfflineDataframe((FeatureGroup)featureGroup, emptyDataframe, HudiOperationType.UPSERT, new HashMap<String, String>(), null);
        }
    }

    public <T extends FeatureGroupBase> void updateStatisticsConfig(FeatureGroupBase featureGroup, Class<T> fgClass) throws FeatureStoreException, IOException {
        T apiFG = this.featureGroupApi.updateMetadata(featureGroup, "updateStatsConfig", fgClass);
        featureGroup.setStatisticsConfig(((FeatureGroupBase)apiFG).getStatisticsConfig());
    }

    private FeatureGroupBase initFeatureGroupBase(FeatureGroupBase featureGroup) {
        if (featureGroup instanceof FeatureGroup) {
            return new FeatureGroup(featureGroup.getFeatureStore(), (int)featureGroup.getId());
        }
        if (featureGroup instanceof OnDemandFeatureGroup) {
            return new OnDemandFeatureGroup(featureGroup.getFeatureStore(), (int)featureGroup.getId());
        }
        return new FeatureGroupBase();
    }

    public <T extends FeatureGroupBase> void updateValidationType(FeatureGroupBase featureGroupBase, Class<T> fgClass) throws FeatureStoreException, IOException {
        this.featureGroupApi.updateMetadata(featureGroupBase, "validationType", (Object)featureGroupBase.getValidationType(), fgClass);
    }
}

