/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.metadata;

import com.damnhandy.uri.template.UriTemplate;
import com.logicalclocks.hsfs.EntityEndpointType;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.TrainingDataset;
import com.logicalclocks.hsfs.metadata.Code;
import com.logicalclocks.hsfs.metadata.FeatureGroupBase;
import com.logicalclocks.hsfs.metadata.HopsworksClient;
import java.io.IOException;
import lombok.NonNull;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeApi {
    public static final String ENTITY_ROOT_PATH = "{/dataSetType}";
    public static final String ENTITY_ID_PATH = "{/dataSetType}{/dataSetId}";
    public static final String CODE_PATH = "{/dataSetType}{/dataSetId}/code{?entityId,type}";
    private static final Logger LOGGER = LoggerFactory.getLogger(CodeApi.class);
    private EntityEndpointType entityType;

    public CodeApi(@NonNull EntityEndpointType entityType) {
        if (entityType == null) {
            throw new NullPointerException("entityType is marked non-null but is null");
        }
        this.entityType = entityType;
    }

    public Code post(FeatureGroupBase featureGroup, Code code, String kernelId, Code.RunType type) throws FeatureStoreException, IOException {
        return this.post(featureGroup.getFeatureStore().getProjectId(), featureGroup.getFeatureStore().getId(), featureGroup.getId(), code, kernelId, type);
    }

    public Code post(TrainingDataset trainingDataset, Code code, String kernelId, Code.RunType type) throws FeatureStoreException, IOException {
        return this.post(trainingDataset.getFeatureStore().getProjectId(), trainingDataset.getFeatureStore().getId(), trainingDataset.getId(), code, kernelId, type);
    }

    private Code post(Integer projectId, Integer featureStoreId, Integer dataSetId, Code code, String entityId, Code.RunType type) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}{/dataSetType}{/dataSetId}/code{?entityId,type}";
        String uri = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)projectId).set("fsId", (Object)featureStoreId).set("dataSetType", (Object)this.entityType.getValue()).set("dataSetId", (Object)dataSetId).set("entityId", (Object)entityId).set("type", (Object)type).expand();
        String codeJson = hopsworksClient.getObjectMapper().writeValueAsString((Object)code);
        HttpPost postRequest = new HttpPost(uri);
        postRequest.setHeader("Content-Type", "application/json");
        postRequest.setEntity((HttpEntity)new StringEntity(codeJson));
        LOGGER.info("Sending metadata request: " + uri);
        LOGGER.info(codeJson);
        return hopsworksClient.handleRequest((HttpRequest)postRequest, Code.class);
    }
}

