/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.metadata;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.logicalclocks.hsfs.EntityEndpointType;
import com.logicalclocks.hsfs.Feature;
import com.logicalclocks.hsfs.FeatureStore;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.StatisticsConfig;
import com.logicalclocks.hsfs.constructor.Filter;
import com.logicalclocks.hsfs.constructor.FilterLogic;
import com.logicalclocks.hsfs.constructor.Query;
import com.logicalclocks.hsfs.engine.DataValidationEngine;
import com.logicalclocks.hsfs.engine.FeatureGroupBaseEngine;
import com.logicalclocks.hsfs.engine.StatisticsEngine;
import com.logicalclocks.hsfs.metadata.Expectation;
import com.logicalclocks.hsfs.metadata.ExpectationsApi;
import com.logicalclocks.hsfs.metadata.FeatureGroupValidation;
import com.logicalclocks.hsfs.metadata.Statistics;
import com.logicalclocks.hsfs.metadata.User;
import com.logicalclocks.hsfs.metadata.validation.ValidationType;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.JavaConverters;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;

public class FeatureGroupBase {
    protected Integer id;
    protected FeatureStore featureStore;
    protected String name;
    protected Integer version;
    protected String description;
    @JsonIgnore
    protected List<String> primaryKeys;
    protected List<Feature> features;
    protected String eventTime;
    protected Date created;
    protected User creator;
    protected StatisticsConfig statisticsConfig = new StatisticsConfig();
    protected ValidationType validationType = ValidationType.NONE;
    protected List<String> expectationsNames;
    protected String location;
    @JsonIgnore
    protected List<Expectation> expectations;
    private FeatureGroupBaseEngine featureGroupBaseEngine = new FeatureGroupBaseEngine();
    protected StatisticsEngine statisticsEngine = new StatisticsEngine(EntityEndpointType.FEATURE_GROUP);
    protected final ExpectationsApi expectationsApi = new ExpectationsApi(EntityEndpointType.FEATURE_GROUP);
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureGroupBase.class);

    public FeatureGroupBase(FeatureStore featureStore, Integer id) {
        this.featureStore = featureStore;
        this.id = id;
    }

    public Query selectFeatures(List<Feature> features) {
        return new Query(this, features);
    }

    public Query select(List<String> features) {
        List<Feature> featureObjList = features.stream().map(Feature::new).collect(Collectors.toList());
        return this.selectFeatures(featureObjList);
    }

    public Query selectAll() {
        return new Query(this, this.getFeatures());
    }

    public Query selectExceptFeatures(List<Feature> features) {
        List<String> exceptFeatures = features.stream().map(Feature::getName).collect(Collectors.toList());
        return this.selectExcept(exceptFeatures);
    }

    public Query selectExcept(List<String> features) {
        return new Query(this, this.getFeatures().stream().filter((? super T f) -> !features.contains(f.getName())).collect(Collectors.toList()));
    }

    public void delete() throws FeatureStoreException, IOException {
        this.featureGroupBaseEngine.delete(this);
    }

    public Dataset<Row> read() throws FeatureStoreException, IOException {
        return null;
    }

    public void addTag(String name, Object value) throws FeatureStoreException, IOException {
        this.featureGroupBaseEngine.addTag(this, name, value);
    }

    @JsonIgnore
    public Map<String, Object> getTags() throws FeatureStoreException, IOException {
        return this.featureGroupBaseEngine.getTags(this);
    }

    @JsonIgnore
    public Object getTag(String name) throws FeatureStoreException, IOException {
        return this.featureGroupBaseEngine.getTag(this, name);
    }

    public void deleteTag(String name) throws FeatureStoreException, IOException {
        this.featureGroupBaseEngine.deleteTag(this, name);
    }

    public void updateDescription(String description) throws FeatureStoreException, IOException {
        this.featureGroupBaseEngine.updateDescription(this, description, this.getClass());
    }

    public void updateFeatureDescription(String featureName, String description) throws FeatureStoreException, IOException {
        this.featureGroupBaseEngine.updateFeatures(this, Collections.singletonList(Feature.builder().name(featureName).description(description).type("tmp").build()), this.getClass());
    }

    public void updateFeatures(List<Feature> features) throws FeatureStoreException, IOException, ParseException {
        this.featureGroupBaseEngine.appendFeatures(this, features, this.getClass());
    }

    public void updateFeatures(Feature feature) throws FeatureStoreException, IOException, ParseException {
        this.featureGroupBaseEngine.appendFeatures(this, Collections.singletonList(feature), this.getClass());
    }

    public void appendFeatures(List<Feature> features) throws FeatureStoreException, IOException, ParseException {
        this.featureGroupBaseEngine.appendFeatures(this, new ArrayList<Feature>(features), this.getClass());
    }

    public void appendFeatures(Feature features) throws FeatureStoreException, IOException, ParseException {
        ArrayList<Feature> featureList = new ArrayList<Feature>();
        featureList.add(features);
        this.featureGroupBaseEngine.appendFeatures(this, featureList, this.getClass());
    }

    public void updateStatisticsConfig() throws FeatureStoreException, IOException {
        this.featureGroupBaseEngine.updateStatisticsConfig(this, this.getClass());
    }

    public Statistics computeStatistics() throws FeatureStoreException, IOException {
        if (this.statisticsConfig.getEnabled().booleanValue()) {
            return this.statisticsEngine.computeStatistics(this, this.read(), null);
        }
        LOGGER.info("StorageWarning: The statistics are not enabled of feature group `" + this.name + "`, with version `" + this.version + "`. No statistics computed.");
        return null;
    }

    @JsonIgnore
    public Statistics getStatistics() throws FeatureStoreException, IOException {
        return this.statisticsEngine.getLast(this);
    }

    @JsonIgnore
    public Statistics getStatistics(String commitTime) throws FeatureStoreException, IOException {
        return this.statisticsEngine.get(this, commitTime);
    }

    public Query filter(Filter filter) throws FeatureStoreException, IOException {
        return this.selectAll().filter(filter);
    }

    public Query filter(FilterLogic filter) throws FeatureStoreException, IOException {
        return this.selectAll().filter(filter);
    }

    @JsonIgnore
    public Feature getFeature(String name) throws FeatureStoreException {
        return this.features.stream().filter((? super T f) -> f.getName().equalsIgnoreCase(name)).findFirst().orElseThrow(() -> new FeatureStoreException("Feature with name `" + name + "` not found in feature group `" + this.name + "`."));
    }

    @JsonIgnore
    public List<String> getPrimaryKeys() {
        if (this.primaryKeys == null) {
            this.primaryKeys = this.features.stream().filter((? super T f) -> f.getPrimary()).map(Feature::getName).collect(Collectors.toList());
        }
        return this.primaryKeys;
    }

    public Expectation getExpectation(String name) throws FeatureStoreException, IOException {
        return this.expectationsApi.get(this, name);
    }

    @JsonIgnore
    public Seq<Expectation> getExpectations() throws FeatureStoreException, IOException {
        return ((Buffer)JavaConverters.asScalaBufferConverter(this.expectationsApi.get(this)).asScala()).toSeq();
    }

    public Seq<Expectation> attachExpectations(Seq<Expectation> expectations) throws FeatureStoreException, IOException {
        ArrayList<Expectation> expectationsList = new ArrayList<Expectation>();
        for (Expectation expectation : (List)JavaConverters.seqAsJavaListConverter(expectations).asJava()) {
            expectationsList.add(this.attachExpectation(expectation));
        }
        return ((Buffer)JavaConverters.asScalaBufferConverter(expectationsList).asScala()).toSeq();
    }

    public Expectation attachExpectation(Expectation expectation) throws FeatureStoreException, IOException {
        return this.attachExpectation(expectation.getName());
    }

    public Expectation attachExpectation(String name) throws FeatureStoreException, IOException {
        if (this.validationType == ValidationType.NONE) {
            this.updateValidationType(ValidationType.STRICT);
        }
        return this.expectationsApi.put(this, name);
    }

    public void detachExpectation(Expectation expectation) throws FeatureStoreException, IOException {
        this.detachExpectation(expectation.getName());
    }

    public void detachExpectation(String name) throws FeatureStoreException, IOException {
        this.expectationsApi.detach(this, name);
    }

    public void detachExpectations(Seq<Expectation> expectations) throws FeatureStoreException, IOException {
        for (Expectation expectation : (List)JavaConverters.seqAsJavaListConverter(expectations).asJava()) {
            this.expectationsApi.detach(this, expectation);
        }
    }

    public void updateValidationType(ValidationType validationType) throws FeatureStoreException, IOException {
        this.validationType = validationType;
        this.featureGroupBaseEngine.updateValidationType(this, this.getClass());
    }

    @JsonIgnore
    public FeatureGroupValidation getValidation(Long time, DataValidationEngine.ValidationTimeType type) throws FeatureStoreException, IOException {
        return DataValidationEngine.getInstance().getValidation(this, (ImmutablePair<DataValidationEngine.ValidationTimeType, Long>)new ImmutablePair((Object)type, (Object)time));
    }

    public FeatureGroupValidation validate() throws FeatureStoreException, IOException {
        return this.validate(this.read());
    }

    public FeatureGroupValidation validate(Dataset<Row> data) throws FeatureStoreException, IOException {
        List<Expectation> expectations = this.expectationsApi.get(this);
        ArrayList<String> features = new ArrayList<String>();
        LOGGER.debug("validate :: expectations = " + expectations);
        for (Expectation expectation : expectations) {
            if (expectation.getFeatures() != null && !expectation.getFeatures().isEmpty()) continue;
            LOGGER.debug("validate :: getFeatures = " + this.getFeatures());
            if (features.isEmpty()) {
                this.getFeatures().stream().forEach(x -> features.add(x.getName()));
            }
            expectation.setFeatures(features);
            LOGGER.debug("validate :: expectation = " + expectation);
        }
        return DataValidationEngine.getInstance().validate(data, this, expectations);
    }

    public FeatureGroupValidation validateOnDemand(Dataset<Row> data) throws FeatureStoreException, IOException {
        return this.validate(data);
    }

    @JsonIgnore
    public List<FeatureGroupValidation> getValidations() throws FeatureStoreException, IOException {
        return DataValidationEngine.getInstance().getValidations(this);
    }

    public FeatureGroupBase() {
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public FeatureStore getFeatureStore() {
        return this.featureStore;
    }

    public void setFeatureStore(FeatureStore featureStore) {
        this.featureStore = featureStore;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<Feature> getFeatures() {
        return this.features;
    }

    public void setFeatures(List<Feature> features) {
        this.features = features;
    }

    public String getEventTime() {
        return this.eventTime;
    }

    public void setEventTime(String eventTime) {
        this.eventTime = eventTime;
    }

    public Date getCreated() {
        return this.created;
    }

    public User getCreator() {
        return this.creator;
    }

    public StatisticsConfig getStatisticsConfig() {
        return this.statisticsConfig;
    }

    public void setStatisticsConfig(StatisticsConfig statisticsConfig) {
        this.statisticsConfig = statisticsConfig;
    }

    public ValidationType getValidationType() {
        return this.validationType;
    }

    public void setValidationType(ValidationType validationType) {
        this.validationType = validationType;
    }

    public List<String> getExpectationsNames() {
        return this.expectationsNames;
    }

    public void setExpectationsNames(List<String> expectationsNames) {
        this.expectationsNames = expectationsNames;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }
}

