/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.engine;

import com.logicalclocks.hsfs.Feature;
import com.logicalclocks.hsfs.FeatureGroup;
import com.logicalclocks.hsfs.FeatureGroupCommit;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.HudiOperationType;
import com.logicalclocks.hsfs.Storage;
import com.logicalclocks.hsfs.TimeTravelFormat;
import com.logicalclocks.hsfs.engine.HudiEngine;
import com.logicalclocks.hsfs.engine.SparkEngine;
import com.logicalclocks.hsfs.engine.Utils;
import com.logicalclocks.hsfs.metadata.FeatureGroupApi;
import com.logicalclocks.hsfs.metadata.FeatureGroupValidation;
import com.logicalclocks.hsfs.metadata.HopsworksClient;
import com.logicalclocks.hsfs.metadata.HopsworksHttpClient;
import com.logicalclocks.hsfs.metadata.KafkaApi;
import com.logicalclocks.hsfs.metadata.validation.ValidationType;
import java.io.IOException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.streaming.StreamingQuery;
import org.apache.spark.sql.streaming.StreamingQueryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureGroupEngine {
    private FeatureGroupApi featureGroupApi = new FeatureGroupApi();
    private HudiEngine hudiEngine = new HudiEngine();
    protected KafkaApi kafkaApi = new KafkaApi();
    private Utils utils = new Utils();
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureGroupEngine.class);

    public FeatureGroup save(FeatureGroup featureGroup, Dataset<Row> dataset, List<String> partitionKeys, String hudiPrecombineKey, Map<String, String> writeOptions) throws FeatureStoreException, IOException, ParseException {
        dataset = this.utils.sanitizeFeatureNames(dataset);
        if (featureGroup.getFeatures() == null) {
            featureGroup.setFeatures(this.utils.parseFeatureGroupSchema(dataset));
        }
        LOGGER.info("Featuregroup features: " + featureGroup.getFeatures());
        if (featureGroup.getPrimaryKeys() != null) {
            featureGroup.getPrimaryKeys().forEach(pk -> featureGroup.getFeatures().forEach(f -> {
                if (f.getName().equals(pk)) {
                    f.setPrimary(true);
                }
            }));
        }
        if (partitionKeys != null) {
            partitionKeys.forEach(pk -> featureGroup.getFeatures().forEach(f -> {
                if (f.getName().equals(pk)) {
                    f.setPartition(true);
                }
            }));
        }
        if (hudiPrecombineKey != null) {
            featureGroup.getFeatures().forEach(f -> {
                if (f.getName().equals(hudiPrecombineKey)) {
                    f.setHudiPrecombineKey(true);
                }
            });
        }
        FeatureGroup apiFG = this.featureGroupApi.save(featureGroup);
        if (featureGroup.getVersion() == null) {
            LOGGER.info("VersionWarning: No version provided for creating feature group `" + featureGroup.getName() + "`, incremented version to `" + apiFG.getVersion() + "`.");
        }
        featureGroup.setId(apiFG.getId());
        featureGroup.setVersion(apiFG.getVersion());
        featureGroup.setLocation(apiFG.getLocation());
        featureGroup.setId(apiFG.getId());
        featureGroup.setStatisticsConfig(apiFG.getStatisticsConfig());
        featureGroup.setOnlineTopicName(apiFG.getOnlineTopicName());
        if (featureGroup.getTimeTravelFormat() == TimeTravelFormat.HUDI & hudiPrecombineKey == null) {
            List<Feature> features = apiFG.getFeatures();
            featureGroup.setFeatures(features);
        }
        this.insert(featureGroup, dataset, null, featureGroup.getTimeTravelFormat() == TimeTravelFormat.HUDI ? HudiOperationType.BULK_INSERT : null, SaveMode.Append, writeOptions);
        return featureGroup;
    }

    public void insert(FeatureGroup featureGroup, Dataset<Row> featureData, Storage storage, HudiOperationType operation, SaveMode saveMode, Map<String, String> writeOptions) throws FeatureStoreException, IOException, ParseException {
        FeatureGroupValidation validation;
        Integer validationId = null;
        if (featureGroup.getValidationType() != ValidationType.NONE && (validation = featureGroup.validate(featureData, true)) != null) {
            validationId = validation.getValidationId();
        }
        if (saveMode == SaveMode.Overwrite) {
            this.featureGroupApi.deleteContent(featureGroup);
        }
        this.saveDataframe(featureGroup, featureData, storage, operation, writeOptions, this.getKafkaConfig(featureGroup, writeOptions), validationId);
    }

    public StreamingQuery insertStream(FeatureGroup featureGroup, Dataset<Row> featureData, String queryName, String outputMode, boolean awaitTermination, Long timeout, Map<String, String> writeOptions) throws FeatureStoreException, IOException, StreamingQueryException, TimeoutException {
        if (!featureGroup.getOnlineEnabled().booleanValue()) {
            throw new FeatureStoreException("Online storage is not enabled for this feature group. It is currently only possible to stream to the online storage.");
        }
        if (featureGroup.getValidationType() != ValidationType.NONE) {
            LOGGER.info("ValidationWarning: Stream ingestion for feature group `" + featureGroup.getName() + "`, with version `" + featureGroup.getVersion() + "` will not perform validation.");
        }
        return SparkEngine.getInstance().writeStreamDataframe(featureGroup, this.utils.sanitizeFeatureNames(featureData), queryName, outputMode, awaitTermination, timeout, this.getKafkaConfig(featureGroup, writeOptions));
    }

    public void saveDataframe(FeatureGroup featureGroup, Dataset<Row> dataset, Storage storage, HudiOperationType operation, Map<String, String> offlineWriteOptions, Map<String, String> onlineWriteOptions, Integer validationId) throws IOException, FeatureStoreException, ParseException {
        if (!featureGroup.getOnlineEnabled().booleanValue() && storage == Storage.ONLINE) {
            throw new FeatureStoreException("Online storage is not enabled for this feature group. Set `online=false` to write to the offline storage.");
        }
        if (storage == Storage.OFFLINE || !featureGroup.getOnlineEnabled().booleanValue()) {
            SparkEngine.getInstance().writeOfflineDataframe(featureGroup, dataset, operation, offlineWriteOptions, validationId);
        } else if (storage == Storage.ONLINE) {
            SparkEngine.getInstance().writeOnlineDataframe(featureGroup, dataset, onlineWriteOptions);
        } else if (featureGroup.getOnlineEnabled().booleanValue() && storage == null) {
            SparkEngine.getInstance().writeOfflineDataframe(featureGroup, dataset, operation, offlineWriteOptions, validationId);
            SparkEngine.getInstance().writeOnlineDataframe(featureGroup, dataset, onlineWriteOptions);
        } else {
            throw new FeatureStoreException("Error writing to offline and online feature store.");
        }
    }

    private Map<Long, Map<String, String>> getCommitDetails(FeatureGroup featureGroup, String wallclockTime, Integer limit) throws FeatureStoreException, IOException, ParseException {
        Long wallclockTimestamp = wallclockTime != null ? this.utils.getTimeStampFromDateString(wallclockTime) : null;
        List<FeatureGroupCommit> featureGroupCommits = this.featureGroupApi.getCommitDetails(featureGroup, wallclockTimestamp, limit);
        if (featureGroupCommits == null) {
            throw new FeatureStoreException("There are no commit details available for this Feature group");
        }
        HashMap<Long, Map<String, String>> commitDetails = new HashMap<Long, Map<String, String>>();
        for (final FeatureGroupCommit featureGroupCommit : featureGroupCommits) {
            commitDetails.put(featureGroupCommit.getCommitID(), (Map<String, String>)new HashMap<String, String>(){
                {
                    this.put("committedOn", FeatureGroupEngine.this.hudiEngine.timeStampToHudiFormat(featureGroupCommit.getCommitID()));
                    this.put("rowsUpdated", featureGroupCommit.getRowsUpdated() != null ? featureGroupCommit.getRowsUpdated().toString() : "0");
                    this.put("rowsInserted", featureGroupCommit.getRowsInserted() != null ? featureGroupCommit.getRowsInserted().toString() : "0");
                    this.put("rowsDeleted", featureGroupCommit.getRowsDeleted() != null ? featureGroupCommit.getRowsDeleted().toString() : "0");
                }
            });
        }
        return commitDetails;
    }

    public Map<Long, Map<String, String>> commitDetails(FeatureGroup featureGroup, Integer limit) throws IOException, FeatureStoreException, ParseException {
        if (featureGroup.getTimeTravelFormat() == TimeTravelFormat.NONE) {
            throw new FeatureStoreException("commitDetails function is only valid for time travel enabled feature group");
        }
        return this.getCommitDetails(featureGroup, null, limit);
    }

    public Map<Long, Map<String, String>> commitDetailsByWallclockTime(FeatureGroup featureGroup, String wallclockTime, Integer limit) throws IOException, FeatureStoreException, ParseException {
        return this.getCommitDetails(featureGroup, wallclockTime, limit);
    }

    public FeatureGroupCommit commitDelete(FeatureGroup featureGroup, Dataset<Row> dataset, Map<String, String> writeOptions) throws IOException, FeatureStoreException, ParseException {
        if (featureGroup.getTimeTravelFormat() == TimeTravelFormat.NONE) {
            throw new FeatureStoreException("delete function is only valid for time travel enabled feature group");
        }
        return this.hudiEngine.deleteRecord(SparkEngine.getInstance().getSparkSession(), featureGroup, dataset, writeOptions);
    }

    public String getAvroSchema(FeatureGroup featureGroup) throws FeatureStoreException, IOException {
        return this.kafkaApi.getTopicSubject(featureGroup.getFeatureStore(), featureGroup.getOnlineTopicName()).getSchema();
    }

    public Map<String, String> getKafkaConfig(FeatureGroup featureGroup, Map<String, String> writeOptions) throws FeatureStoreException, IOException {
        HashMap<String, String> config = new HashMap<String, String>();
        if (writeOptions != null) {
            config.putAll(writeOptions);
        }
        HopsworksHttpClient client = HopsworksClient.getInstance().getHopsworksHttpClient();
        config.put("kafka.bootstrap.servers", this.kafkaApi.getBrokerEndpoints(featureGroup.getFeatureStore()).stream().map(broker -> broker.replaceAll("INTERNAL://", "")).collect(Collectors.joining(",")));
        config.put("kafka.security.protocol", "SSL");
        config.put("kafka.ssl.truststore.location", client.getTrustStorePath());
        config.put("kafka.ssl.truststore.password", client.getCertKey());
        config.put("kafka.ssl.keystore.location", client.getKeyStorePath());
        config.put("kafka.ssl.keystore.password", client.getCertKey());
        config.put("kafka.ssl.key.password", client.getCertKey());
        config.put("kafka.ssl.endpoint.identification.algorithm", "");
        return config;
    }
}

