/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.metadata;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.logicalclocks.hsfs.metadata.ExpectationResult;
import com.logicalclocks.hsfs.metadata.RestDto;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class FeatureGroupValidation
extends RestDto<FeatureGroupValidation> {
    private Integer validationId;
    private Long validationTime;
    private Long commitTime;
    private List<ExpectationResult> expectationResults;
    private String validationPath;
    private ExpectationResult.Status status;

    @JsonIgnore
    public String getCommitTimeAsDateTimeFormat() {
        Instant instant = Instant.ofEpochSecond(this.commitTime);
        return LocalDateTime.ofInstant(instant, ZoneOffset.UTC).format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
    }

    public static FeatureGroupValidationBuilder builder() {
        return new FeatureGroupValidationBuilder();
    }

    public FeatureGroupValidation() {
    }

    public FeatureGroupValidation(Integer validationId, Long validationTime, Long commitTime, List<ExpectationResult> expectationResults, String validationPath, ExpectationResult.Status status) {
        this.validationId = validationId;
        this.validationTime = validationTime;
        this.commitTime = commitTime;
        this.expectationResults = expectationResults;
        this.validationPath = validationPath;
        this.status = status;
    }

    public String toString() {
        return "FeatureGroupValidation(validationId=" + this.getValidationId() + ", validationTime=" + this.getValidationTime() + ", commitTime=" + this.getCommitTime() + ", expectationResults=" + this.getExpectationResults() + ", validationPath=" + this.getValidationPath() + ", status=" + (Object)((Object)this.getStatus()) + ")";
    }

    public Integer getValidationId() {
        return this.validationId;
    }

    public void setValidationId(Integer validationId) {
        this.validationId = validationId;
    }

    public Long getValidationTime() {
        return this.validationTime;
    }

    public void setValidationTime(Long validationTime) {
        this.validationTime = validationTime;
    }

    public Long getCommitTime() {
        return this.commitTime;
    }

    public void setCommitTime(Long commitTime) {
        this.commitTime = commitTime;
    }

    public List<ExpectationResult> getExpectationResults() {
        return this.expectationResults;
    }

    public void setExpectationResults(List<ExpectationResult> expectationResults) {
        this.expectationResults = expectationResults;
    }

    public String getValidationPath() {
        return this.validationPath;
    }

    public void setValidationPath(String validationPath) {
        this.validationPath = validationPath;
    }

    public ExpectationResult.Status getStatus() {
        return this.status;
    }

    public void setStatus(ExpectationResult.Status status) {
        this.status = status;
    }

    public static class FeatureGroupValidationBuilder {
        private Integer validationId;
        private Long validationTime;
        private Long commitTime;
        private List<ExpectationResult> expectationResults;
        private String validationPath;
        private ExpectationResult.Status status;

        FeatureGroupValidationBuilder() {
        }

        public FeatureGroupValidationBuilder validationId(Integer validationId) {
            this.validationId = validationId;
            return this;
        }

        public FeatureGroupValidationBuilder validationTime(Long validationTime) {
            this.validationTime = validationTime;
            return this;
        }

        public FeatureGroupValidationBuilder commitTime(Long commitTime) {
            this.commitTime = commitTime;
            return this;
        }

        public FeatureGroupValidationBuilder expectationResults(List<ExpectationResult> expectationResults) {
            this.expectationResults = expectationResults;
            return this;
        }

        public FeatureGroupValidationBuilder validationPath(String validationPath) {
            this.validationPath = validationPath;
            return this;
        }

        public FeatureGroupValidationBuilder status(ExpectationResult.Status status) {
            this.status = status;
            return this;
        }

        public FeatureGroupValidation build() {
            return new FeatureGroupValidation(this.validationId, this.validationTime, this.commitTime, this.expectationResults, this.validationPath, this.status);
        }

        public String toString() {
            return "FeatureGroupValidation.FeatureGroupValidationBuilder(validationId=" + this.validationId + ", validationTime=" + this.validationTime + ", commitTime=" + this.commitTime + ", expectationResults=" + this.expectationResults + ", validationPath=" + this.validationPath + ", status=" + (Object)((Object)this.status) + ")";
        }
    }
}

