/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.engine;

import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.OnDemandFeatureGroup;
import com.logicalclocks.hsfs.engine.FeatureGroupBaseEngine;
import com.logicalclocks.hsfs.engine.SparkEngine;
import com.logicalclocks.hsfs.engine.Utils;
import com.logicalclocks.hsfs.metadata.FeatureGroupApi;
import com.logicalclocks.hsfs.metadata.validation.ValidationType;
import java.io.IOException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

public class OnDemandFeatureGroupEngine
extends FeatureGroupBaseEngine {
    private Utils utils = new Utils();
    private FeatureGroupApi featureGroupApi = new FeatureGroupApi();

    public OnDemandFeatureGroup saveFeatureGroup(OnDemandFeatureGroup onDemandFeatureGroup) throws FeatureStoreException, IOException {
        Dataset<Row> onDemandDataset = null;
        if (onDemandFeatureGroup.getFeatures() == null) {
            onDemandDataset = SparkEngine.getInstance().registerOnDemandTemporaryTable(onDemandFeatureGroup, "read_ondmd");
            onDemandFeatureGroup.setFeatures(this.utils.parseFeatureGroupSchema(onDemandDataset));
        }
        if (onDemandFeatureGroup.getPrimaryKeys() != null) {
            onDemandFeatureGroup.getPrimaryKeys().forEach(pk -> onDemandFeatureGroup.getFeatures().forEach(f -> {
                if (f.getName().equals(pk)) {
                    f.setPrimary(true);
                }
            }));
        }
        OnDemandFeatureGroup apiFg = this.featureGroupApi.save(onDemandFeatureGroup);
        onDemandFeatureGroup.setId(apiFg.getId());
        if (onDemandFeatureGroup.getValidationType() != ValidationType.NONE && onDemandDataset != null) {
            onDemandFeatureGroup.validate(onDemandDataset, true);
        }
        return onDemandFeatureGroup;
    }
}

