/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.metadata.validation;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.logicalclocks.hsfs.metadata.RuleDefinition;
import com.logicalclocks.hsfs.metadata.RulesApi;
import com.logicalclocks.hsfs.metadata.validation.AcceptedType;
import com.logicalclocks.hsfs.metadata.validation.Level;
import com.logicalclocks.hsfs.metadata.validation.RuleName;
import java.util.List;
import scala.collection.JavaConverters;
import scala.collection.Seq;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Rule {
    private final RulesApi featureStoreRulesApi = new RulesApi();
    private RuleName name;
    private Level level;
    private Double min;
    private Double max;
    private String value;
    private String pattern;
    private AcceptedType acceptedType;
    private String feature;
    private List<String> legalValues;

    public static RuleBuilder createRule(RuleDefinition rule) {
        return Rule.builder().rule(rule);
    }

    public static RuleBuilder createRule(RuleName name) {
        return Rule.builder().name(name);
    }

    public Rule(RuleName name, RuleDefinition rule, Level level, Double min, Double max, String value, String pattern, AcceptedType acceptedType, String feature, Seq<String> legalValues) {
        this.name = rule != null ? rule.getName() : name;
        this.level = level;
        this.min = min;
        this.max = max;
        this.value = value;
        this.pattern = pattern;
        this.acceptedType = acceptedType;
        this.feature = feature;
        if (legalValues != null) {
            this.legalValues = (List)JavaConverters.seqAsJavaListConverter(legalValues).asJava();
        }
    }

    public static RuleBuilder builder() {
        return new RuleBuilder();
    }

    public Rule() {
    }

    public Rule(RuleName name, Level level, Double min, Double max, String value, String pattern, AcceptedType acceptedType, String feature, List<String> legalValues) {
        this.name = name;
        this.level = level;
        this.min = min;
        this.max = max;
        this.value = value;
        this.pattern = pattern;
        this.acceptedType = acceptedType;
        this.feature = feature;
        this.legalValues = legalValues;
    }

    public String toString() {
        return "Rule(featureStoreRulesApi=" + this.featureStoreRulesApi + ", name=" + (Object)((Object)this.getName()) + ", level=" + (Object)((Object)this.getLevel()) + ", min=" + this.getMin() + ", max=" + this.getMax() + ", value=" + this.getValue() + ", pattern=" + this.getPattern() + ", acceptedType=" + (Object)((Object)this.getAcceptedType()) + ", feature=" + this.getFeature() + ", legalValues=" + this.getLegalValues() + ")";
    }

    public RuleName getName() {
        return this.name;
    }

    public void setName(RuleName name) {
        this.name = name;
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public Double getMin() {
        return this.min;
    }

    public void setMin(Double min) {
        this.min = min;
    }

    public Double getMax() {
        return this.max;
    }

    public void setMax(Double max) {
        this.max = max;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public AcceptedType getAcceptedType() {
        return this.acceptedType;
    }

    public void setAcceptedType(AcceptedType acceptedType) {
        this.acceptedType = acceptedType;
    }

    public String getFeature() {
        return this.feature;
    }

    public void setFeature(String feature) {
        this.feature = feature;
    }

    public List<String> getLegalValues() {
        return this.legalValues;
    }

    public void setLegalValues(List<String> legalValues) {
        this.legalValues = legalValues;
    }

    public static class RuleBuilder {
        private RuleName name;
        private RuleDefinition rule;
        private Level level;
        private Double min;
        private Double max;
        private String value;
        private String pattern;
        private AcceptedType acceptedType;
        private String feature;
        private Seq<String> legalValues;

        RuleBuilder() {
        }

        public RuleBuilder name(RuleName name) {
            this.name = name;
            return this;
        }

        public RuleBuilder rule(RuleDefinition rule) {
            this.rule = rule;
            return this;
        }

        public RuleBuilder level(Level level) {
            this.level = level;
            return this;
        }

        public RuleBuilder min(Double min) {
            this.min = min;
            return this;
        }

        public RuleBuilder max(Double max) {
            this.max = max;
            return this;
        }

        public RuleBuilder value(String value) {
            this.value = value;
            return this;
        }

        public RuleBuilder pattern(String pattern) {
            this.pattern = pattern;
            return this;
        }

        public RuleBuilder acceptedType(AcceptedType acceptedType) {
            this.acceptedType = acceptedType;
            return this;
        }

        public RuleBuilder feature(String feature) {
            this.feature = feature;
            return this;
        }

        public RuleBuilder legalValues(Seq<String> legalValues) {
            this.legalValues = legalValues;
            return this;
        }

        public Rule build() {
            return new Rule(this.name, this.rule, this.level, this.min, this.max, this.value, this.pattern, this.acceptedType, this.feature, this.legalValues);
        }

        public String toString() {
            return "Rule.RuleBuilder(name=" + (Object)((Object)this.name) + ", rule=" + this.rule + ", level=" + (Object)((Object)this.level) + ", min=" + this.min + ", max=" + this.max + ", value=" + this.value + ", pattern=" + this.pattern + ", acceptedType=" + (Object)((Object)this.acceptedType) + ", feature=" + this.feature + ", legalValues=" + this.legalValues + ")";
        }
    }
}

