/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.engine;

import com.logicalclocks.hsfs.EntityEndpointType;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.Split;
import com.logicalclocks.hsfs.TrainingDataset;
import com.logicalclocks.hsfs.engine.SparkEngine;
import com.logicalclocks.hsfs.metadata.FeatureGroupBase;
import com.logicalclocks.hsfs.metadata.SplitStatistics;
import com.logicalclocks.hsfs.metadata.Statistics;
import com.logicalclocks.hsfs.metadata.StatisticsApi;
import java.io.IOException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticsEngine {
    private StatisticsApi statisticsApi;
    private static final Logger LOGGER = LoggerFactory.getLogger(StatisticsEngine.class);

    public StatisticsEngine(EntityEndpointType entityType) {
        this.statisticsApi = new StatisticsApi(entityType);
    }

    public Statistics computeStatistics(TrainingDataset trainingDataset, Dataset<Row> dataFrame) throws FeatureStoreException, IOException {
        return this.statisticsApi.post(trainingDataset, this.computeStatistics(dataFrame, trainingDataset.getStatisticsConfig().getColumns(), trainingDataset.getStatisticsConfig().getHistograms(), trainingDataset.getStatisticsConfig().getCorrelations(), trainingDataset.getStatisticsConfig().getExactUniqueness(), null));
    }

    public Statistics computeStatistics(FeatureGroupBase featureGroup, Dataset<Row> dataFrame, Long commitId) throws FeatureStoreException, IOException {
        return this.statisticsApi.post(featureGroup, this.computeStatistics(dataFrame, featureGroup.getStatisticsConfig().getColumns(), featureGroup.getStatisticsConfig().getHistograms(), featureGroup.getStatisticsConfig().getCorrelations(), featureGroup.getStatisticsConfig().getExactUniqueness(), commitId));
    }

    private Statistics computeStatistics(Dataset<Row> dataFrame, List<String> statisticColumns, Boolean histograms, Boolean correlations, Boolean exactUniqueness, Long commitId) throws FeatureStoreException {
        if (dataFrame.isEmpty()) {
            throw new FeatureStoreException("There is no data in the entity that you are trying to compute statistics for. A possible cause might be that you inserted only data to the online storage of a feature group.");
        }
        Long commitTime = Timestamp.valueOf(LocalDateTime.now()).getTime();
        String content = SparkEngine.getInstance().profile(dataFrame, statisticColumns, histograms, correlations, exactUniqueness);
        return new Statistics(commitTime, commitId, content, null);
    }

    public Statistics registerSplitStatistics(TrainingDataset trainingDataset) throws FeatureStoreException, IOException {
        ArrayList<SplitStatistics> splitStatistics = new ArrayList<SplitStatistics>();
        for (Split split : trainingDataset.getSplits()) {
            splitStatistics.add(new SplitStatistics(split.getName(), this.computeStatistics(trainingDataset.read(split.getName()), trainingDataset.getStatisticsConfig().getColumns(), trainingDataset.getStatisticsConfig().getHistograms(), trainingDataset.getStatisticsConfig().getCorrelations(), trainingDataset.getStatisticsConfig().getExactUniqueness(), null).getContent()));
        }
        Long commitTime = Timestamp.valueOf(LocalDateTime.now()).getTime();
        Statistics statistics = new Statistics(commitTime, null, null, splitStatistics);
        return this.statisticsApi.post(trainingDataset, statistics);
    }

    public Statistics get(FeatureGroupBase featureGroup, String commitTime) throws FeatureStoreException, IOException {
        return this.statisticsApi.get(featureGroup, commitTime);
    }

    public Statistics get(TrainingDataset trainingDataset, String commitTime) throws FeatureStoreException, IOException {
        return this.statisticsApi.get(trainingDataset, commitTime);
    }

    public Statistics getLast(FeatureGroupBase featureGroup) throws FeatureStoreException, IOException {
        return this.statisticsApi.getLast(featureGroup);
    }

    public Statistics getLast(TrainingDataset trainingDataset) throws FeatureStoreException, IOException {
        return this.statisticsApi.getLast(trainingDataset);
    }
}

