/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.logicalclocks.hsfs.EntityEndpointType;
import com.logicalclocks.hsfs.ExternalDataFormat;
import com.logicalclocks.hsfs.Feature;
import com.logicalclocks.hsfs.FeatureStore;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.StatisticsConfig;
import com.logicalclocks.hsfs.StorageConnector;
import com.logicalclocks.hsfs.engine.CodeEngine;
import com.logicalclocks.hsfs.engine.ExternalFeatureGroupEngine;
import com.logicalclocks.hsfs.metadata.FeatureGroupBase;
import com.logicalclocks.hsfs.metadata.OnDemandOptions;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ExternalFeatureGroup
extends FeatureGroupBase {
    private StorageConnector storageConnector;
    private String query;
    private ExternalDataFormat dataFormat;
    private String path;
    private List<OnDemandOptions> options;
    private String type = "onDemandFeaturegroupDTO";
    private ExternalFeatureGroupEngine externalFeatureGroupEngine = new ExternalFeatureGroupEngine();
    private final CodeEngine codeEngine = new CodeEngine(EntityEndpointType.FEATURE_GROUP);

    public ExternalFeatureGroup(FeatureStore featureStore, @NonNull String name, Integer version, String query, ExternalDataFormat dataFormat, String path, Map<String, String> options, @NonNull StorageConnector storageConnector, String description, List<String> primaryKeys, List<Feature> features, StatisticsConfig statisticsConfig, String eventTime) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (storageConnector == null) {
            throw new NullPointerException("storageConnector is marked non-null but is null");
        }
        this.featureStore = featureStore;
        this.name = name;
        this.version = version;
        this.query = query;
        this.dataFormat = dataFormat;
        this.path = path;
        this.options = options != null ? options.entrySet().stream().map(e -> new OnDemandOptions((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList()) : null;
        this.description = description;
        this.primaryKeys = primaryKeys != null ? primaryKeys.stream().map(String::toLowerCase).collect(Collectors.toList()) : null;
        this.storageConnector = storageConnector;
        this.features = features;
        this.statisticsConfig = statisticsConfig != null ? statisticsConfig : new StatisticsConfig();
        this.eventTime = eventTime;
    }

    public ExternalFeatureGroup() {
    }

    public ExternalFeatureGroup(FeatureStore featureStore, int id) {
        this.featureStore = featureStore;
        this.id = id;
    }

    public void save() throws FeatureStoreException, IOException {
        this.externalFeatureGroupEngine.saveFeatureGroup(this);
        this.codeEngine.saveCode(this);
        if (this.statisticsConfig.getEnabled().booleanValue()) {
            this.statisticsEngine.computeStatistics(this, this.read(), null);
        }
    }

    public Dataset<Row> read() throws FeatureStoreException, IOException {
        return (Dataset)this.selectAll().read();
    }

    public void show(int numRows) throws FeatureStoreException, IOException {
        this.read().show(numRows);
    }

    public static ExternalFeatureGroupBuilder builder() {
        return new ExternalFeatureGroupBuilder();
    }

    public ExternalFeatureGroup(StorageConnector storageConnector, String query, ExternalDataFormat dataFormat, String path, List<OnDemandOptions> options, String type, ExternalFeatureGroupEngine externalFeatureGroupEngine) {
        this.storageConnector = storageConnector;
        this.query = query;
        this.dataFormat = dataFormat;
        this.path = path;
        this.options = options;
        this.type = type;
        this.externalFeatureGroupEngine = externalFeatureGroupEngine;
    }

    public StorageConnector getStorageConnector() {
        return this.storageConnector;
    }

    public void setStorageConnector(StorageConnector storageConnector) {
        this.storageConnector = storageConnector;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public ExternalDataFormat getDataFormat() {
        return this.dataFormat;
    }

    public void setDataFormat(ExternalDataFormat dataFormat) {
        this.dataFormat = dataFormat;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public List<OnDemandOptions> getOptions() {
        return this.options;
    }

    public void setOptions(List<OnDemandOptions> options) {
        this.options = options;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public static class ExternalFeatureGroupBuilder {
        private FeatureStore featureStore;
        private String name;
        private Integer version;
        private String query;
        private ExternalDataFormat dataFormat;
        private String path;
        private Map<String, String> options;
        private StorageConnector storageConnector;
        private String description;
        private List<String> primaryKeys;
        private List<Feature> features;
        private StatisticsConfig statisticsConfig;
        private String eventTime;

        ExternalFeatureGroupBuilder() {
        }

        public ExternalFeatureGroupBuilder featureStore(FeatureStore featureStore) {
            this.featureStore = featureStore;
            return this;
        }

        public ExternalFeatureGroupBuilder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        public ExternalFeatureGroupBuilder version(Integer version) {
            this.version = version;
            return this;
        }

        public ExternalFeatureGroupBuilder query(String query) {
            this.query = query;
            return this;
        }

        public ExternalFeatureGroupBuilder dataFormat(ExternalDataFormat dataFormat) {
            this.dataFormat = dataFormat;
            return this;
        }

        public ExternalFeatureGroupBuilder path(String path) {
            this.path = path;
            return this;
        }

        public ExternalFeatureGroupBuilder options(Map<String, String> options) {
            this.options = options;
            return this;
        }

        public ExternalFeatureGroupBuilder storageConnector(@NonNull StorageConnector storageConnector) {
            if (storageConnector == null) {
                throw new NullPointerException("storageConnector is marked non-null but is null");
            }
            this.storageConnector = storageConnector;
            return this;
        }

        public ExternalFeatureGroupBuilder description(String description) {
            this.description = description;
            return this;
        }

        public ExternalFeatureGroupBuilder primaryKeys(List<String> primaryKeys) {
            this.primaryKeys = primaryKeys;
            return this;
        }

        public ExternalFeatureGroupBuilder features(List<Feature> features) {
            this.features = features;
            return this;
        }

        public ExternalFeatureGroupBuilder statisticsConfig(StatisticsConfig statisticsConfig) {
            this.statisticsConfig = statisticsConfig;
            return this;
        }

        public ExternalFeatureGroupBuilder eventTime(String eventTime) {
            this.eventTime = eventTime;
            return this;
        }

        public ExternalFeatureGroup build() {
            return new ExternalFeatureGroup(this.featureStore, this.name, this.version, this.query, this.dataFormat, this.path, this.options, this.storageConnector, this.description, this.primaryKeys, this.features, this.statisticsConfig, this.eventTime);
        }

        public String toString() {
            return "ExternalFeatureGroup.ExternalFeatureGroupBuilder(featureStore=" + this.featureStore + ", name=" + this.name + ", version=" + this.version + ", query=" + this.query + ", dataFormat=" + (Object)((Object)this.dataFormat) + ", path=" + this.path + ", options=" + this.options + ", storageConnector=" + this.storageConnector + ", description=" + this.description + ", primaryKeys=" + this.primaryKeys + ", features=" + this.features + ", statisticsConfig=" + this.statisticsConfig + ", eventTime=" + this.eventTime + ")";
        }
    }
}

