/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.constructor;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.common.base.Strings;
import com.logicalclocks.hsfs.ExternalFeatureGroup;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.Storage;
import com.logicalclocks.hsfs.constructor.ExternalFeatureGroupAlias;
import com.logicalclocks.hsfs.constructor.HudiFeatureGroupAlias;
import com.logicalclocks.hsfs.engine.SparkEngine;
import java.io.IOException;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class FsQuery {
    private String query;
    private String queryOnline;
    private String pitQuery;
    private List<ExternalFeatureGroupAlias> onDemandFeatureGroups;
    private List<HudiFeatureGroupAlias> hudiCachedFeatureGroups;

    public void removeNewLines() {
        this.query = this.query != null ? this.query.replace("\n", " ") : null;
        this.queryOnline = this.queryOnline != null ? this.queryOnline.replace("\n", " ") : null;
    }

    public String getStorageQuery(Storage storage) throws FeatureStoreException {
        switch (storage) {
            case OFFLINE: {
                if (!Strings.isNullOrEmpty((String)this.pitQuery)) {
                    return this.pitQuery;
                }
                return this.query;
            }
            case ONLINE: {
                return this.queryOnline;
            }
        }
        throw new FeatureStoreException("Cannot run query on ALL storages");
    }

    public void registerOnDemandFeatureGroups() throws FeatureStoreException, IOException {
        if (this.onDemandFeatureGroups == null || this.onDemandFeatureGroups.isEmpty()) {
            return;
        }
        for (ExternalFeatureGroupAlias externalFeatureGroupAlias : this.onDemandFeatureGroups) {
            String alias = externalFeatureGroupAlias.getAlias();
            ExternalFeatureGroup onDemandFeatureGroup = externalFeatureGroupAlias.getOnDemandFeatureGroup();
            SparkEngine.getInstance().registerOnDemandTemporaryTable(onDemandFeatureGroup, alias);
        }
    }

    public void registerHudiFeatureGroups(Map<String, String> readOptions) {
        for (HudiFeatureGroupAlias hudiFeatureGroupAlias : this.hudiCachedFeatureGroups) {
            SparkEngine.getInstance().registerHudiTemporaryTable(hudiFeatureGroupAlias, readOptions);
        }
    }

    public FsQuery(String query, String queryOnline, String pitQuery, List<ExternalFeatureGroupAlias> onDemandFeatureGroups, List<HudiFeatureGroupAlias> hudiCachedFeatureGroups) {
        this.query = query;
        this.queryOnline = queryOnline;
        this.pitQuery = pitQuery;
        this.onDemandFeatureGroups = onDemandFeatureGroups;
        this.hudiCachedFeatureGroups = hudiCachedFeatureGroups;
    }

    public FsQuery() {
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getQueryOnline() {
        return this.queryOnline;
    }

    public void setQueryOnline(String queryOnline) {
        this.queryOnline = queryOnline;
    }

    public String getPitQuery() {
        return this.pitQuery;
    }

    public void setPitQuery(String pitQuery) {
        this.pitQuery = pitQuery;
    }

    public List<ExternalFeatureGroupAlias> getOnDemandFeatureGroups() {
        return this.onDemandFeatureGroups;
    }

    public void setOnDemandFeatureGroups(List<ExternalFeatureGroupAlias> onDemandFeatureGroups) {
        this.onDemandFeatureGroups = onDemandFeatureGroups;
    }

    public List<HudiFeatureGroupAlias> getHudiCachedFeatureGroups() {
        return this.hudiCachedFeatureGroups;
    }

    public void setHudiCachedFeatureGroups(List<HudiFeatureGroupAlias> hudiCachedFeatureGroups) {
        this.hudiCachedFeatureGroups = hudiCachedFeatureGroups;
    }
}

