/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.engine;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.logicalclocks.hsfs.EntityEndpointType;
import com.logicalclocks.hsfs.FeatureStore;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.FeatureView;
import com.logicalclocks.hsfs.Split;
import com.logicalclocks.hsfs.TrainingDataset;
import com.logicalclocks.hsfs.TrainingDatasetBundle;
import com.logicalclocks.hsfs.TrainingDatasetFeature;
import com.logicalclocks.hsfs.TrainingDatasetType;
import com.logicalclocks.hsfs.constructor.Query;
import com.logicalclocks.hsfs.engine.SparkEngine;
import com.logicalclocks.hsfs.engine.StatisticsEngine;
import com.logicalclocks.hsfs.engine.TrainingDatasetEngine;
import com.logicalclocks.hsfs.metadata.FeatureViewApi;
import com.logicalclocks.hsfs.metadata.Statistics;
import com.logicalclocks.hsfs.metadata.TagsApi;
import java.io.IOException;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.mapreduce.lib.input.InvalidInputException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureViewEngine {
    private FeatureViewApi featureViewApi = new FeatureViewApi();
    private TagsApi tagsApi = new TagsApi(EntityEndpointType.FEATURE_VIEW);
    private TrainingDatasetEngine trainingDatasetEngine = new TrainingDatasetEngine();
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureViewEngine.class);
    private StatisticsEngine statisticsEngine = new StatisticsEngine(EntityEndpointType.TRAINING_DATASET);

    public FeatureView save(FeatureView featureView) throws FeatureStoreException, IOException {
        featureView.setFeatures(this.makeLabelFeatures(featureView.getLabels()));
        FeatureView updatedFeatureView = this.featureViewApi.save(featureView);
        featureView.setVersion(updatedFeatureView.getVersion());
        featureView.setFeatures(updatedFeatureView.getFeatures());
        return featureView;
    }

    private List<TrainingDatasetFeature> makeLabelFeatures(List<String> labels) {
        if (labels == null || labels.isEmpty()) {
            return Lists.newArrayList();
        }
        return labels.stream().map(label -> new TrainingDatasetFeature(label.toLowerCase(), true)).collect(Collectors.toList());
    }

    public FeatureView update(FeatureView featureView) throws FeatureStoreException, IOException {
        FeatureView featureViewUpdated = this.featureViewApi.update(featureView);
        featureView.setDescription(featureViewUpdated.getDescription());
        return featureView;
    }

    public FeatureView get(FeatureStore featureStore, String name, Integer version) throws FeatureStoreException, IOException {
        FeatureView featureView = this.featureViewApi.get(featureStore, name, version);
        featureView.setFeatureStore(featureStore);
        featureView.getFeatures().stream().filter(f -> f.getFeaturegroup() != null).forEach(f -> f.getFeaturegroup().setFeatureStore(featureStore));
        featureView.getQuery().getLeftFeatureGroup().setFeatureStore(featureStore);
        featureView.setLabels(featureView.getFeatures().stream().filter(TrainingDatasetFeature::getLabel).map(TrainingDatasetFeature::getName).collect(Collectors.toList()));
        return featureView;
    }

    public List<FeatureView> get(FeatureStore featureStore, String name) throws FeatureStoreException, IOException {
        List<FeatureView> featureViews = this.featureViewApi.get(featureStore, name);
        for (FeatureView fv : featureViews) {
            fv.setFeatureStore(featureStore);
            fv.getFeatures().stream().filter(f -> f.getFeaturegroup() != null).forEach(f -> f.getFeaturegroup().setFeatureStore(featureStore));
            fv.getQuery().getLeftFeatureGroup().setFeatureStore(featureStore);
            fv.setLabels(fv.getFeatures().stream().filter(TrainingDatasetFeature::getLabel).map(TrainingDatasetFeature::getName).collect(Collectors.toList()));
        }
        return featureViews;
    }

    public void delete(FeatureStore featureStore, String name) throws FeatureStoreException, IOException {
        this.featureViewApi.delete(featureStore, name);
    }

    public void delete(FeatureStore featureStore, String name, Integer version) throws FeatureStoreException, IOException {
        this.featureViewApi.delete(featureStore, name, version);
    }

    public TrainingDatasetBundle createTrainingDataset(FeatureView featureView, TrainingDataset trainingDataset, Map<String, String> userWriteOptions) throws IOException, FeatureStoreException {
        this.setTrainSplit(trainingDataset);
        trainingDataset = this.createTrainingDataMetadata(featureView, trainingDataset);
        this.writeTrainingDataset(featureView, trainingDataset, userWriteOptions);
        return new TrainingDatasetBundle(trainingDataset.getVersion());
    }

    public void writeTrainingDataset(FeatureView featureView, TrainingDataset trainingDataset, Map<String, String> userWriteOptions) throws IOException, FeatureStoreException {
        Dataset<Row> dataset = this.readDataset(featureView, trainingDataset, Maps.newHashMap());
        Map<String, String> writeOptions = SparkEngine.getInstance().getWriteOptions(userWriteOptions, trainingDataset.getDataFormat());
        Dataset<Row>[] datasets = SparkEngine.getInstance().write(trainingDataset, dataset, writeOptions, SaveMode.Overwrite);
        this.computeStatistics(featureView, trainingDataset, datasets);
    }

    public TrainingDatasetBundle getTrainingDataset(FeatureView featureView, Integer trainingDatasetVersion, List<String> requestedSplits, Map<String, String> userReadOptions) throws IOException, FeatureStoreException, ParseException {
        TrainingDataset trainingDataset = featureView.getFeatureStore().createTrainingDataset().name(featureView.getName()).version(trainingDatasetVersion).build();
        return this.getTrainingDataset(featureView, trainingDataset, requestedSplits, userReadOptions);
    }

    public TrainingDatasetBundle getTrainingDataset(FeatureView featureView, TrainingDataset trainingDataset, Map<String, String> userReadOptions) throws IOException, FeatureStoreException {
        return this.getTrainingDataset(featureView, trainingDataset, null, userReadOptions);
    }

    public TrainingDatasetBundle getTrainingDataset(FeatureView featureView, TrainingDataset trainingDataset, List<String> requestedSplits, Map<String, String> userReadOptions) throws IOException, FeatureStoreException {
        TrainingDatasetBundle trainingDatasetBundle;
        TrainingDataset trainingDatasetUpdated = null;
        trainingDatasetUpdated = trainingDataset.getVersion() != null ? this.getTrainingDataMetadata(featureView, trainingDataset.getVersion()) : this.createTrainingDataMetadata(featureView, trainingDataset);
        if (requestedSplits != null) {
            int splitSize = trainingDatasetUpdated.getSplits().size();
            String methodName = "";
            if (splitSize != requestedSplits.size()) {
                if (splitSize == 0) {
                    methodName = "getTrainingData";
                } else if (splitSize == 2) {
                    methodName = "getTrainTestSplit";
                } else if (splitSize == 3) {
                    methodName = "getTrainValidationTestSplit";
                }
                throw new FeatureStoreException(String.format("Incorrect `get` method is used. Use `FeatureView.%s` instead.", methodName));
            }
        }
        if (!TrainingDatasetType.IN_MEMORY_TRAINING_DATASET.equals((Object)trainingDatasetUpdated.getTrainingDatasetType())) {
            try {
                List<Split> splits = trainingDatasetUpdated.getSplits();
                if (splits != null && !splits.isEmpty()) {
                    HashMap datasets = Maps.newHashMap();
                    for (Split split : splits) {
                        datasets.put(split.getName(), this.trainingDatasetEngine.read(trainingDatasetUpdated, split.getName(), userReadOptions));
                    }
                    return new TrainingDatasetBundle(trainingDatasetUpdated.getVersion(), datasets, featureView.getLabels());
                }
                return new TrainingDatasetBundle(trainingDatasetUpdated.getVersion(), this.trainingDatasetEngine.read(trainingDatasetUpdated, "", userReadOptions), featureView.getLabels());
            }
            catch (InvalidInputException e) {
                throw new IllegalStateException("Failed to read datasets. Check if path exists or recreate a training dataset.");
            }
        }
        Dataset<Row> dataset = this.readDataset(featureView, trainingDatasetUpdated, userReadOptions);
        if (trainingDatasetUpdated.getSplits() != null && !trainingDatasetUpdated.getSplits().isEmpty()) {
            Dataset<Row>[] datasets = SparkEngine.getInstance().splitDataset(trainingDatasetUpdated, dataset);
            trainingDatasetBundle = new TrainingDatasetBundle(trainingDatasetUpdated.getVersion(), this.convertSplitDatasetsToMap(trainingDatasetUpdated.getSplits(), datasets), featureView.getLabels());
            this.computeStatistics(featureView, trainingDatasetUpdated, datasets);
        } else {
            trainingDatasetBundle = new TrainingDatasetBundle(trainingDatasetUpdated.getVersion(), dataset, featureView.getLabels());
            this.computeStatistics(featureView, trainingDatasetUpdated, new Dataset[]{dataset});
        }
        return trainingDatasetBundle;
    }

    private void setTrainSplit(TrainingDataset trainingDataset) {
        if (trainingDataset.getSplits() != null && trainingDataset.getSplits().size() > 0 && Strings.isNullOrEmpty((String)trainingDataset.getTrainSplit())) {
            LOGGER.info("Training dataset splits were defined but no `trainSplit` (the name of the split that is going to be used for training) was provided. Setting this property to `train`.");
            trainingDataset.setTrainSplit("train");
        }
    }

    private TrainingDataset createTrainingDataMetadata(FeatureView featureView, TrainingDataset trainingDataset) throws IOException, FeatureStoreException {
        return this.featureViewApi.createTrainingData(featureView.getName(), featureView.getVersion(), trainingDataset);
    }

    private TrainingDataset getTrainingDataMetadata(FeatureView featureView, Integer trainingDatasetVersion) throws IOException, FeatureStoreException {
        return this.featureViewApi.getTrainingData(featureView.getFeatureStore(), featureView.getName(), featureView.getVersion(), trainingDatasetVersion);
    }

    public Statistics computeStatistics(FeatureView featureView, TrainingDataset trainingDataset, Dataset<Row>[] datasets) throws FeatureStoreException, IOException {
        if (trainingDataset.getStatisticsConfig().getEnabled().booleanValue()) {
            if (trainingDataset.getSplits() != null && !trainingDataset.getSplits().isEmpty()) {
                return this.statisticsEngine.registerSplitStatistics(featureView, trainingDataset, this.convertSplitDatasetsToMap(trainingDataset.getSplits(), datasets));
            }
            return this.statisticsEngine.computeStatistics(featureView, trainingDataset, datasets[0]);
        }
        return null;
    }

    private Map<String, Dataset<Row>> convertSplitDatasetsToMap(List<Split> splits, Dataset<Row>[] datasets) {
        HashMap datasetSplits = Maps.newHashMap();
        for (int i = 0; i < datasets.length; ++i) {
            datasetSplits.put(splits.get(i).getName(), datasets[i]);
        }
        return datasetSplits;
    }

    public void recreateTrainingDataset(FeatureView featureView, Integer version, Map<String, String> userWriteOptions) throws IOException, FeatureStoreException {
        TrainingDataset trainingDataset = this.getTrainingDataMetadata(featureView, version);
        this.writeTrainingDataset(featureView, trainingDataset, userWriteOptions);
    }

    private Dataset<Row> readDataset(FeatureView featureView, TrainingDataset trainingDataset, Map<String, String> userReadOptions) throws IOException, FeatureStoreException {
        Query query = this.getBatchQuery(featureView, trainingDataset.getEventStartTime(), trainingDataset.getEventEndTime(), true);
        return (Dataset)query.read(false, userReadOptions);
    }

    public void deleteTrainingData(FeatureView featureView, Integer trainingDataVersion) throws FeatureStoreException, IOException {
        this.featureViewApi.deleteTrainingData(featureView.getFeatureStore(), featureView.getName(), featureView.getVersion(), trainingDataVersion);
    }

    public void deleteTrainingData(FeatureView featureView) throws FeatureStoreException, IOException {
        this.featureViewApi.deleteTrainingData(featureView.getFeatureStore(), featureView.getName(), featureView.getVersion());
    }

    public void deleteTrainingDatasetOnly(FeatureView featureView, Integer trainingDataVersion) throws FeatureStoreException, IOException {
        this.featureViewApi.deleteTrainingDatasetOnly(featureView.getFeatureStore(), featureView.getName(), featureView.getVersion(), trainingDataVersion);
    }

    public void deleteTrainingDatasetOnly(FeatureView featureView) throws FeatureStoreException, IOException {
        this.featureViewApi.deleteTrainingDatasetOnly(featureView.getFeatureStore(), featureView.getName(), featureView.getVersion());
    }

    public String getBatchQueryString(FeatureView featureView, Date startTime, Date endTime) throws FeatureStoreException, IOException {
        Query query = this.getBatchQuery(featureView, startTime, endTime, false);
        return query.sql();
    }

    public Query getBatchQuery(FeatureView featureView, Date startTime, Date endTime, Boolean withLabels) throws FeatureStoreException, IOException {
        Query query = this.featureViewApi.getBatchQuery(featureView.getFeatureStore(), featureView.getName(), featureView.getVersion(), startTime == null ? null : Long.valueOf(startTime.getTime()), endTime == null ? null : Long.valueOf(endTime.getTime()), withLabels);
        query.getLeftFeatureGroup().setFeatureStore(featureView.getQuery().getLeftFeatureGroup().getFeatureStore());
        return query;
    }

    public Dataset<Row> getBatchData(FeatureView featureView, Date startTime, Date endTime, Map<String, String> readOptions) throws FeatureStoreException, IOException {
        return (Dataset)this.getBatchQuery(featureView, startTime, endTime, false).read(false, readOptions);
    }

    public void addTag(FeatureView featureView, String name, Object value) throws FeatureStoreException, IOException {
        this.tagsApi.add(featureView, name, value);
    }

    public void addTag(FeatureView featureView, String name, Object value, Integer trainingDataVersion) throws FeatureStoreException, IOException {
        this.tagsApi.add(featureView, trainingDataVersion, name, value);
    }

    public void deleteTag(FeatureView featureView, String name) throws FeatureStoreException, IOException {
        this.tagsApi.deleteTag(featureView, name);
    }

    public void deleteTag(FeatureView featureView, String name, Integer trainingDataVersion) throws FeatureStoreException, IOException {
        this.tagsApi.deleteTag(featureView, trainingDataVersion, name);
    }

    public Object getTag(FeatureView featureView, String name) throws FeatureStoreException, IOException {
        return this.tagsApi.get(featureView, name);
    }

    public Object getTag(FeatureView featureView, String name, Integer trainingDataVersion) throws FeatureStoreException, IOException {
        return this.tagsApi.get(featureView, trainingDataVersion, name);
    }

    public Map<String, Object> getTags(FeatureView featureView) throws FeatureStoreException, IOException {
        return this.tagsApi.get(featureView);
    }

    public Map<String, Object> getTags(FeatureView featureView, Integer trainingDataVersion) throws FeatureStoreException, IOException {
        return this.tagsApi.get(featureView, trainingDataVersion);
    }
}

