/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.engine;

import com.google.common.base.Strings;
import com.logicalclocks.hsfs.EntityEndpointType;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.Storage;
import com.logicalclocks.hsfs.TrainingDataset;
import com.logicalclocks.hsfs.constructor.FsQuery;
import com.logicalclocks.hsfs.engine.SparkEngine;
import com.logicalclocks.hsfs.engine.TrainingDatasetUtils;
import com.logicalclocks.hsfs.metadata.TagsApi;
import com.logicalclocks.hsfs.metadata.TrainingDatasetApi;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrainingDatasetEngine {
    private TrainingDatasetApi trainingDatasetApi = new TrainingDatasetApi();
    private TagsApi tagsApi = new TagsApi(EntityEndpointType.TRAINING_DATASET);
    private TrainingDatasetUtils utils = new TrainingDatasetUtils();
    private static final Logger LOGGER = LoggerFactory.getLogger(TrainingDatasetEngine.class);

    public TrainingDataset save(TrainingDataset trainingDataset, Dataset<Row> dataset, Map<String, String> userWriteOptions, List<String> labels) throws FeatureStoreException, IOException {
        trainingDataset.setFeatures(this.utils.parseTrainingDatasetSchema(dataset));
        TrainingDatasetUtils.setLabelFeature(trainingDataset.getFeatures(), labels);
        TrainingDataset apiTD = this.trainingDatasetApi.createTrainingDataset(trainingDataset);
        if (trainingDataset.getVersion() == null) {
            LOGGER.info("VersionWarning: No version provided for creating training dataset `" + trainingDataset.getName() + "`, incremented version to `" + apiTD.getVersion() + "`.");
        }
        trainingDataset.setLocation(apiTD.getLocation());
        trainingDataset.setVersion(apiTD.getVersion());
        trainingDataset.setId(apiTD.getId());
        trainingDataset.setStorageConnector(apiTD.getStorageConnector());
        Map<String, String> writeOptions = SparkEngine.getInstance().getWriteOptions(userWriteOptions, trainingDataset.getDataFormat());
        SparkEngine.getInstance().write(trainingDataset, dataset, writeOptions, SaveMode.Overwrite);
        return trainingDataset;
    }

    public void insert(TrainingDataset trainingDataset, Dataset<Row> dataset, Map<String, String> providedOptions, SaveMode saveMode) throws FeatureStoreException, IOException {
        this.utils.trainingDatasetSchemaMatch(dataset, trainingDataset.getFeatures());
        if (this.trainingDatasetApi.getTransformationFunctions(trainingDataset).size() > 0) {
            throw new FeatureStoreException("This training dataset has transformation functions attached and insert operation must be performed from a PySpark application");
        }
        Map<String, String> writeOptions = SparkEngine.getInstance().getWriteOptions(providedOptions, trainingDataset.getDataFormat());
        SparkEngine.getInstance().write(trainingDataset, dataset, writeOptions, saveMode);
    }

    public Dataset<Row> read(TrainingDataset trainingDataset, String split, Map<String, String> providedOptions) throws FeatureStoreException, IOException {
        Map<String, String> readOptions = SparkEngine.getInstance().getReadOptions(providedOptions, trainingDataset.getDataFormat());
        String path = null;
        path = !Strings.isNullOrEmpty((String)split) ? new Path(trainingDataset.getLocation(), split).toString() : new Path(trainingDataset.getLocation(), trainingDataset.getName()).toString();
        return (Dataset)trainingDataset.getStorageConnector().read(null, trainingDataset.getDataFormat().toString(), readOptions, path);
    }

    public void addTag(TrainingDataset trainingDataset, String name, Object value) throws FeatureStoreException, IOException {
        this.tagsApi.add(trainingDataset, name, value);
    }

    public Map<String, Object> getTags(TrainingDataset trainingDataset) throws FeatureStoreException, IOException {
        return this.tagsApi.get(trainingDataset);
    }

    public Object getTag(TrainingDataset trainingDataset, String name) throws FeatureStoreException, IOException {
        return this.tagsApi.get(trainingDataset, name);
    }

    public void deleteTag(TrainingDataset trainingDataset, String name) throws FeatureStoreException, IOException {
        this.tagsApi.deleteTag(trainingDataset, name);
    }

    public String getQuery(TrainingDataset trainingDataset, Storage storage, boolean withLabel, boolean isHiveQuery) throws FeatureStoreException, IOException {
        FsQuery fsQuery = this.trainingDatasetApi.getQuery(trainingDataset, withLabel, isHiveQuery);
        if (storage == Storage.OFFLINE) {
            fsQuery.registerOnDemandFeatureGroups();
            fsQuery.registerHudiFeatureGroups(new HashMap<String, String>());
        }
        return fsQuery.getStorageQuery(storage);
    }

    public void updateStatisticsConfig(TrainingDataset trainingDataset) throws FeatureStoreException, IOException {
        TrainingDataset apiTD = this.trainingDatasetApi.updateMetadata(trainingDataset, "updateStatsConfig");
        trainingDataset.getStatisticsConfig().setCorrelations(apiTD.getStatisticsConfig().getCorrelations());
        trainingDataset.getStatisticsConfig().setHistograms(apiTD.getStatisticsConfig().getHistograms());
        trainingDataset.getStatisticsConfig().setExactUniqueness(apiTD.getStatisticsConfig().getExactUniqueness());
    }

    public void delete(TrainingDataset trainingDataset) throws FeatureStoreException, IOException {
        this.trainingDatasetApi.delete(trainingDataset);
    }
}

