/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.metadata;

import com.damnhandy.uri.template.UriTemplate;
import com.logicalclocks.hsfs.ExternalFeatureGroup;
import com.logicalclocks.hsfs.FeatureGroup;
import com.logicalclocks.hsfs.FeatureGroupCommit;
import com.logicalclocks.hsfs.FeatureStore;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.StatisticsConfig;
import com.logicalclocks.hsfs.StreamFeatureGroup;
import com.logicalclocks.hsfs.TimeTravelFormat;
import com.logicalclocks.hsfs.metadata.FeatureGroupBase;
import com.logicalclocks.hsfs.metadata.HopsworksClient;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureGroupApi {
    public static final String FEATURE_GROUP_ROOT_PATH = "/featuregroups";
    public static final String FEATURE_GROUP_PATH = "/featuregroups{/fgName}{?version}";
    public static final String FEATURE_GROUP_ID_PATH = "/featuregroups{/fgId}{?updateStatsConfig,updateMetadata,validationType}";
    public static final String FEATURE_GROUP_COMMIT_PATH = "/featuregroups{/fgId}{?updateStatsConfig,updateMetadata,validationType}/commits{?filter_by,sort_by,offset,limit}";
    public static final String FEATURE_GROUP_CLEAR_PATH = "/featuregroups{/fgId}{?updateStatsConfig,updateMetadata,validationType}/clear";
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureGroupApi.class);

    public List<FeatureGroup> getFeatureGroups(FeatureStore featureStore, String fgName) throws FeatureStoreException, IOException {
        FeatureGroup[] offlineFeatureGroups = this.getInternal(featureStore, fgName, null, FeatureGroup[].class);
        return Arrays.asList(offlineFeatureGroups);
    }

    public FeatureGroup getFeatureGroup(FeatureStore featureStore, String fgName, Integer fgVersion) throws IOException, FeatureStoreException {
        FeatureGroup[] offlineFeatureGroups = this.getInternal(featureStore, fgName, fgVersion, FeatureGroup[].class);
        FeatureGroup resultFg = offlineFeatureGroups[0];
        resultFg.setFeatureStore(featureStore);
        return resultFg;
    }

    public StreamFeatureGroup getStreamFeatureGroup(FeatureStore featureStore, String fgName, Integer fgVersion) throws IOException, FeatureStoreException {
        StreamFeatureGroup[] streamFeatureGroups = this.getInternal(featureStore, fgName, fgVersion, StreamFeatureGroup[].class);
        StreamFeatureGroup resultFg = streamFeatureGroups[0];
        resultFg.setFeatureStore(featureStore);
        return resultFg;
    }

    public List<StreamFeatureGroup> getStreamFeatureGroups(FeatureStore featureStore, String fgName) throws FeatureStoreException, IOException {
        StreamFeatureGroup[] streamFeatureGroups = this.getInternal(featureStore, fgName, null, StreamFeatureGroup[].class);
        return Arrays.asList(streamFeatureGroups);
    }

    public List<ExternalFeatureGroup> getExternalFeatureGroups(FeatureStore featureStore, String fgName) throws FeatureStoreException, IOException {
        ExternalFeatureGroup[] offlineFeatureGroups = this.getInternal(featureStore, fgName, null, ExternalFeatureGroup[].class);
        return Arrays.asList(offlineFeatureGroups);
    }

    public ExternalFeatureGroup getExternalFeatureGroup(FeatureStore featureStore, String fgName, Integer fgVersion) throws IOException, FeatureStoreException {
        ExternalFeatureGroup[] offlineFeatureGroups = this.getInternal(featureStore, fgName, fgVersion, ExternalFeatureGroup[].class);
        ExternalFeatureGroup resultFg = offlineFeatureGroups[0];
        resultFg.setFeatureStore(featureStore);
        return resultFg;
    }

    private <U> U getInternal(FeatureStore featureStore, String fgName, Integer fgVersion, Class<U> fgType) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}/featuregroups{/fgName}{?version}";
        UriTemplate uri = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)featureStore.getProjectId()).set("fsId", (Object)featureStore.getId()).set("fgName", (Object)fgName);
        if (fgVersion != null) {
            uri.set("version", (Object)fgVersion);
        }
        String uriString = uri.expand();
        LOGGER.info("Sending metadata request: " + uriString);
        return hopsworksClient.handleRequest((HttpRequest)new HttpGet(uriString), fgType);
    }

    public ExternalFeatureGroup save(ExternalFeatureGroup externalFeatureGroup) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String featureGroupJson = hopsworksClient.getObjectMapper().writeValueAsString((Object)externalFeatureGroup);
        return this.saveInternal(externalFeatureGroup, new StringEntity(featureGroupJson), ExternalFeatureGroup.class);
    }

    public FeatureGroup save(FeatureGroup featureGroup) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String featureGroupJson = hopsworksClient.getObjectMapper().writeValueAsString((Object)featureGroup);
        return this.saveInternal(featureGroup, new StringEntity(featureGroupJson), FeatureGroup.class);
    }

    public StreamFeatureGroup save(StreamFeatureGroup featureGroup) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String featureGroupJson = hopsworksClient.getObjectMapper().writeValueAsString((Object)featureGroup);
        return this.saveInternal(featureGroup, new StringEntity(featureGroupJson), StreamFeatureGroup.class);
    }

    private <U> U saveInternal(FeatureGroupBase featureGroupBase, StringEntity entity, Class<U> fgType) throws FeatureStoreException, IOException {
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}/featuregroups";
        String uri = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)featureGroupBase.getFeatureStore().getProjectId()).set("fsId", (Object)featureGroupBase.getFeatureStore().getId()).expand();
        HttpPost postRequest = new HttpPost(uri);
        postRequest.setHeader("Content-Type", "application/json");
        postRequest.setEntity((HttpEntity)entity);
        LOGGER.info("Sending metadata request: " + uri);
        return HopsworksClient.getInstance().handleRequest((HttpRequest)postRequest, fgType);
    }

    public void delete(FeatureGroupBase featureGroupBase) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}/featuregroups{/fgId}{?updateStatsConfig,updateMetadata,validationType}";
        String uri = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)featureGroupBase.getFeatureStore().getProjectId()).set("fsId", (Object)featureGroupBase.getFeatureStore().getId()).set("fgId", (Object)featureGroupBase.getId()).expand();
        HttpDelete deleteRequest = new HttpDelete(uri);
        LOGGER.info("Sending metadata request: " + uri);
        hopsworksClient.handleRequest((HttpRequest)deleteRequest);
    }

    public void deleteContent(FeatureGroupBase featureGroup) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}/featuregroups{/fgId}{?updateStatsConfig,updateMetadata,validationType}/clear";
        String uri = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)featureGroup.getFeatureStore().getProjectId()).set("fsId", (Object)featureGroup.getFeatureStore().getId()).set("fgId", (Object)featureGroup.getId()).expand();
        LOGGER.info("Sending metadata request: " + uri);
        HttpPost postRequest = new HttpPost(uri);
        hopsworksClient.handleRequest((HttpRequest)postRequest);
    }

    public <T extends FeatureGroupBase> T updateMetadata(FeatureGroupBase featureGroup, String queryParameter, Class<T> fgType) throws FeatureStoreException, IOException {
        return this.updateMetadata(featureGroup, queryParameter, true, fgType);
    }

    public <T extends FeatureGroupBase> T updateMetadata(FeatureGroupBase featureGroup, String queryParameter, Object value, Class<T> fgType) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}/featuregroups{/fgId}{?updateStatsConfig,updateMetadata,validationType}";
        String uri = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)featureGroup.getFeatureStore().getProjectId()).set("fsId", (Object)featureGroup.getFeatureStore().getId()).set("fgId", (Object)featureGroup.getId()).set(queryParameter, value).expand();
        String featureGroupJson = hopsworksClient.getObjectMapper().writeValueAsString((Object)featureGroup);
        HttpPut putRequest = new HttpPut(uri);
        putRequest.setHeader("Content-Type", "application/json");
        putRequest.setEntity((HttpEntity)new StringEntity(featureGroupJson));
        LOGGER.info("Sending metadata request: " + uri);
        LOGGER.info(featureGroupJson);
        return (T)((FeatureGroupBase)hopsworksClient.handleRequest((HttpRequest)putRequest, fgType));
    }

    public FeatureGroupCommit featureGroupCommit(FeatureGroupBase featureGroup, FeatureGroupCommit featureGroupCommit) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}/featuregroups{/fgId}{?updateStatsConfig,updateMetadata,validationType}/commits{?filter_by,sort_by,offset,limit}";
        String uri = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)featureGroup.getFeatureStore().getProjectId()).set("fsId", (Object)featureGroup.getFeatureStore().getId()).set("fgId", (Object)featureGroup.getId()).expand();
        String featureGroupCommitJson = hopsworksClient.getObjectMapper().writeValueAsString((Object)featureGroupCommit);
        HttpPost postRequest = new HttpPost(uri);
        postRequest.setHeader("Content-Type", "application/json");
        postRequest.setEntity((HttpEntity)new StringEntity(featureGroupCommitJson));
        LOGGER.info("Sending metadata request: " + uri);
        return hopsworksClient.handleRequest((HttpRequest)postRequest, FeatureGroupCommit.class);
    }

    public List<FeatureGroupCommit> getCommitDetails(FeatureGroupBase featureGroupBase, Long wallclockTimestamp, Integer limit) throws IOException, FeatureStoreException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}/featuregroups{/fgId}{?updateStatsConfig,updateMetadata,validationType}/commits{?filter_by,sort_by,offset,limit}";
        UriTemplate uriTemplate = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)featureGroupBase.getFeatureStore().getProjectId()).set("fsId", (Object)featureGroupBase.getFeatureStore().getId()).set("fgId", (Object)featureGroupBase.getId()).set("sort_by", (Object)"committed_on:desc").set("offset", (Object)0).set("limit", (Object)limit);
        if (wallclockTimestamp != null) {
            uriTemplate.set("filter_by", (Object)("commited_on_ltoeq:" + wallclockTimestamp));
        }
        String uri = uriTemplate.expand();
        LOGGER.info("Sending metadata request: " + uri);
        FeatureGroupCommit featureGroupCommit = hopsworksClient.handleRequest((HttpRequest)new HttpGet(uri), FeatureGroupCommit.class);
        return featureGroupCommit.getItems();
    }

    public FeatureGroup getOrCreateFeatureGroup(FeatureStore featureStore, String name, Integer version, String description, List<String> primaryKeys, List<String> partitionKeys, String hudiPrecombineKey, boolean onlineEnabled, TimeTravelFormat timeTravelFormat, StatisticsConfig statisticsConfig, String eventTime) throws IOException, FeatureStoreException {
        FeatureGroup featureGroup;
        try {
            featureGroup = this.getFeatureGroup(featureStore, name, version);
        }
        catch (FeatureStoreException | IOException e) {
            if (e.getMessage().contains("Error: 404") && e.getMessage().contains("\"errorCode\":270009")) {
                featureGroup = FeatureGroup.builder().featureStore(featureStore).name(name).version(version).description(description).primaryKeys(primaryKeys).partitionKeys(partitionKeys).hudiPrecombineKey(hudiPrecombineKey).onlineEnabled(onlineEnabled).timeTravelFormat(timeTravelFormat).statisticsConfig(statisticsConfig).eventTime(eventTime).build();
                featureGroup.setFeatureStore(featureStore);
            }
            throw e;
        }
        return featureGroup;
    }

    public StreamFeatureGroup getOrCreateStreamFeatureGroup(FeatureStore featureStore, String name, Integer version, String description, List<String> primaryKeys, List<String> partitionKeys, String hudiPrecombineKey, boolean onlineEnabled, StatisticsConfig statisticsConfig, String eventTime) throws IOException, FeatureStoreException {
        StreamFeatureGroup featureGroup;
        try {
            featureGroup = this.getStreamFeatureGroup(featureStore, name, version);
        }
        catch (FeatureStoreException | IOException e) {
            if (e.getMessage().contains("Error: 404") && e.getMessage().contains("\"errorCode\":270009")) {
                featureGroup = StreamFeatureGroup.builder().featureStore(featureStore).name(name).version(version).description(description).primaryKeys(primaryKeys).partitionKeys(partitionKeys).hudiPrecombineKey(hudiPrecombineKey).onlineEnabled(onlineEnabled).statisticsConfig(statisticsConfig).eventTime(eventTime).build();
                featureGroup.setFeatureStore(featureStore);
            }
            throw e;
        }
        return featureGroup;
    }
}

