/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.metadata;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.logicalclocks.hsfs.EntityEndpointType;
import com.logicalclocks.hsfs.Feature;
import com.logicalclocks.hsfs.FeatureStore;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.StatisticsConfig;
import com.logicalclocks.hsfs.TimeTravelFormat;
import com.logicalclocks.hsfs.constructor.Filter;
import com.logicalclocks.hsfs.constructor.FilterLogic;
import com.logicalclocks.hsfs.constructor.Query;
import com.logicalclocks.hsfs.engine.FeatureGroupBaseEngine;
import com.logicalclocks.hsfs.engine.StatisticsEngine;
import com.logicalclocks.hsfs.metadata.Statistics;
import com.logicalclocks.hsfs.metadata.User;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureGroupBase {
    protected Integer id;
    protected FeatureStore featureStore;
    protected String name;
    protected Integer version;
    protected String description;
    @JsonIgnore
    protected List<String> primaryKeys;
    protected List<Feature> features;
    protected String eventTime;
    protected Date created;
    protected User creator;
    protected StatisticsConfig statisticsConfig = new StatisticsConfig();
    protected List<String> expectationsNames;
    protected String location;
    private FeatureGroupBaseEngine featureGroupBaseEngine = new FeatureGroupBaseEngine();
    protected StatisticsEngine statisticsEngine = new StatisticsEngine(EntityEndpointType.FEATURE_GROUP);
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureGroupBase.class);

    public FeatureGroupBase(FeatureStore featureStore, Integer id) {
        this.featureStore = featureStore;
        this.id = id;
    }

    public Query selectFeatures(List<Feature> features) {
        return new Query(this, features);
    }

    public Query select(List<String> features) {
        List<Feature> featureObjList = features.stream().map(Feature::new).collect(Collectors.toList());
        return this.selectFeatures(featureObjList);
    }

    public Query selectAll() {
        return new Query(this, this.getFeatures());
    }

    public Query selectExceptFeatures(List<Feature> features) {
        List<String> exceptFeatures = features.stream().map(Feature::getName).collect(Collectors.toList());
        return this.selectExcept(exceptFeatures);
    }

    public Query selectExcept(List<String> features) {
        return new Query(this, this.getFeatures().stream().filter((? super T f) -> !features.contains(f.getName())).collect(Collectors.toList()));
    }

    public void delete() throws FeatureStoreException, IOException {
        this.featureGroupBaseEngine.delete(this);
    }

    public <T> T read() throws FeatureStoreException, IOException {
        return null;
    }

    public void addTag(String name, Object value) throws FeatureStoreException, IOException {
        this.featureGroupBaseEngine.addTag(this, name, value);
    }

    @JsonIgnore
    public Map<String, Object> getTags() throws FeatureStoreException, IOException {
        return this.featureGroupBaseEngine.getTags(this);
    }

    @JsonIgnore
    public Object getTag(String name) throws FeatureStoreException, IOException {
        return this.featureGroupBaseEngine.getTag(this, name);
    }

    public void deleteTag(String name) throws FeatureStoreException, IOException {
        this.featureGroupBaseEngine.deleteTag(this, name);
    }

    public void updateDescription(String description) throws FeatureStoreException, IOException {
        this.featureGroupBaseEngine.updateDescription(this, description, this.getClass());
    }

    public void updateFeatureDescription(String featureName, String description) throws FeatureStoreException, IOException {
        this.featureGroupBaseEngine.updateFeatures(this, Collections.singletonList(Feature.builder().name(featureName).description(description).type("tmp").build()), this.getClass());
    }

    public void updateFeatures(List<Feature> features) throws FeatureStoreException, IOException, ParseException {
        this.featureGroupBaseEngine.appendFeatures(this, features, this.getClass());
    }

    public void updateFeatures(Feature feature) throws FeatureStoreException, IOException, ParseException {
        this.featureGroupBaseEngine.appendFeatures(this, Collections.singletonList(feature), this.getClass());
    }

    public void appendFeatures(List<Feature> features) throws FeatureStoreException, IOException, ParseException {
        this.featureGroupBaseEngine.appendFeatures(this, new ArrayList<Feature>(features), this.getClass());
    }

    public void appendFeatures(Feature features) throws FeatureStoreException, IOException, ParseException {
        ArrayList<Feature> featureList = new ArrayList<Feature>();
        featureList.add(features);
        this.featureGroupBaseEngine.appendFeatures(this, featureList, this.getClass());
    }

    public void updateStatisticsConfig() throws FeatureStoreException, IOException {
        this.featureGroupBaseEngine.updateStatisticsConfig(this, this.getClass());
    }

    public Statistics computeStatistics() throws FeatureStoreException, IOException {
        if (this.statisticsConfig.getEnabled().booleanValue()) {
            return this.statisticsEngine.computeStatistics(this, this.read(), null);
        }
        LOGGER.info("StorageWarning: The statistics are not enabled of feature group `" + this.name + "`, with version `" + this.version + "`. No statistics computed.");
        return null;
    }

    @JsonIgnore
    public Statistics getStatistics() throws FeatureStoreException, IOException {
        return this.statisticsEngine.getLast(this);
    }

    @JsonIgnore
    public Statistics getStatistics(String commitTime) throws FeatureStoreException, IOException {
        return this.statisticsEngine.get(this, commitTime);
    }

    public Query filter(Filter filter) throws FeatureStoreException, IOException {
        return this.selectAll().filter(filter);
    }

    public Query filter(FilterLogic filter) throws FeatureStoreException, IOException {
        return this.selectAll().filter(filter);
    }

    @JsonIgnore
    public Feature getFeature(String name) throws FeatureStoreException {
        return this.features.stream().filter((? super T f) -> f.getName().equalsIgnoreCase(name)).findFirst().orElseThrow(() -> new FeatureStoreException("Feature with name `" + name + "` not found in feature group `" + this.name + "`."));
    }

    @JsonIgnore
    public List<String> getPrimaryKeys() {
        if (this.primaryKeys == null) {
            this.primaryKeys = this.features.stream().filter((? super T f) -> f.getPrimary()).map(Feature::getName).collect(Collectors.toList());
        }
        return this.primaryKeys;
    }

    public String getOnlineTopicName() throws FeatureStoreException, IOException {
        return null;
    }

    @JsonIgnore
    public List<String> getComplexFeatures() {
        return null;
    }

    @JsonIgnore
    public String getFeatureAvroSchema(String featureName) throws FeatureStoreException, IOException {
        return null;
    }

    @JsonIgnore
    public String getEncodedAvroSchema() throws FeatureStoreException, IOException {
        return null;
    }

    @JsonIgnore
    public Schema getDeserializedAvroSchema() throws FeatureStoreException, IOException {
        return null;
    }

    public TimeTravelFormat getTimeTravelFormat() {
        return null;
    }

    public FeatureGroupBase() {
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public FeatureStore getFeatureStore() {
        return this.featureStore;
    }

    public void setFeatureStore(FeatureStore featureStore) {
        this.featureStore = featureStore;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<Feature> getFeatures() {
        return this.features;
    }

    public void setFeatures(List<Feature> features) {
        this.features = features;
    }

    public String getEventTime() {
        return this.eventTime;
    }

    public void setEventTime(String eventTime) {
        this.eventTime = eventTime;
    }

    public Date getCreated() {
        return this.created;
    }

    public User getCreator() {
        return this.creator;
    }

    public StatisticsConfig getStatisticsConfig() {
        return this.statisticsConfig;
    }

    public void setStatisticsConfig(StatisticsConfig statisticsConfig) {
        this.statisticsConfig = statisticsConfig;
    }

    public List<String> getExpectationsNames() {
        return this.expectationsNames;
    }

    public void setExpectationsNames(List<String> expectationsNames) {
        this.expectationsNames = expectationsNames;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }
}

