/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.logicalclocks.hsfs.DataFormat;
import com.logicalclocks.hsfs.FeatureGroup;
import com.logicalclocks.hsfs.FeatureStore;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.StatisticsConfig;
import com.logicalclocks.hsfs.StorageConnector;
import com.logicalclocks.hsfs.TrainingDataset;
import com.logicalclocks.hsfs.TrainingDatasetBundle;
import com.logicalclocks.hsfs.TrainingDatasetFeature;
import com.logicalclocks.hsfs.TrainingDatasetType;
import com.logicalclocks.hsfs.constructor.Filter;
import com.logicalclocks.hsfs.constructor.FilterLogic;
import com.logicalclocks.hsfs.constructor.Query;
import com.logicalclocks.hsfs.engine.FeatureGroupUtils;
import com.logicalclocks.hsfs.engine.FeatureViewEngine;
import com.logicalclocks.hsfs.engine.VectorServer;
import java.io.IOException;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureView {
    @JsonIgnore
    private Integer id;
    private String name;
    private Integer version;
    private String description;
    private List<TrainingDatasetFeature> features;
    @JsonIgnore
    private FeatureStore featureStore;
    private Query query;
    @JsonIgnore
    private List<String> labels;
    private String type = "featureViewDTO";
    private static FeatureViewEngine featureViewEngine = new FeatureViewEngine();
    private static VectorServer vectorServer = new VectorServer();
    private Integer extraFilterVersion = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureGroup.class);

    public FeatureView(@NonNull String name, Integer version, @NonNull Query query, String description, @NonNull FeatureStore featureStore, List<String> labels) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        if (featureStore == null) {
            throw new NullPointerException("featureStore is marked non-null but is null");
        }
        this.name = name;
        this.version = version;
        this.query = query;
        this.description = description;
        this.featureStore = featureStore;
        this.labels = labels != null ? labels.stream().map(String::toLowerCase).collect(Collectors.toList()) : null;
    }

    public void delete() throws FeatureStoreException, IOException {
        LOGGER.warn("JobWarning: All jobs associated to feature view `" + this.name + "`, version `" + this.version + "` will be removed.");
        featureViewEngine.delete(this.featureStore, this.name, this.version);
    }

    public static void clean(FeatureStore featureStore, String featureViewName, Integer featureViewVersion) throws FeatureStoreException, IOException {
        featureViewEngine.delete(featureStore, featureViewName, featureViewVersion);
    }

    public FeatureView update(FeatureView other) throws FeatureStoreException, IOException {
        return featureViewEngine.update(other);
    }

    public void initServing() throws FeatureStoreException, IOException, SQLException, ClassNotFoundException {
        vectorServer.initServing(this, false);
    }

    public void initServing(Boolean batch, Boolean external) throws FeatureStoreException, IOException, SQLException, ClassNotFoundException {
        vectorServer.initServing(this, (boolean)batch, (boolean)external);
    }

    public void initBatchScoring(Integer trainingDatasetVersion) {
        this.extraFilterVersion = trainingDatasetVersion;
    }

    @JsonIgnore
    public List<Object> getFeatureVector(Map<String, Object> entry) throws SQLException, FeatureStoreException, IOException, ClassNotFoundException {
        return vectorServer.getFeatureVector(this, entry);
    }

    @JsonIgnore
    public List<Object> getFeatureVector(Map<String, Object> entry, boolean external) throws SQLException, FeatureStoreException, IOException, ClassNotFoundException {
        return vectorServer.getFeatureVector(this, entry, external);
    }

    @JsonIgnore
    public List<List<Object>> getFeatureVectors(Map<String, List<Object>> entry) throws SQLException, FeatureStoreException, IOException, ClassNotFoundException {
        return vectorServer.getFeatureVectors(this, entry);
    }

    @JsonIgnore
    public List<List<Object>> getFeatureVectors(Map<String, List<Object>> entry, boolean external) throws SQLException, FeatureStoreException, IOException, ClassNotFoundException {
        return vectorServer.getFeatureVectors(this, entry, external);
    }

    @JsonIgnore
    public String getBatchQuery() throws FeatureStoreException, IOException, ParseException {
        return this.getBatchQuery(null, null);
    }

    @JsonIgnore
    public String getBatchQuery(String startTime, String endTime) throws FeatureStoreException, IOException, ParseException {
        return featureViewEngine.getBatchQueryString(this, startTime != null ? FeatureGroupUtils.getDateFromDateString(startTime) : null, endTime != null ? FeatureGroupUtils.getDateFromDateString(endTime) : null, this.extraFilterVersion);
    }

    @JsonIgnore
    public Dataset<Row> getBatchData(String startTime, String endTime) throws FeatureStoreException, IOException, ParseException {
        return this.getBatchData(startTime, endTime, Maps.newHashMap());
    }

    @JsonIgnore
    public Dataset<Row> getBatchData(String startTime, String endTime, Map<String, String> readOptions) throws FeatureStoreException, IOException, ParseException {
        return featureViewEngine.getBatchData(this, startTime != null ? FeatureGroupUtils.getDateFromDateString(startTime) : null, endTime != null ? FeatureGroupUtils.getDateFromDateString(endTime) : null, readOptions, this.extraFilterVersion);
    }

    public void addTag(String name, Object value) throws FeatureStoreException, IOException {
        featureViewEngine.addTag(this, name, value);
    }

    @JsonIgnore
    public Map<String, Object> getTags() throws FeatureStoreException, IOException {
        return featureViewEngine.getTags(this);
    }

    @JsonIgnore
    public Object getTag(String name) throws FeatureStoreException, IOException {
        return featureViewEngine.getTag(this, name);
    }

    public void deleteTag(String name) throws FeatureStoreException, IOException {
        featureViewEngine.deleteTag(this, name);
    }

    public Integer createTrainingData(String startTime, String endTime, String description, DataFormat dataFormat) throws IOException, FeatureStoreException, ParseException {
        TrainingDataset trainingDataset = this.featureStore.createTrainingDataset().name("").eventStartTime(startTime).eventEndTime(endTime).description(description).dataFormat(dataFormat).build();
        return featureViewEngine.createTrainingDataset(this, trainingDataset, null).getVersion();
    }

    public Integer createTrainingData(String startTime, String endTime, String description, DataFormat dataFormat, Boolean coalesce, StorageConnector storageConnector, String location, Long seed, StatisticsConfig statisticsConfig, Map<String, String> writeOptions, FilterLogic extraFilterLogic, Filter extraFilter) throws IOException, FeatureStoreException, ParseException {
        TrainingDataset trainingDataset = this.featureStore.createTrainingDataset().name("").eventStartTime(startTime).eventEndTime(endTime).description(description).dataFormat(dataFormat).coalesce(coalesce).storageConnector(storageConnector).location(location).seed(seed).statisticsConfig(statisticsConfig).extraFilterLogic(extraFilterLogic).extraFilter(extraFilter).build();
        return featureViewEngine.createTrainingDataset(this, trainingDataset, writeOptions).getVersion();
    }

    public Integer createTrainTestSplit(Float testSize, String trainStart, String trainEnd, String testStart, String testEnd, String description, DataFormat dataFormat) throws IOException, FeatureStoreException, ParseException {
        this.validateTrainTestSplit(testSize, trainEnd, testStart);
        TrainingDataset trainingDataset = this.featureStore.createTrainingDataset().name("").testSize(testSize).trainStart(trainStart).trainEnd(trainEnd).testStart(testStart).testEnd(testEnd).description(description).dataFormat(dataFormat).trainSplit("train").timeSplitSize(2).build();
        return featureViewEngine.createTrainingDataset(this, trainingDataset, null).getVersion();
    }

    public Integer createTrainTestSplit(Float testSize, String trainStart, String trainEnd, String testStart, String testEnd, String description, DataFormat dataFormat, Boolean coalesce, StorageConnector storageConnector, String location, Long seed, StatisticsConfig statisticsConfig, Map<String, String> writeOptions, FilterLogic extraFilterLogic, Filter extraFilter) throws IOException, FeatureStoreException, ParseException {
        this.validateTrainTestSplit(testSize, trainEnd, testStart);
        TrainingDataset trainingDataset = this.featureStore.createTrainingDataset().name("").testSize(testSize).trainStart(trainStart).trainEnd(trainEnd).testStart(testStart).testEnd(testEnd).description(description).dataFormat(dataFormat).coalesce(coalesce).storageConnector(storageConnector).location(location).trainSplit("train").seed(seed).timeSplitSize(2).statisticsConfig(statisticsConfig).extraFilterLogic(extraFilterLogic).extraFilter(extraFilter).build();
        return featureViewEngine.createTrainingDataset(this, trainingDataset, writeOptions).getVersion();
    }

    public Integer createTrainValidationTestSplit(Float validationSize, Float testSize, String trainStart, String trainEnd, String validationStart, String validationEnd, String testStart, String testEnd, String description, DataFormat dataFormat) throws IOException, FeatureStoreException, ParseException {
        this.validateTrainValidationTestSplit(validationSize, testSize, trainEnd, validationStart, validationEnd, testStart);
        TrainingDataset trainingDataset = this.featureStore.createTrainingDataset().name("").validationSize(validationSize).testSize(testSize).trainStart(trainStart).trainEnd(trainEnd).validationStart(validationStart).validationEnd(validationEnd).testStart(testStart).testEnd(testEnd).description(description).dataFormat(dataFormat).trainSplit("train").timeSplitSize(3).build();
        return featureViewEngine.createTrainingDataset(this, trainingDataset, null).getVersion();
    }

    public Integer createTrainValidationTestSplit(Float validationSize, Float testSize, String trainStart, String trainEnd, String validationStart, String validationEnd, String testStart, String testEnd, String description, DataFormat dataFormat, Boolean coalesce, StorageConnector storageConnector, String location, Long seed, StatisticsConfig statisticsConfig, Map<String, String> writeOptions, FilterLogic extraFilterLogic, Filter extraFilter) throws IOException, FeatureStoreException, ParseException {
        this.validateTrainValidationTestSplit(validationSize, testSize, trainEnd, validationStart, validationEnd, testStart);
        TrainingDataset trainingDataset = this.featureStore.createTrainingDataset().name("").validationSize(validationSize).testSize(testSize).trainStart(trainStart).trainEnd(trainEnd).validationStart(validationStart).validationEnd(validationEnd).testStart(testStart).testEnd(testEnd).description(description).dataFormat(dataFormat).coalesce(coalesce).storageConnector(storageConnector).location(location).trainSplit("train").timeSplitSize(3).seed(seed).statisticsConfig(statisticsConfig).extraFilterLogic(extraFilterLogic).extraFilter(extraFilter).build();
        return featureViewEngine.createTrainingDataset(this, trainingDataset, writeOptions).getVersion();
    }

    private List<Dataset<Row>> getDataset(TrainingDatasetBundle trainingDatasetBundle, List<String> splits) {
        ArrayList features = Lists.newArrayList();
        ArrayList labels = Lists.newArrayList();
        for (String split : splits) {
            List<Dataset<Row>> featureLabel = trainingDatasetBundle.getDataset(split, true);
            features.add(featureLabel.get(0));
            labels.add(featureLabel.get(1));
        }
        features.addAll(labels);
        return features;
    }

    public void recreateTrainingDataset(Integer version, Map<String, String> writeOptions) throws FeatureStoreException, IOException {
        featureViewEngine.recreateTrainingDataset(this, version, writeOptions);
    }

    public List<Dataset<Row>> getTrainingData(Integer version) throws IOException, FeatureStoreException, ParseException {
        return this.getTrainingData(version, null);
    }

    public List<Dataset<Row>> getTrainingData(Integer version, Map<String, String> readOptions) throws IOException, FeatureStoreException, ParseException {
        return featureViewEngine.getTrainingDataset(this, version, (List<String>)Lists.newArrayList(), readOptions).getDataset(true);
    }

    public List<Dataset<Row>> getTrainTestSplit(Integer version) throws IOException, FeatureStoreException, ParseException {
        return this.getTrainTestSplit(version, null);
    }

    public List<Dataset<Row>> getTrainTestSplit(Integer version, Map<String, String> readOptions) throws IOException, FeatureStoreException, ParseException {
        return this.getDataset(featureViewEngine.getTrainingDataset(this, version, (List<String>)Lists.newArrayList((Object[])new String[]{"train", "test"}), readOptions), Lists.newArrayList((Object[])new String[]{"train", "test"}));
    }

    public List<Dataset<Row>> getTrainValidationTestSplit(Integer version) throws IOException, FeatureStoreException, ParseException {
        return this.getTrainValidationTestSplit(version, null);
    }

    public List<Dataset<Row>> getTrainValidationTestSplit(Integer version, Map<String, String> readOptions) throws IOException, FeatureStoreException, ParseException {
        return this.getDataset(featureViewEngine.getTrainingDataset(this, version, (List<String>)Lists.newArrayList((Object[])new String[]{"train", "validataion", "test"}), readOptions), Lists.newArrayList((Object[])new String[]{"train", "validataion", "test"}));
    }

    public List<Dataset<Row>> trainingData(String startTime, String endTime, String description) throws IOException, FeatureStoreException, ParseException {
        TrainingDataset trainingDataset = this.featureStore.createTrainingDataset().name("").eventStartTime(startTime).eventEndTime(endTime).description(description).trainingDatasetType(TrainingDatasetType.IN_MEMORY_TRAINING_DATASET).build();
        return featureViewEngine.getTrainingDataset(this, trainingDataset, null).getDataset(true);
    }

    public List<Dataset<Row>> trainingData(String startTime, String endTime, String description, Long seed, StatisticsConfig statisticsConfig, Map<String, String> readOptions, FilterLogic extraFilterLogic, Filter extraFilter) throws IOException, FeatureStoreException, ParseException {
        TrainingDataset trainingDataset = this.featureStore.createTrainingDataset().name("").eventStartTime(startTime).eventEndTime(endTime).description(description).seed(seed).statisticsConfig(statisticsConfig).trainingDatasetType(TrainingDatasetType.IN_MEMORY_TRAINING_DATASET).extraFilterLogic(extraFilterLogic).extraFilter(extraFilter).build();
        return featureViewEngine.getTrainingDataset(this, trainingDataset, readOptions).getDataset(true);
    }

    public List<Dataset<Row>> trainTestSplit(Float testSize, String trainStart, String trainEnd, String testStart, String testEnd, String description) throws IOException, FeatureStoreException, ParseException {
        this.validateTrainTestSplit(testSize, trainEnd, testStart);
        TrainingDataset trainingDataset = this.featureStore.createTrainingDataset().name("").testSize(testSize).trainStart(trainStart).trainEnd(trainEnd).testStart(testStart).testEnd(testEnd).description(description).trainSplit("train").timeSplitSize(2).trainingDatasetType(TrainingDatasetType.IN_MEMORY_TRAINING_DATASET).build();
        return this.getDataset(featureViewEngine.getTrainingDataset(this, trainingDataset, null), Lists.newArrayList((Object[])new String[]{"train", "test"}));
    }

    public List<Dataset<Row>> trainTestSplit(Float testSize, String trainStart, String trainEnd, String testStart, String testEnd, String description, Long seed, StatisticsConfig statisticsConfig, Map<String, String> readOptions, FilterLogic extraFilterLogic, Filter extraFilter) throws IOException, FeatureStoreException, ParseException {
        this.validateTrainTestSplit(testSize, trainEnd, testStart);
        TrainingDataset trainingDataset = this.featureStore.createTrainingDataset().name("").testSize(testSize).trainStart(trainStart).trainEnd(trainEnd).testStart(testStart).testEnd(testEnd).description(description).trainSplit("train").timeSplitSize(2).seed(seed).trainingDatasetType(TrainingDatasetType.IN_MEMORY_TRAINING_DATASET).statisticsConfig(statisticsConfig).extraFilterLogic(extraFilterLogic).extraFilter(extraFilter).build();
        return this.getDataset(featureViewEngine.getTrainingDataset(this, trainingDataset, readOptions), Lists.newArrayList((Object[])new String[]{"train", "test"}));
    }

    public List<Dataset<Row>> trainValidationTestSplit(Float validationSize, Float testSize, String trainStart, String trainEnd, String validationStart, String validationEnd, String testStart, String testEnd, String description) throws IOException, FeatureStoreException, ParseException {
        this.validateTrainValidationTestSplit(validationSize, testSize, trainEnd, validationStart, validationEnd, testStart);
        TrainingDataset trainingDataset = this.featureStore.createTrainingDataset().name("").validationSize(validationSize).testSize(testSize).trainStart(trainStart).trainEnd(trainEnd).validationStart(validationStart).validationEnd(validationEnd).testStart(testStart).testEnd(testEnd).description(description).trainSplit("train").timeSplitSize(3).trainingDatasetType(TrainingDatasetType.IN_MEMORY_TRAINING_DATASET).build();
        return this.getDataset(featureViewEngine.getTrainingDataset(this, trainingDataset, null), Lists.newArrayList((Object[])new String[]{"train", "validataion", "test"}));
    }

    public List<Dataset<Row>> trainValidationTestSplit(Float validationSize, Float testSize, String trainStart, String trainEnd, String validationStart, String validationEnd, String testStart, String testEnd, String description, Long seed, StatisticsConfig statisticsConfig, Map<String, String> readOptions, FilterLogic extraFilterLogic, Filter extraFilter) throws IOException, FeatureStoreException, ParseException {
        this.validateTrainValidationTestSplit(validationSize, testSize, trainEnd, validationStart, validationEnd, testStart);
        TrainingDataset trainingDataset = this.featureStore.createTrainingDataset().name("").validationSize(validationSize).testSize(testSize).trainStart(trainStart).trainEnd(trainEnd).validationStart(validationStart).validationEnd(validationEnd).testStart(testStart).testEnd(testEnd).description(description).trainSplit("train").timeSplitSize(3).seed(seed).trainingDatasetType(TrainingDatasetType.IN_MEMORY_TRAINING_DATASET).statisticsConfig(statisticsConfig).extraFilterLogic(extraFilterLogic).extraFilter(extraFilter).build();
        return this.getDataset(featureViewEngine.getTrainingDataset(this, trainingDataset, readOptions), Lists.newArrayList((Object[])new String[]{"train", "validataion", "test"}));
    }

    private void validateTrainTestSplit(Float testSize, String trainEnd, String testStart) throws FeatureStoreException {
        if ((testSize == null || !(testSize.floatValue() > 0.0f) || !(testSize.floatValue() < 1.0f)) && Strings.isNullOrEmpty((String)trainEnd) && Strings.isNullOrEmpty((String)testStart)) {
            throw new FeatureStoreException("Invalid split input.You should specify either `testSize` or (`trainEnd` or `testStart`). `testSize` should be between 0 and 1 if specified.");
        }
    }

    private void validateTrainValidationTestSplit(Float validationSize, Float testSize, String trainEnd, String validationStart, String validationEnd, String testStart) throws FeatureStoreException {
        if ((validationSize == null || !(validationSize.floatValue() > 0.0f) || !(validationSize.floatValue() < 1.0f) || testSize == null || !(testSize.floatValue() > 0.0f) || !(testSize.floatValue() < 1.0f) || !(validationSize.floatValue() + testSize.floatValue() < 1.0f)) && (Strings.isNullOrEmpty((String)trainEnd) && Strings.isNullOrEmpty((String)validationStart) || Strings.isNullOrEmpty((String)validationEnd) && Strings.isNullOrEmpty((String)testStart))) {
            throw new FeatureStoreException("Invalid split input. You should specify either (`validationSize` and `testSize`) or ((`trainEnd` or `validationStart`) and (`validationEnd` or `testStart`)).`validationSize`, `testSize` and sum of `validationSize` and `testSize` should be between 0 and 1 if specified.");
        }
    }

    public void purgeTrainingData(Integer version) throws FeatureStoreException, IOException {
        featureViewEngine.deleteTrainingDatasetOnly(this, version);
    }

    public void purgeAllTrainingData() throws FeatureStoreException, IOException {
        featureViewEngine.deleteTrainingDatasetOnly(this);
    }

    public void deleteTrainingDataset(Integer version) throws FeatureStoreException, IOException {
        featureViewEngine.deleteTrainingData(this, version);
    }

    public void deleteAllTrainingDatasets() throws FeatureStoreException, IOException {
        featureViewEngine.deleteTrainingData(this);
    }

    public void addTrainingDatasetTag(Integer version, String name, Object value) throws FeatureStoreException, IOException {
        featureViewEngine.addTag(this, name, value, version);
    }

    @JsonIgnore
    public Map<String, Object> getTrainingDatasetTags(Integer version) throws FeatureStoreException, IOException {
        return featureViewEngine.getTags(this, version);
    }

    @JsonIgnore
    public Object getTrainingDatasetTag(Integer version, String name) throws FeatureStoreException, IOException {
        return featureViewEngine.getTag(this, name, version);
    }

    public void deleteTrainingDatasetTag(Integer version, String name) throws FeatureStoreException, IOException {
        featureViewEngine.deleteTag(this, name, version);
    }

    @JsonIgnore
    public HashSet<String> getPrimaryKeys() throws SQLException, IOException, FeatureStoreException, ClassNotFoundException {
        if (vectorServer.getServingKeys().isEmpty()) {
            this.initServing();
        }
        return vectorServer.getServingKeys();
    }

    public FeatureView() {
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<TrainingDatasetFeature> getFeatures() {
        return this.features;
    }

    public void setFeatures(List<TrainingDatasetFeature> features) {
        this.features = features;
    }

    public FeatureStore getFeatureStore() {
        return this.featureStore;
    }

    public void setFeatureStore(FeatureStore featureStore) {
        this.featureStore = featureStore;
    }

    public Query getQuery() {
        return this.query;
    }

    public void setQuery(Query query) {
        this.query = query;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public void setLabels(List<String> labels) {
        this.labels = labels;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public static class FeatureViewBuilder {
        private String name;
        private Integer version;
        private String description;
        private FeatureStore featureStore;
        private Query query;
        private List<String> labels;

        public FeatureViewBuilder(FeatureStore featureStore) {
            this.featureStore = featureStore;
        }

        public FeatureViewBuilder name(String name) {
            this.name = name;
            return this;
        }

        public FeatureViewBuilder version(Integer version) {
            this.version = version;
            return this;
        }

        public FeatureViewBuilder description(String description) {
            this.description = description;
            return this;
        }

        public FeatureViewBuilder query(Query query) {
            this.query = query;
            if (query.isTimeTravel()) {
                LOGGER.info("`as_of` argument in the `Query` will be ignored because feature view does not support time travel query.");
            }
            return this;
        }

        public FeatureViewBuilder labels(List<String> labels) {
            this.labels = labels;
            return this;
        }

        public FeatureView build() throws FeatureStoreException, IOException {
            FeatureView featureView = new FeatureView(this.name, this.version, this.query, this.description, this.featureStore, this.labels);
            featureViewEngine.save(featureView);
            return featureView;
        }
    }
}

