/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs;

import com.google.common.base.Strings;
import com.logicalclocks.hsfs.FeatureStore;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.Project;
import com.logicalclocks.hsfs.SecretStore;
import com.logicalclocks.hsfs.metadata.FeatureStoreApi;
import com.logicalclocks.hsfs.metadata.HopsworksClient;
import com.logicalclocks.hsfs.metadata.ProjectApi;
import java.io.Closeable;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.regions.Region;

public class HopsworksConnection
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(HopsworksConnection.class);
    private String host;
    private int port;
    private String project;
    private Region region;
    private SecretStore secretStore;
    private boolean hostnameVerification;
    private String trustStorePath;
    private String certPath;
    private String apiKeyFilePath;
    private String apiKeyValue;
    private FeatureStoreApi featureStoreApi = new FeatureStoreApi();
    private ProjectApi projectApi = new ProjectApi();
    private Project projectObj;

    public HopsworksConnection(String host, int port, String project, Region region, SecretStore secretStore, boolean hostnameVerification, String trustStorePath, String certPath, String apiKeyFilePath, String apiKeyValue) throws IOException, FeatureStoreException {
        this.host = host;
        this.port = port;
        this.project = this.getProjectName(project);
        this.region = region;
        this.secretStore = secretStore;
        this.hostnameVerification = hostnameVerification;
        this.trustStorePath = trustStorePath;
        this.certPath = certPath;
        this.apiKeyFilePath = apiKeyFilePath;
        this.apiKeyValue = apiKeyValue;
        HopsworksClient.setupHopsworksClient(host, port, region, secretStore, hostnameVerification, trustStorePath, this.apiKeyFilePath, this.apiKeyValue);
        this.projectObj = this.getProject();
        HopsworksClient.getInstance().setProject(this.projectObj);
    }

    public FeatureStore getFeatureStore() throws IOException, FeatureStoreException {
        return this.getFeatureStore(this.rewriteFeatureStoreName(this.project));
    }

    public FeatureStore getFeatureStore(String name) throws IOException, FeatureStoreException {
        return this.featureStoreApi.get(this.projectObj.getProjectId(), this.rewriteFeatureStoreName(name));
    }

    private String rewriteFeatureStoreName(String name) {
        if ((name = name.toLowerCase()).endsWith("_featurestore")) {
            return name;
        }
        return name + "_featurestore";
    }

    @Override
    public void close() {
    }

    private Project getProject() throws IOException, FeatureStoreException {
        LOGGER.info("Getting information for project name: " + this.project);
        return this.projectApi.get(this.project);
    }

    private String getProjectName(String project) {
        if (Strings.isNullOrEmpty((String)project)) {
            return System.getProperty("hopsworks.projectname");
        }
        return project;
    }

    public static HopsworksConnectionBuilder builder() {
        return new HopsworksConnectionBuilder();
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public Region getRegion() {
        return this.region;
    }

    public SecretStore getSecretStore() {
        return this.secretStore;
    }

    public boolean isHostnameVerification() {
        return this.hostnameVerification;
    }

    public String getTrustStorePath() {
        return this.trustStorePath;
    }

    public String getCertPath() {
        return this.certPath;
    }

    public String getApiKeyFilePath() {
        return this.apiKeyFilePath;
    }

    public String getApiKeyValue() {
        return this.apiKeyValue;
    }

    public static class HopsworksConnectionBuilder {
        private String host;
        private int port;
        private String project;
        private Region region;
        private SecretStore secretStore;
        private boolean hostnameVerification;
        private String trustStorePath;
        private String certPath;
        private String apiKeyFilePath;
        private String apiKeyValue;

        HopsworksConnectionBuilder() {
        }

        public HopsworksConnectionBuilder host(String host) {
            this.host = host;
            return this;
        }

        public HopsworksConnectionBuilder port(int port) {
            this.port = port;
            return this;
        }

        public HopsworksConnectionBuilder project(String project) {
            this.project = project;
            return this;
        }

        public HopsworksConnectionBuilder region(Region region) {
            this.region = region;
            return this;
        }

        public HopsworksConnectionBuilder secretStore(SecretStore secretStore) {
            this.secretStore = secretStore;
            return this;
        }

        public HopsworksConnectionBuilder hostnameVerification(boolean hostnameVerification) {
            this.hostnameVerification = hostnameVerification;
            return this;
        }

        public HopsworksConnectionBuilder trustStorePath(String trustStorePath) {
            this.trustStorePath = trustStorePath;
            return this;
        }

        public HopsworksConnectionBuilder certPath(String certPath) {
            this.certPath = certPath;
            return this;
        }

        public HopsworksConnectionBuilder apiKeyFilePath(String apiKeyFilePath) {
            this.apiKeyFilePath = apiKeyFilePath;
            return this;
        }

        public HopsworksConnectionBuilder apiKeyValue(String apiKeyValue) {
            this.apiKeyValue = apiKeyValue;
            return this;
        }

        public HopsworksConnection build() throws IOException, FeatureStoreException {
            return new HopsworksConnection(this.host, this.port, this.project, this.region, this.secretStore, this.hostnameVerification, this.trustStorePath, this.certPath, this.apiKeyFilePath, this.apiKeyValue);
        }

        public String toString() {
            return "HopsworksConnection.HopsworksConnectionBuilder(host=" + this.host + ", port=" + this.port + ", project=" + this.project + ", region=" + this.region + ", secretStore=" + (Object)((Object)this.secretStore) + ", hostnameVerification=" + this.hostnameVerification + ", trustStorePath=" + this.trustStorePath + ", certPath=" + this.certPath + ", apiKeyFilePath=" + this.apiKeyFilePath + ", apiKeyValue=" + this.apiKeyValue + ")";
        }
    }
}

