/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.logicalclocks.hsfs.DeltaStreamerJobConf;
import com.logicalclocks.hsfs.EntityEndpointType;
import com.logicalclocks.hsfs.Feature;
import com.logicalclocks.hsfs.FeatureStore;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.JobConfiguration;
import com.logicalclocks.hsfs.SaveMode;
import com.logicalclocks.hsfs.StatisticsConfig;
import com.logicalclocks.hsfs.StorageConnector;
import com.logicalclocks.hsfs.constructor.Query;
import com.logicalclocks.hsfs.engine.CodeEngine;
import com.logicalclocks.hsfs.engine.StatisticsEngine;
import com.logicalclocks.hsfs.engine.StreamFeatureGroupEngine;
import com.logicalclocks.hsfs.metadata.FeatureGroupBase;
import java.io.IOException;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.avro.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class StreamFeatureGroup
extends FeatureGroupBase {
    private Boolean onlineEnabled;
    private StorageConnector onlineStorageConnector;
    private StorageConnector offlineStorageConnector;
    private String type = "streamFeatureGroupDTO";
    protected String location;
    private List<String> statisticColumns;
    @JsonIgnore
    private List<String> partitionKeys;
    @JsonIgnore
    private String hudiPrecombineKey;
    private String onlineTopicName;
    private DeltaStreamerJobConf deltaStreamerJobConf;
    private final StreamFeatureGroupEngine streamFeatureGroupEngine = new StreamFeatureGroupEngine();
    private final StatisticsEngine statisticsEngine = new StatisticsEngine(EntityEndpointType.FEATURE_GROUP);
    private final CodeEngine codeEngine = new CodeEngine(EntityEndpointType.FEATURE_GROUP);
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamFeatureGroup.class);

    public StreamFeatureGroup(FeatureStore featureStore, @NonNull String name, Integer version, String description, List<String> primaryKeys, List<String> partitionKeys, String hudiPrecombineKey, boolean onlineEnabled, List<Feature> features, StatisticsConfig statisticsConfig, String onlineTopicName, String eventTime) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.featureStore = featureStore;
        this.name = name;
        this.version = version;
        this.description = description;
        this.primaryKeys = primaryKeys != null ? primaryKeys.stream().map(String::toLowerCase).collect(Collectors.toList()) : null;
        this.partitionKeys = partitionKeys != null ? partitionKeys.stream().map(String::toLowerCase).collect(Collectors.toList()) : null;
        this.hudiPrecombineKey = hudiPrecombineKey != null ? hudiPrecombineKey.toLowerCase() : null;
        this.onlineEnabled = onlineEnabled;
        this.features = features;
        this.statisticsConfig = statisticsConfig != null ? statisticsConfig : new StatisticsConfig();
        this.onlineTopicName = onlineTopicName;
        this.eventTime = eventTime;
    }

    public StreamFeatureGroup(Integer id, String description, List<Feature> features) {
        this.id = id;
        this.description = description;
        this.features = features;
    }

    public StreamFeatureGroup(FeatureStore featureStore, int id) {
        this.featureStore = featureStore;
        this.id = id;
    }

    public Object read() throws FeatureStoreException, IOException {
        return this.read(false, null);
    }

    public Object read(boolean online) throws FeatureStoreException, IOException {
        return this.read(online, null);
    }

    public Object read(boolean online, Map<String, String> readOptions) throws FeatureStoreException, IOException {
        return this.selectAll().read(online, readOptions);
    }

    public Object read(String wallclockTime) throws FeatureStoreException, IOException, ParseException {
        return this.selectAll().asOf(wallclockTime).read(false, null);
    }

    public Object read(String wallclockTime, Map<String, String> readOptions) throws FeatureStoreException, IOException, ParseException {
        return this.selectAll().asOf(wallclockTime).read(false, readOptions);
    }

    @Deprecated
    public Object readChanges(String wallclockStartTime, String wallclockEndTime) throws FeatureStoreException, IOException, ParseException {
        return this.selectAll().pullChanges(wallclockStartTime, wallclockEndTime).read(false, null);
    }

    @Deprecated
    public Object readChanges(String wallclockStartTime, String wallclockEndTime, Map<String, String> readOptions) throws FeatureStoreException, IOException, ParseException {
        return this.selectAll().pullChanges(wallclockStartTime, wallclockEndTime).read(false, readOptions);
    }

    public Query asOf(String wallclockTime) throws FeatureStoreException, ParseException {
        return this.selectAll().asOf(wallclockTime);
    }

    public Query asOf(String wallclockTime, String excludeUntil) throws FeatureStoreException, ParseException {
        return this.selectAll().asOf(wallclockTime, excludeUntil);
    }

    @Deprecated
    public <S> void save(S featureData, Map<String, String> writeOptions) throws FeatureStoreException, IOException, ParseException {
        this.streamFeatureGroupEngine.save(this, featureData, this.partitionKeys, this.hudiPrecombineKey, writeOptions, null);
        this.codeEngine.saveCode(this);
    }

    @Deprecated
    public <S> void save(S featureData, Map<String, String> writeOptions, JobConfiguration jobConfiguration) throws FeatureStoreException, IOException, ParseException {
        this.streamFeatureGroupEngine.save(this, featureData, this.partitionKeys, this.hudiPrecombineKey, writeOptions, jobConfiguration);
        this.codeEngine.saveCode(this);
    }

    public <S> void insert(S featureData) throws FeatureStoreException, IOException, ParseException {
        this.insert(featureData, false, SaveMode.APPEND, null, null);
    }

    public <S> void insert(S featureData, Map<String, String> writeOptions) throws FeatureStoreException, IOException, ParseException {
        this.insert(featureData, false, SaveMode.APPEND, writeOptions, null);
    }

    public <S> void insert(S featureData, JobConfiguration jobConfiguration) throws FeatureStoreException, IOException, ParseException {
        this.insert(featureData, false, SaveMode.APPEND, null, jobConfiguration);
    }

    public <S> void insert(S featureData, boolean overwrite, SaveMode saveMode, Map<String, String> writeOptions) throws FeatureStoreException, IOException, ParseException {
        this.insert(featureData, false, SaveMode.APPEND, writeOptions, null);
    }

    public <S> void insert(S featureData, boolean overwrite, SaveMode saveMode, JobConfiguration jobConfiguration) throws FeatureStoreException, IOException, ParseException {
        this.insert(featureData, false, SaveMode.APPEND, jobConfiguration);
    }

    public <S> void insert(S featureData, boolean overwrite, SaveMode saveMode, Map<String, String> writeOptions, JobConfiguration jobConfiguration) throws FeatureStoreException, IOException, ParseException {
        this.streamFeatureGroupEngine.insert(this, featureData, saveMode, this.partitionKeys, this.hudiPrecombineKey, writeOptions, jobConfiguration);
        this.codeEngine.saveCode(this);
    }

    public <S> Object insertStream(S featureData) throws FeatureStoreException, IOException, ParseException {
        return this.insertStream(featureData, null, "append", false, null, null, null);
    }

    public <S> Object insertStream(S featureData, String queryName) throws FeatureStoreException, IOException, ParseException {
        return this.insertStream(featureData, queryName, null, false, null, null, null);
    }

    public <S> Object insertStream(S featureData, Map<String, String> writeOptions) throws FeatureStoreException, IOException, ParseException {
        return this.insertStream(featureData, null, null, false, null, null, writeOptions);
    }

    public <S> Object insertStream(S featureData, String queryName, Map<String, String> writeOptions) throws FeatureStoreException, IOException, ParseException {
        return this.insertStream(featureData, queryName, "append", false, null, null, writeOptions);
    }

    public <S> Object insertStream(S featureData, String queryName, String outputMode) throws FeatureStoreException, IOException, ParseException {
        return this.insertStream(featureData, queryName, outputMode, false, null, null, null);
    }

    public <S> Object insertStream(S featureData, String queryName, String outputMode, String checkpointLocation) throws FeatureStoreException, IOException, ParseException {
        return this.insertStream(featureData, queryName, outputMode, false, null, checkpointLocation, null);
    }

    public <S> Object insertStream(S featureData, String queryName, String outputMode, boolean awaitTermination, Long timeout) throws FeatureStoreException, IOException, ParseException {
        return this.insertStream(featureData, queryName, outputMode, awaitTermination, timeout, null, null);
    }

    public <S> Object insertStream(S featureData, String queryName, String outputMode, boolean awaitTermination, Long timeout, String checkpointLocation) throws FeatureStoreException, IOException, ParseException {
        return this.insertStream(featureData, queryName, outputMode, awaitTermination, timeout, checkpointLocation, null);
    }

    public <S> Object insertStream(S featureData, String queryName, String outputMode, boolean awaitTermination, Long timeout, String checkpointLocation, Map<String, String> writeOptions) throws FeatureStoreException, IOException, ParseException {
        return this.insertStream(featureData, queryName, outputMode, awaitTermination, timeout, checkpointLocation, writeOptions, null);
    }

    public <S> Object insertStream(S featureData, String queryName, String outputMode, boolean awaitTermination, Long timeout, String checkpointLocation, Map<String, String> writeOptions, JobConfiguration jobConfiguration) {
        return this.streamFeatureGroupEngine.insertStream(this, featureData, queryName, outputMode, awaitTermination, timeout, checkpointLocation, this.partitionKeys, this.hudiPrecombineKey, writeOptions, jobConfiguration);
    }

    public <S> void commitDeleteRecord(S featureData) throws FeatureStoreException, IOException, ParseException {
        this.utils.commitDelete(this, featureData, null);
    }

    public <S> void commitDeleteRecord(S featureData, Map<String, String> writeOptions) throws FeatureStoreException, IOException, ParseException {
        this.utils.commitDelete(this, featureData, writeOptions);
    }

    public Map<Long, Map<String, String>> commitDetails() throws IOException, FeatureStoreException, ParseException {
        return this.utils.commitDetails(this, null);
    }

    public Map<Long, Map<String, String>> commitDetails(Integer limit) throws IOException, FeatureStoreException, ParseException {
        return this.utils.commitDetails(this, limit);
    }

    public Map<Long, Map<String, String>> commitDetails(String wallclockTime) throws IOException, FeatureStoreException, ParseException {
        return this.utils.commitDetailsByWallclockTime(this, wallclockTime, null);
    }

    public Map<Long, Map<String, String>> commitDetails(String wallclockTime, Integer limit) throws IOException, FeatureStoreException, ParseException {
        return this.utils.commitDetailsByWallclockTime(this, wallclockTime, limit);
    }

    @JsonIgnore
    public String getAvroSchema() throws FeatureStoreException, IOException {
        return this.getSubject().getSchema();
    }

    @Override
    @JsonIgnore
    public List<String> getComplexFeatures() {
        return this.utils.getComplexFeatures(this.features);
    }

    @Override
    @JsonIgnore
    public String getFeatureAvroSchema(String featureName) throws FeatureStoreException, IOException {
        return this.utils.getFeatureAvroSchema(featureName, this.utils.getDeserializedAvroSchema(this.getAvroSchema()));
    }

    @Override
    @JsonIgnore
    public String getEncodedAvroSchema() throws FeatureStoreException, IOException {
        return this.utils.getEncodedAvroSchema(this.getDeserializedAvroSchema(), this.utils.getComplexFeatures(this.features));
    }

    @Override
    @JsonIgnore
    public Schema getDeserializedAvroSchema() throws FeatureStoreException, IOException {
        return this.utils.getDeserializedAvroSchema(this.getAvroSchema());
    }

    public static StreamFeatureGroupBuilder builder() {
        return new StreamFeatureGroupBuilder();
    }

    public StreamFeatureGroup() {
    }

    public StreamFeatureGroup(Boolean onlineEnabled, StorageConnector onlineStorageConnector, StorageConnector offlineStorageConnector, String type, String location, List<String> statisticColumns, List<String> partitionKeys, String hudiPrecombineKey, String onlineTopicName, DeltaStreamerJobConf deltaStreamerJobConf) {
        this.onlineEnabled = onlineEnabled;
        this.onlineStorageConnector = onlineStorageConnector;
        this.offlineStorageConnector = offlineStorageConnector;
        this.type = type;
        this.location = location;
        this.statisticColumns = statisticColumns;
        this.partitionKeys = partitionKeys;
        this.hudiPrecombineKey = hudiPrecombineKey;
        this.onlineTopicName = onlineTopicName;
        this.deltaStreamerJobConf = deltaStreamerJobConf;
    }

    public Boolean getOnlineEnabled() {
        return this.onlineEnabled;
    }

    public void setOnlineEnabled(Boolean onlineEnabled) {
        this.onlineEnabled = onlineEnabled;
    }

    public StorageConnector getOnlineStorageConnector() {
        return this.onlineStorageConnector;
    }

    public void setOnlineStorageConnector(StorageConnector onlineStorageConnector) {
        this.onlineStorageConnector = onlineStorageConnector;
    }

    public StorageConnector getOfflineStorageConnector() {
        return this.offlineStorageConnector;
    }

    public void setOfflineStorageConnector(StorageConnector offlineStorageConnector) {
        this.offlineStorageConnector = offlineStorageConnector;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public void setLocation(String location) {
        this.location = location;
    }

    public List<String> getStatisticColumns() {
        return this.statisticColumns;
    }

    public void setStatisticColumns(List<String> statisticColumns) {
        this.statisticColumns = statisticColumns;
    }

    @Override
    public String getOnlineTopicName() {
        return this.onlineTopicName;
    }

    public void setOnlineTopicName(String onlineTopicName) {
        this.onlineTopicName = onlineTopicName;
    }

    public void setDeltaStreamerJobConf(DeltaStreamerJobConf deltaStreamerJobConf) {
        this.deltaStreamerJobConf = deltaStreamerJobConf;
    }

    public static class StreamFeatureGroupBuilder {
        private FeatureStore featureStore;
        private String name;
        private Integer version;
        private String description;
        private List<String> primaryKeys;
        private List<String> partitionKeys;
        private String hudiPrecombineKey;
        private boolean onlineEnabled;
        private List<Feature> features;
        private StatisticsConfig statisticsConfig;
        private String onlineTopicName;
        private String eventTime;

        StreamFeatureGroupBuilder() {
        }

        public StreamFeatureGroupBuilder featureStore(FeatureStore featureStore) {
            this.featureStore = featureStore;
            return this;
        }

        public StreamFeatureGroupBuilder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        public StreamFeatureGroupBuilder version(Integer version) {
            this.version = version;
            return this;
        }

        public StreamFeatureGroupBuilder description(String description) {
            this.description = description;
            return this;
        }

        public StreamFeatureGroupBuilder primaryKeys(List<String> primaryKeys) {
            this.primaryKeys = primaryKeys;
            return this;
        }

        public StreamFeatureGroupBuilder partitionKeys(List<String> partitionKeys) {
            this.partitionKeys = partitionKeys;
            return this;
        }

        public StreamFeatureGroupBuilder hudiPrecombineKey(String hudiPrecombineKey) {
            this.hudiPrecombineKey = hudiPrecombineKey;
            return this;
        }

        public StreamFeatureGroupBuilder onlineEnabled(boolean onlineEnabled) {
            this.onlineEnabled = onlineEnabled;
            return this;
        }

        public StreamFeatureGroupBuilder features(List<Feature> features) {
            this.features = features;
            return this;
        }

        public StreamFeatureGroupBuilder statisticsConfig(StatisticsConfig statisticsConfig) {
            this.statisticsConfig = statisticsConfig;
            return this;
        }

        public StreamFeatureGroupBuilder onlineTopicName(String onlineTopicName) {
            this.onlineTopicName = onlineTopicName;
            return this;
        }

        public StreamFeatureGroupBuilder eventTime(String eventTime) {
            this.eventTime = eventTime;
            return this;
        }

        public StreamFeatureGroup build() {
            return new StreamFeatureGroup(this.featureStore, this.name, this.version, this.description, this.primaryKeys, this.partitionKeys, this.hudiPrecombineKey, this.onlineEnabled, this.features, this.statisticsConfig, this.onlineTopicName, this.eventTime);
        }

        public String toString() {
            return "StreamFeatureGroup.StreamFeatureGroupBuilder(featureStore=" + this.featureStore + ", name=" + this.name + ", version=" + this.version + ", description=" + this.description + ", primaryKeys=" + this.primaryKeys + ", partitionKeys=" + this.partitionKeys + ", hudiPrecombineKey=" + this.hudiPrecombineKey + ", onlineEnabled=" + this.onlineEnabled + ", features=" + this.features + ", statisticsConfig=" + this.statisticsConfig + ", onlineTopicName=" + this.onlineTopicName + ", eventTime=" + this.eventTime + ")";
        }
    }
}

