/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.Lists;
import com.logicalclocks.hsfs.engine.SparkEngine;
import java.util.List;
import java.util.Map;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;

public class TrainingDatasetBundle {
    private Integer version;
    private Map<String, Dataset<Row>> datasetSplits;
    private Dataset<Row> dataset;
    private List<String> labels;
    private boolean hasSplit = false;
    private Boolean inMemory = true;

    public TrainingDatasetBundle(Integer version, Dataset<Row> dataset, List<String> labels) {
        this.version = version;
        this.dataset = dataset;
        this.labels = labels;
    }

    public TrainingDatasetBundle(Integer version) {
        this.version = version;
        this.inMemory = false;
    }

    public TrainingDatasetBundle(Integer version, Map<String, Dataset<Row>> datasetSplits, List<String> labels) {
        this.version = version;
        this.datasetSplits = datasetSplits;
        this.labels = labels;
        this.hasSplit = true;
    }

    @JsonIgnore
    public List<Dataset<Row>> getDataset(Boolean splitLabels) {
        if (this.inMemory.booleanValue()) {
            if (this.hasSplit) {
                return this.getDataset("train", splitLabels);
            }
            if (splitLabels.booleanValue()) {
                return SparkEngine.splitLabels(this.dataset, this.labels);
            }
            return Lists.newArrayList((Object[])new Dataset[]{this.dataset});
        }
        return null;
    }

    @JsonIgnore
    public List<Dataset<Row>> getDataset(String split, Boolean splitLabels) {
        if (this.inMemory.booleanValue()) {
            if (splitLabels.booleanValue()) {
                return SparkEngine.splitLabels(this.datasetSplits.get(split), this.labels);
            }
            return Lists.newArrayList((Object[])new Dataset[]{this.datasetSplits.get(split)});
        }
        return null;
    }

    public Integer getVersion() {
        return this.version;
    }
}

