/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.constructor;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.logicalclocks.hsfs.Feature;
import com.logicalclocks.hsfs.FeatureGroup;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.Storage;
import com.logicalclocks.hsfs.StorageConnector;
import com.logicalclocks.hsfs.constructor.Filter;
import com.logicalclocks.hsfs.constructor.FilterLogic;
import com.logicalclocks.hsfs.constructor.FsQuery;
import com.logicalclocks.hsfs.constructor.Join;
import com.logicalclocks.hsfs.constructor.JoinType;
import com.logicalclocks.hsfs.engine.FeatureGroupUtils;
import com.logicalclocks.hsfs.engine.SparkEngine;
import com.logicalclocks.hsfs.metadata.FeatureGroupBase;
import com.logicalclocks.hsfs.metadata.QueryConstructorApi;
import com.logicalclocks.hsfs.metadata.StorageConnectorApi;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Query {
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureGroup.class);
    private FeatureGroupBase leftFeatureGroup;
    private List<Feature> leftFeatures;
    private Long leftFeatureGroupStartTime;
    private Long leftFeatureGroupEndTime;
    private List<Join> joins = new ArrayList<Join>();
    private FilterLogic filter;
    private Boolean hiveEngine = false;
    private QueryConstructorApi queryConstructorApi = new QueryConstructorApi();
    private StorageConnectorApi storageConnectorApi = new StorageConnectorApi();
    private FeatureGroupUtils utils = new FeatureGroupUtils();

    public Query(FeatureGroupBase leftFeatureGroup, List<Feature> leftFeatures) {
        this.leftFeatureGroup = leftFeatureGroup;
        this.leftFeatures = leftFeatures;
    }

    public Query join(Query subquery) {
        return this.join(subquery, JoinType.INNER);
    }

    public Query join(Query subquery, String prefix) {
        return this.join(subquery, JoinType.INNER, prefix);
    }

    public Query join(Query subquery, List<String> on) {
        return this.joinFeatures(subquery, on.stream().map(Feature::new).collect(Collectors.toList()), JoinType.INNER);
    }

    public Query join(Query subquery, List<String> leftOn, List<String> rightOn) {
        return this.joinFeatures(subquery, leftOn.stream().map(Feature::new).collect(Collectors.toList()), rightOn.stream().map(Feature::new).collect(Collectors.toList()), JoinType.INNER);
    }

    public Query join(Query subquery, List<String> leftOn, List<String> rightOn, String prefix) {
        return this.joinFeatures(subquery, leftOn.stream().map(Feature::new).collect(Collectors.toList()), rightOn.stream().map(Feature::new).collect(Collectors.toList()), JoinType.INNER, prefix);
    }

    public Query join(Query subquery, JoinType joinType) {
        this.joins.add(new Join(subquery, joinType, null));
        return this;
    }

    public Query join(Query subquery, JoinType joinType, String prefix) {
        this.joins.add(new Join(subquery, joinType, prefix));
        return this;
    }

    public Query join(Query subquery, List<String> on, JoinType joinType) {
        this.joins.add(new Join(subquery, on.stream().map(Feature::new).collect(Collectors.toList()), joinType, null));
        return this;
    }

    public Query join(Query subquery, List<String> on, JoinType joinType, String prefix) {
        this.joins.add(new Join(subquery, on.stream().map(Feature::new).collect(Collectors.toList()), joinType, prefix));
        return this;
    }

    public Query join(Query subquery, List<String> leftOn, List<String> rightOn, JoinType joinType) {
        this.joins.add(new Join(subquery, leftOn.stream().map(Feature::new).collect(Collectors.toList()), rightOn.stream().map(Feature::new).collect(Collectors.toList()), joinType, null));
        return this;
    }

    public Query join(Query subquery, List<String> leftOn, List<String> rightOn, JoinType joinType, String prefix) {
        this.joins.add(new Join(subquery, leftOn.stream().map(Feature::new).collect(Collectors.toList()), rightOn.stream().map(Feature::new).collect(Collectors.toList()), joinType, prefix));
        return this;
    }

    public Query joinFeatures(Query subquery, List<Feature> on) {
        return this.joinFeatures(subquery, on, JoinType.INNER);
    }

    public Query joinFeatures(Query subquery, List<Feature> on, String prefix) {
        return this.joinFeatures(subquery, on, JoinType.INNER, prefix);
    }

    public Query joinFeatures(Query subquery, List<Feature> leftOn, List<Feature> rightOn) {
        return this.joinFeatures(subquery, leftOn, rightOn, JoinType.INNER);
    }

    public Query joinFeatures(Query subquery, List<Feature> leftOn, List<Feature> rightOn, String prefix) {
        return this.joinFeatures(subquery, leftOn, rightOn, JoinType.INNER, prefix);
    }

    public Query joinFeatures(Query subquery, List<Feature> on, JoinType joinType) {
        this.joins.add(new Join(subquery, on, joinType, null));
        return this;
    }

    public Query joinFeatures(Query subquery, List<Feature> on, JoinType joinType, String prefix) {
        this.joins.add(new Join(subquery, on, joinType, prefix));
        return this;
    }

    public Query joinFeatures(Query subquery, List<Feature> leftOn, List<Feature> rightOn, JoinType joinType) {
        this.joins.add(new Join(subquery, leftOn, rightOn, joinType, null));
        return this;
    }

    public Query joinFeatures(Query subquery, List<Feature> leftOn, List<Feature> rightOn, JoinType joinType, String prefix) {
        this.joins.add(new Join(subquery, leftOn, rightOn, joinType, prefix));
        return this;
    }

    public Query asOf(String wallclockTime) throws FeatureStoreException, ParseException {
        return this.asOf(wallclockTime, null);
    }

    public Query asOf(String wallclockTime, String excludeUntil) throws FeatureStoreException, ParseException {
        Long wallclockTimestamp = FeatureGroupUtils.getTimeStampFromDateString(wallclockTime);
        Long excludeUntilTimestamp = null;
        if (excludeUntil != null) {
            excludeUntilTimestamp = FeatureGroupUtils.getTimeStampFromDateString(excludeUntil);
        }
        for (Join join : this.joins) {
            Query queryWithTimeStamp = join.getQuery();
            queryWithTimeStamp.setLeftFeatureGroupEndTime(wallclockTimestamp);
            if (excludeUntilTimestamp != null) {
                queryWithTimeStamp.setLeftFeatureGroupStartTime(excludeUntilTimestamp);
            }
            join.setQuery(queryWithTimeStamp);
        }
        this.setLeftFeatureGroupEndTime(wallclockTimestamp);
        if (excludeUntilTimestamp != null) {
            this.setLeftFeatureGroupStartTime(excludeUntilTimestamp);
        }
        return this;
    }

    public Query pullChanges(String wallclockStartTime, String wallclockEndTime) throws FeatureStoreException, ParseException {
        this.setLeftFeatureGroupStartTime(FeatureGroupUtils.getTimeStampFromDateString(wallclockStartTime));
        this.setLeftFeatureGroupEndTime(FeatureGroupUtils.getTimeStampFromDateString(wallclockEndTime));
        return this;
    }

    public Object read() throws FeatureStoreException, IOException {
        return this.read(false, null);
    }

    public Object read(boolean online) throws FeatureStoreException, IOException {
        return this.read(online, null);
    }

    public Object read(boolean online, Map<String, String> readOptions) throws FeatureStoreException, IOException {
        FsQuery fsQuery = this.queryConstructorApi.constructQuery(this.leftFeatureGroup.getFeatureStore(), this);
        if (online) {
            LOGGER.info("Executing query: " + fsQuery.getStorageQuery(Storage.ONLINE));
            StorageConnector.JdbcConnector onlineConnector = this.storageConnectorApi.getOnlineStorageConnector(this.leftFeatureGroup.getFeatureStore());
            return ((StorageConnector)onlineConnector).read(fsQuery.getStorageQuery(Storage.ONLINE), null, null, null);
        }
        fsQuery.registerOnDemandFeatureGroups();
        fsQuery.registerHudiFeatureGroups(readOptions);
        LOGGER.info("Executing query: " + fsQuery.getStorageQuery(Storage.OFFLINE));
        return SparkEngine.getInstance().sql(fsQuery.getStorageQuery(Storage.OFFLINE));
    }

    public void show(int numRows) throws FeatureStoreException, IOException {
        this.show(false, numRows);
    }

    public void show(boolean online, int numRows) throws FeatureStoreException, IOException {
        SparkEngine.getInstance().objectToDataset(this.read(online)).show(numRows);
    }

    public String sql() {
        return this.sql(Storage.OFFLINE);
    }

    public String sql(Storage storage) {
        try {
            return this.queryConstructorApi.constructQuery(this.leftFeatureGroup.getFeatureStore(), this).getStorageQuery(storage);
        }
        catch (FeatureStoreException | IOException e) {
            return e.getMessage();
        }
    }

    public Query filter(Filter filter) {
        this.filter = this.filter == null ? new FilterLogic(filter) : this.filter.and(filter);
        return this;
    }

    public Query filter(FilterLogic filter) {
        this.filter = this.filter == null ? filter : this.filter.and(filter);
        return this;
    }

    public Query appendFeature(Feature feature) {
        this.leftFeatures.add(feature);
        return this;
    }

    @JsonIgnore
    public boolean isTimeTravel() {
        if (this.leftFeatureGroupStartTime != null || this.leftFeatureGroupEndTime != null) {
            return true;
        }
        for (Join join : this.joins) {
            if (!join.getQuery().isTimeTravel()) continue;
            return true;
        }
        return false;
    }

    public Query() {
    }

    public FeatureGroupBase getLeftFeatureGroup() {
        return this.leftFeatureGroup;
    }

    public void setLeftFeatureGroup(FeatureGroupBase leftFeatureGroup) {
        this.leftFeatureGroup = leftFeatureGroup;
    }

    public List<Feature> getLeftFeatures() {
        return this.leftFeatures;
    }

    public void setLeftFeatures(List<Feature> leftFeatures) {
        this.leftFeatures = leftFeatures;
    }

    public Long getLeftFeatureGroupStartTime() {
        return this.leftFeatureGroupStartTime;
    }

    public void setLeftFeatureGroupStartTime(Long leftFeatureGroupStartTime) {
        this.leftFeatureGroupStartTime = leftFeatureGroupStartTime;
    }

    public Long getLeftFeatureGroupEndTime() {
        return this.leftFeatureGroupEndTime;
    }

    public void setLeftFeatureGroupEndTime(Long leftFeatureGroupEndTime) {
        this.leftFeatureGroupEndTime = leftFeatureGroupEndTime;
    }

    public List<Join> getJoins() {
        return this.joins;
    }

    public void setJoins(List<Join> joins) {
        this.joins = joins;
    }

    public FilterLogic getFilter() {
        return this.filter;
    }

    public void setFilter(FilterLogic filter) {
        this.filter = filter;
    }

    public Boolean getHiveEngine() {
        return this.hiveEngine;
    }

    public void setHiveEngine(Boolean hiveEngine) {
        this.hiveEngine = hiveEngine;
    }
}

