/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.engine;

import com.databricks.dbutils_v1.DBUtilsHolder;
import com.databricks.dbutils_v1.DBUtilsV1;
import com.google.common.base.Strings;
import com.logicalclocks.hsfs.EntityEndpointType;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.TrainingDataset;
import com.logicalclocks.hsfs.metadata.Code;
import com.logicalclocks.hsfs.metadata.CodeApi;
import com.logicalclocks.hsfs.metadata.FeatureGroupBase;
import java.io.IOException;
import java.sql.Timestamp;
import java.time.LocalDateTime;

public class CodeEngine {
    private CodeApi codeApi;
    private static final String WEB_PROXY_ENV = "APPLICATION_WEB_PROXY_BASE";
    private static final String KERNEL_ENV = "HOPSWORKS_KERNEL_ID";
    private static final String JOB_ENV = "HOPSWORKS_JOB_NAME";

    public CodeEngine(EntityEndpointType entityType) {
        this.codeApi = new CodeApi(entityType);
    }

    public void saveCode(TrainingDataset trainingDataset) throws FeatureStoreException, IOException {
        String kernelId = System.getenv(KERNEL_ENV);
        String jobName = System.getenv(JOB_ENV);
        if (!Strings.isNullOrEmpty((String)kernelId)) {
            this.codeApi.post(trainingDataset, this.saveCode(), kernelId, Code.RunType.JUPYTER, null);
        } else if (!Strings.isNullOrEmpty((String)jobName)) {
            this.codeApi.post(trainingDataset, this.saveCode(), jobName, Code.RunType.JOB, null);
        } else {
            try {
                DBUtilsV1 dbutils = DBUtilsHolder.dbutils();
                String notebookPath = (String)dbutils.notebook().getContext().notebookPath().get();
                String browserHostName = (String)dbutils.notebook().getContext().browserHostName().get();
                this.codeApi.post(trainingDataset, this.saveCode(), notebookPath, Code.RunType.DATABRICKS, browserHostName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void saveCode(FeatureGroupBase featureGroup) throws FeatureStoreException, IOException {
        String kernelId = System.getenv(KERNEL_ENV);
        String jobName = System.getenv(JOB_ENV);
        if (!Strings.isNullOrEmpty((String)kernelId)) {
            this.codeApi.post(featureGroup, this.saveCode(), kernelId, Code.RunType.JUPYTER, null);
        } else if (!Strings.isNullOrEmpty((String)jobName)) {
            this.codeApi.post(featureGroup, this.saveCode(), jobName, Code.RunType.JOB, null);
        } else {
            try {
                DBUtilsV1 dbutils = DBUtilsHolder.dbutils();
                String notebookPath = (String)dbutils.notebook().getContext().notebookPath().get();
                String browserHostName = (String)dbutils.notebook().getContext().browserHostName().get();
                this.codeApi.post(featureGroup, this.saveCode(), notebookPath, Code.RunType.DATABRICKS, browserHostName);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private Code saveCode() {
        Long commitTime = Timestamp.valueOf(LocalDateTime.now()).getTime();
        String applicationId = null;
        String webProxy = System.getenv(WEB_PROXY_ENV);
        if (!Strings.isNullOrEmpty((String)webProxy)) {
            applicationId = webProxy.substring(7);
        }
        return new Code(commitTime, applicationId);
    }
}

