/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.engine;

import com.google.common.collect.Lists;
import com.logicalclocks.hsfs.FeatureStore;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.FeatureView;
import com.logicalclocks.hsfs.StorageConnector;
import com.logicalclocks.hsfs.TrainingDataset;
import com.logicalclocks.hsfs.TrainingDatasetFeature;
import com.logicalclocks.hsfs.constructor.ServingPreparedStatement;
import com.logicalclocks.hsfs.metadata.FeatureViewApi;
import com.logicalclocks.hsfs.metadata.HopsworksClient;
import com.logicalclocks.hsfs.metadata.HopsworksExternalClient;
import com.logicalclocks.hsfs.metadata.StorageConnectorApi;
import com.logicalclocks.hsfs.metadata.TrainingDatasetApi;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.DatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;

public class VectorServer {
    private StorageConnectorApi storageConnectorApi = new StorageConnectorApi();
    private Schema.Parser parser = new Schema.Parser();
    private BinaryDecoder binaryDecoder = DecoderFactory.get().binaryDecoder(new byte[0], null);
    private TrainingDatasetApi trainingDatasetApi = new TrainingDatasetApi();
    private FeatureViewApi featureViewApi = new FeatureViewApi();
    private Connection preparedStatementConnection;
    private Map<Integer, TreeMap<String, Integer>> preparedStatementParameters;
    private TreeMap<Integer, PreparedStatement> preparedStatements;
    private TreeMap<Integer, String> preparedQueryString;
    private HashSet<String> servingKeys;
    private boolean isBatch = false;

    public VectorServer(boolean isBatch) {
        this.isBatch = isBatch;
    }

    public List<Object> getFeatureVector(TrainingDataset trainingDataset, Map<String, Object> entry) throws SQLException, FeatureStoreException, IOException, ClassNotFoundException {
        return this.getFeatureVector(trainingDataset, entry, HopsworksClient.getInstance().getHopsworksHttpClient() instanceof HopsworksExternalClient);
    }

    public List<Object> getFeatureVector(TrainingDataset trainingDataset, Map<String, Object> entry, boolean external) throws SQLException, FeatureStoreException, IOException, ClassNotFoundException {
        if (this.preparedStatements == null || this.isBatch) {
            this.initPreparedStatement(trainingDataset, false, external);
        }
        return this.getFeatureVector(trainingDataset.getFeatureStore(), trainingDataset.getFeatures(), entry, external);
    }

    public List<Object> getFeatureVector(FeatureView featureView, Map<String, Object> entry) throws FeatureStoreException, SQLException, IOException, ClassNotFoundException {
        return this.getFeatureVector(featureView, entry, HopsworksClient.getInstance().getHopsworksHttpClient() instanceof HopsworksExternalClient);
    }

    public List<Object> getFeatureVector(FeatureView featureView, Map<String, Object> entry, boolean external) throws SQLException, FeatureStoreException, IOException, ClassNotFoundException {
        if (this.preparedStatements == null || this.isBatch) {
            this.initPreparedStatement(featureView, false, external);
        }
        return this.getFeatureVector(featureView.getFeatureStore(), featureView.getFeatures(), entry, external);
    }

    private List<Object> getFeatureVector(FeatureStore featureStore, List<TrainingDatasetFeature> features, Map<String, Object> entry, boolean external) throws SQLException, FeatureStoreException, IOException {
        this.checkPrimaryKeys(entry.keySet());
        this.refreshJdbcConnection(featureStore, external);
        for (Integer fgId : this.preparedStatements.keySet()) {
            Map parameterIndexInStatement = this.preparedStatementParameters.get(fgId);
            for (String name : entry.keySet()) {
                if (!parameterIndexInStatement.containsKey(name)) continue;
                this.preparedStatements.get(fgId).setObject((Integer)parameterIndexInStatement.get(name), entry.get(name));
            }
        }
        return this.getFeatureVector(features);
    }

    private List<Object> getFeatureVector(List<TrainingDatasetFeature> features) throws SQLException, FeatureStoreException, IOException {
        Map<String, DatumReader<Object>> complexFeatureSchemas = this.getComplexFeatureSchemas(features);
        ArrayList<Object> servingVector = new ArrayList<Object>();
        for (Integer preparedStatementIndex : this.preparedStatements.keySet()) {
            ResultSet results = this.preparedStatements.get(preparedStatementIndex).executeQuery();
            if (!results.isBeforeFirst()) {
                throw new FeatureStoreException("No data was retrieved from online feature store.");
            }
            int columnCount = results.getMetaData().getColumnCount();
            while (results.next()) {
                for (int index = 1; index <= columnCount; ++index) {
                    if (complexFeatureSchemas.containsKey(results.getMetaData().getColumnName(index))) {
                        servingVector.add(this.deserializeComplexFeature(complexFeatureSchemas, results, index));
                        continue;
                    }
                    servingVector.add(results.getObject(index));
                }
            }
            results.close();
        }
        return servingVector;
    }

    public List<List<Object>> getFeatureVectors(TrainingDataset trainingDataset, Map<String, List<Object>> entry) throws SQLException, FeatureStoreException, IOException, ClassNotFoundException {
        return this.getFeatureVectors(trainingDataset, entry, HopsworksClient.getInstance().getHopsworksHttpClient() instanceof HopsworksExternalClient);
    }

    public List<List<Object>> getFeatureVectors(TrainingDataset trainingDataset, Map<String, List<Object>> entry, boolean external) throws SQLException, FeatureStoreException, IOException, ClassNotFoundException {
        if (this.preparedStatements == null || !this.isBatch) {
            this.initPreparedStatement(trainingDataset, true, external);
        }
        return this.getFeatureVectors(trainingDataset.getFeatureStore(), trainingDataset.getFeatures(), entry, external);
    }

    public List<List<Object>> getFeatureVectors(FeatureView featureView, Map<String, List<Object>> entry) throws SQLException, FeatureStoreException, IOException, ClassNotFoundException {
        return this.getFeatureVectors(featureView.getFeatureStore(), featureView.getFeatures(), entry, HopsworksClient.getInstance().getHopsworksHttpClient() instanceof HopsworksExternalClient);
    }

    public List<List<Object>> getFeatureVectors(FeatureView featureView, Map<String, List<Object>> entry, boolean external) throws SQLException, FeatureStoreException, IOException, ClassNotFoundException {
        if (this.preparedStatements == null || !this.isBatch) {
            this.initPreparedStatement(featureView, true, external);
        }
        return this.getFeatureVectors(featureView.getFeatureStore(), featureView.getFeatures(), entry, external);
    }

    private List<List<Object>> getFeatureVectors(FeatureStore featureStore, List<TrainingDatasetFeature> features, Map<String, List<Object>> entry) throws SQLException, FeatureStoreException, IOException {
        return this.getFeatureVectors(featureStore, features, entry, HopsworksClient.getInstance().getHopsworksHttpClient() instanceof HopsworksExternalClient);
    }

    private List<List<Object>> getFeatureVectors(FeatureStore featureStore, List<TrainingDatasetFeature> features, Map<String, List<Object>> entry, boolean external) throws SQLException, FeatureStoreException, IOException {
        this.checkPrimaryKeys(entry.keySet());
        ArrayList queries = Lists.newArrayList();
        for (Integer fgId : this.preparedQueryString.keySet()) {
            String query = this.preparedQueryString.get(fgId);
            String zippedTupleString = this.zipArraysToTupleString(this.preparedStatementParameters.get(fgId).keySet().stream().map(entry::get).collect(Collectors.toList()));
            queries.add(query.replaceFirst("\\?", zippedTupleString));
        }
        return this.getFeatureVectors(featureStore, features, queries, external);
    }

    private List<List<Object>> getFeatureVectors(FeatureStore featureStore, List<TrainingDatasetFeature> features, List<String> queries, boolean external) throws SQLException, FeatureStoreException, IOException {
        this.refreshJdbcConnection(featureStore, external);
        ArrayList<Object> servingVector = new ArrayList<Object>();
        Map<String, DatumReader<Object>> complexFeatureSchemas = this.getComplexFeatureSchemas(features);
        HashMap<Integer, ArrayList<Object>> servingVectorsMap = new HashMap<Integer, ArrayList<Object>>();
        Statement stmt = this.preparedStatementConnection.createStatement();
        for (String query : queries) {
            int orderInBatch = 0;
            ResultSet results = stmt.executeQuery(query);
            if (!results.isBeforeFirst()) {
                throw new FeatureStoreException("No data was retrieved from online feature store.");
            }
            int columnCount = results.getMetaData().getColumnCount();
            while (results.next()) {
                for (int index = 1; index <= columnCount; ++index) {
                    if (complexFeatureSchemas.containsKey(results.getMetaData().getColumnName(index))) {
                        servingVector.add(this.deserializeComplexFeature(complexFeatureSchemas, results, index));
                        continue;
                    }
                    servingVector.add(results.getObject(index));
                }
                if (servingVectorsMap.containsKey(orderInBatch)) {
                    ((List)servingVectorsMap.get(orderInBatch)).addAll(servingVector);
                } else {
                    servingVectorsMap.put(orderInBatch, servingVector);
                }
                servingVector = new ArrayList();
                ++orderInBatch;
            }
            results.close();
        }
        return new ArrayList<List<Object>>(servingVectorsMap.values());
    }

    public void initServing(TrainingDataset trainingDataset, boolean batch) throws FeatureStoreException, IOException, SQLException, ClassNotFoundException {
        this.initPreparedStatement(trainingDataset, batch);
    }

    public void initServing(TrainingDataset trainingDataset, boolean batch, boolean external) throws FeatureStoreException, IOException, SQLException, ClassNotFoundException {
        this.initPreparedStatement(trainingDataset, batch);
    }

    public void initServing(FeatureView featureView, boolean batch) throws FeatureStoreException, IOException, SQLException, ClassNotFoundException {
        this.initPreparedStatement(featureView, batch);
    }

    public void initServing(FeatureView featureView, boolean batch, boolean external) throws FeatureStoreException, IOException, SQLException, ClassNotFoundException {
        this.initPreparedStatement(featureView, batch, external);
    }

    public void initPreparedStatement(TrainingDataset trainingDataset, boolean batch) throws FeatureStoreException, IOException, SQLException, ClassNotFoundException {
        this.initPreparedStatement(trainingDataset, batch, HopsworksClient.getInstance().getHopsworksHttpClient() instanceof HopsworksExternalClient);
    }

    public void initPreparedStatement(TrainingDataset trainingDataset, boolean batch, boolean external) throws FeatureStoreException, IOException, SQLException, ClassNotFoundException {
        if (this.trainingDatasetApi.getTransformationFunctions(trainingDataset).size() > 0) {
            throw new FeatureStoreException("This training dataset has transformation functions attached and serving must performed from a Python application");
        }
        List<ServingPreparedStatement> servingPreparedStatements = this.trainingDatasetApi.getServingPreparedStatement(trainingDataset, batch);
        this.initPreparedStatement(trainingDataset.getFeatureStore(), servingPreparedStatements, batch, external);
    }

    public void initPreparedStatement(FeatureView featureView, boolean batch) throws FeatureStoreException, IOException, SQLException, ClassNotFoundException {
        this.initPreparedStatement(featureView, batch, HopsworksClient.getInstance().getHopsworksHttpClient() instanceof HopsworksExternalClient);
    }

    public void initPreparedStatement(FeatureView featureView, boolean batch, boolean external) throws FeatureStoreException, IOException, SQLException, ClassNotFoundException {
        if (this.featureViewApi.getTransformationFunctions(featureView).size() > 0) {
            throw new FeatureStoreException("This training dataset has transformation functions attached and serving must performed from a Python application");
        }
        List<ServingPreparedStatement> servingPreparedStatements = this.featureViewApi.getServingPreparedStatement(featureView, batch);
        this.initPreparedStatement(featureView.getFeatureStore(), servingPreparedStatements, batch, external);
    }

    private void initPreparedStatement(FeatureStore featureStore, List<ServingPreparedStatement> servingPreparedStatements, boolean batch) throws FeatureStoreException, IOException, SQLException, ClassNotFoundException {
        this.initPreparedStatement(featureStore, servingPreparedStatements, batch, HopsworksClient.getInstance().getHopsworksHttpClient() instanceof HopsworksExternalClient);
    }

    private void initPreparedStatement(FeatureStore featureStore, List<ServingPreparedStatement> servingPreparedStatements, boolean batch, boolean external) throws FeatureStoreException, IOException, SQLException, ClassNotFoundException {
        Class.forName("com.mysql.jdbc.Driver");
        this.isBatch = batch;
        this.setupJdbcConnection(featureStore, external);
        HashMap<Integer, TreeMap<String, Integer>> preparedStatementParameters = new HashMap<Integer, TreeMap<String, Integer>>();
        TreeMap<Integer, PreparedStatement> preparedStatements = new TreeMap<Integer, PreparedStatement>();
        TreeMap<Integer, String> preparedQueryString = new TreeMap<Integer, String>();
        HashSet servingVectorKeys = new HashSet();
        for (ServingPreparedStatement servingPreparedStatement : servingPreparedStatements) {
            if (batch) {
                preparedQueryString.put(servingPreparedStatement.getPreparedStatementIndex(), servingPreparedStatement.getQueryOnline());
            } else {
                preparedStatements.put(servingPreparedStatement.getPreparedStatementIndex(), this.preparedStatementConnection.prepareStatement(servingPreparedStatement.getQueryOnline()));
            }
            TreeMap parameterIndices = new TreeMap();
            servingPreparedStatement.getPreparedStatementParameters().forEach(preparedStatementParameter -> {
                servingVectorKeys.add(preparedStatementParameter.getName());
                parameterIndices.put(preparedStatementParameter.getName(), preparedStatementParameter.getIndex());
            });
            preparedStatementParameters.put(servingPreparedStatement.getPreparedStatementIndex(), parameterIndices);
        }
        this.servingKeys = servingVectorKeys;
        this.preparedStatementParameters = preparedStatementParameters;
        this.preparedStatements = preparedStatements;
        this.preparedQueryString = preparedQueryString;
    }

    private void setupJdbcConnection(FeatureStore featureStore, Boolean external) throws FeatureStoreException, IOException, SQLException {
        Connection jdbcConnection;
        StorageConnector.JdbcConnector storageConnector = this.storageConnectorApi.getOnlineStorageConnector(featureStore);
        Map<String, String> jdbcOptions = ((StorageConnector)storageConnector).sparkOptions();
        String url = jdbcOptions.get("url");
        if (external.booleanValue()) {
            url = url.replaceAll("/[0-9.]+:", "/" + HopsworksClient.getInstance().getHost() + ":");
        }
        this.preparedStatementConnection = jdbcConnection = DriverManager.getConnection(url, jdbcOptions.get("user"), jdbcOptions.get("password"));
    }

    private String zipArraysToTupleString(List<List<Object>> lists) {
        ArrayList<String> zippedTuples = new ArrayList<String>();
        for (int i = 0; i < lists.get(0).size(); ++i) {
            ArrayList<String> zippedArray = new ArrayList<String>();
            for (List<Object> in : lists) {
                zippedArray.add(in.get(i).toString());
            }
            zippedTuples.add("(" + String.join((CharSequence)",", zippedArray) + ")");
        }
        return "(" + String.join((CharSequence)",", zippedTuples) + ")";
    }

    private void refreshJdbcConnection(FeatureStore featureStore, Boolean external) throws FeatureStoreException, IOException, SQLException {
        if (!this.preparedStatementConnection.isValid(1)) {
            this.setupJdbcConnection(featureStore, external);
        }
    }

    private Object deserializeComplexFeature(Map<String, DatumReader<Object>> complexFeatureSchemas, ResultSet results, int index) throws SQLException, IOException {
        BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(results.getBytes(index), this.binaryDecoder);
        return complexFeatureSchemas.get(results.getMetaData().getColumnName(index)).read(null, (Decoder)decoder);
    }

    private Map<String, DatumReader<Object>> getComplexFeatureSchemas(List<TrainingDatasetFeature> features) throws FeatureStoreException, IOException {
        HashMap<String, DatumReader<Object>> featureSchemaMap = new HashMap<String, DatumReader<Object>>();
        for (TrainingDatasetFeature f : features) {
            if (!f.isComplex()) continue;
            GenericDatumReader datumReader = new GenericDatumReader(this.parser.parse(f.getFeaturegroup().getFeatureAvroSchema(f.getName())));
            featureSchemaMap.put(f.getName(), (DatumReader<Object>)datumReader);
        }
        return featureSchemaMap;
    }

    private void checkPrimaryKeys(Set<String> primaryKeys) {
        if (!this.servingKeys.equals(primaryKeys)) {
            throw new IllegalArgumentException("Provided primary key map doesn't correspond to serving_keys");
        }
    }

    public VectorServer() {
    }

    public HashSet<String> getServingKeys() {
        return this.servingKeys;
    }
}

