/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.logicalclocks.hsfs.EntityEndpointType;
import com.logicalclocks.hsfs.Feature;
import com.logicalclocks.hsfs.FeatureStore;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.HudiOperationType;
import com.logicalclocks.hsfs.StatisticsConfig;
import com.logicalclocks.hsfs.Storage;
import com.logicalclocks.hsfs.TimeTravelFormat;
import com.logicalclocks.hsfs.constructor.Query;
import com.logicalclocks.hsfs.engine.CodeEngine;
import com.logicalclocks.hsfs.engine.FeatureGroupEngine;
import com.logicalclocks.hsfs.engine.StatisticsEngine;
import com.logicalclocks.hsfs.metadata.FeatureGroupBase;
import com.logicalclocks.hsfs.metadata.Statistics;
import java.io.IOException;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.avro.Schema;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.streaming.StreamingQuery;
import org.apache.spark.sql.streaming.StreamingQueryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class FeatureGroup
extends FeatureGroupBase {
    private Boolean onlineEnabled;
    private String type = "cachedFeaturegroupDTO";
    private List<String> statisticColumns;
    @JsonIgnore
    private List<String> partitionKeys;
    @JsonIgnore
    private String hudiPrecombineKey;
    private String onlineTopicName;
    private final FeatureGroupEngine featureGroupEngine = new FeatureGroupEngine();
    private final StatisticsEngine statisticsEngine = new StatisticsEngine(EntityEndpointType.FEATURE_GROUP);
    private final CodeEngine codeEngine = new CodeEngine(EntityEndpointType.FEATURE_GROUP);
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureGroup.class);

    public FeatureGroup(FeatureStore featureStore, @NonNull String name, Integer version, String description, List<String> primaryKeys, List<String> partitionKeys, String hudiPrecombineKey, boolean onlineEnabled, TimeTravelFormat timeTravelFormat, List<Feature> features, StatisticsConfig statisticsConfig, String onlineTopicName, String eventTime) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.featureStore = featureStore;
        this.name = name;
        this.version = version;
        this.description = description;
        this.primaryKeys = primaryKeys != null ? primaryKeys.stream().map(String::toLowerCase).collect(Collectors.toList()) : null;
        this.partitionKeys = partitionKeys != null ? partitionKeys.stream().map(String::toLowerCase).collect(Collectors.toList()) : null;
        this.hudiPrecombineKey = timeTravelFormat == TimeTravelFormat.HUDI && hudiPrecombineKey != null ? hudiPrecombineKey.toLowerCase() : null;
        this.onlineEnabled = onlineEnabled;
        this.timeTravelFormat = timeTravelFormat != null ? timeTravelFormat : TimeTravelFormat.HUDI;
        this.features = features;
        this.statisticsConfig = statisticsConfig != null ? statisticsConfig : new StatisticsConfig();
        this.onlineTopicName = onlineTopicName;
        this.eventTime = eventTime;
    }

    public FeatureGroup() {
    }

    public FeatureGroup(Integer id, String description, List<Feature> features) {
        this.id = id;
        this.description = description;
        this.features = features;
    }

    public FeatureGroup(FeatureStore featureStore, int id) {
        this.featureStore = featureStore;
        this.id = id;
    }

    public Dataset<Row> read() throws FeatureStoreException, IOException {
        return this.read(false, null);
    }

    public Dataset<Row> read(boolean online) throws FeatureStoreException, IOException {
        return (Dataset)this.selectAll().read(online);
    }

    public Dataset<Row> read(Map<String, String> readOptions) throws FeatureStoreException, IOException {
        return this.read(false, readOptions);
    }

    public Dataset<Row> read(boolean online, Map<String, String> readOptions) throws FeatureStoreException, IOException {
        return (Dataset)this.selectAll().read(online, readOptions);
    }

    public Dataset<Row> read(String wallclockTime) throws FeatureStoreException, IOException, ParseException {
        return (Dataset)this.selectAll().asOf(wallclockTime).read(false, null);
    }

    public Dataset<Row> read(String wallclockTime, Map<String, String> readOptions) throws FeatureStoreException, IOException, ParseException {
        return (Dataset)this.selectAll().asOf(wallclockTime).read(false, readOptions);
    }

    public Dataset<Row> readChanges(String wallclockStartTime, String wallclockEndTime) throws FeatureStoreException, IOException, ParseException {
        return (Dataset)this.selectAll().pullChanges(wallclockStartTime, wallclockEndTime).read(false, null);
    }

    public Dataset<Row> readChanges(String wallclockStartTime, String wallclockEndTime, Map<String, String> readOptions) throws FeatureStoreException, IOException, ParseException {
        return (Dataset)this.selectAll().pullChanges(wallclockStartTime, wallclockEndTime).read(false, readOptions);
    }

    public Query asOf(String wallclockTime) throws FeatureStoreException, ParseException {
        return this.selectAll().asOf(wallclockTime);
    }

    public Query asOf(String wallclockTime, String excludeUntil) throws FeatureStoreException, ParseException {
        return this.selectAll().asOf(wallclockTime, excludeUntil);
    }

    public void show(int numRows) throws FeatureStoreException, IOException {
        this.show(numRows, false);
    }

    public void show(int numRows, boolean online) throws FeatureStoreException, IOException {
        this.read(online).show(numRows);
    }

    @Deprecated
    public void save(Dataset<Row> featureData) throws FeatureStoreException, IOException, ParseException {
        this.save(featureData, null);
    }

    @Deprecated
    public void save(Dataset<Row> featureData, Map<String, String> writeOptions) throws FeatureStoreException, IOException, ParseException {
        this.featureGroupEngine.save(this, featureData, this.partitionKeys, this.hudiPrecombineKey, writeOptions);
        this.codeEngine.saveCode(this);
        if (this.statisticsConfig.getEnabled().booleanValue()) {
            this.statisticsEngine.computeStatistics(this, featureData, null);
        }
    }

    public void insert(Dataset<Row> featureData) throws IOException, FeatureStoreException, ParseException {
        this.insert(featureData, null, false);
    }

    public void insert(Dataset<Row> featureData, Map<String, String> writeOptions) throws FeatureStoreException, IOException, ParseException {
        this.insert(featureData, null, false, null, writeOptions);
    }

    public void insert(Dataset<Row> featureData, Storage storage) throws IOException, FeatureStoreException, ParseException {
        this.insert(featureData, storage, false, null, null);
    }

    public void insert(Dataset<Row> featureData, boolean overwrite) throws IOException, FeatureStoreException, ParseException {
        this.insert(featureData, null, overwrite);
    }

    public void insert(Dataset<Row> featureData, Storage storage, boolean overwrite) throws IOException, FeatureStoreException, ParseException {
        this.insert(featureData, storage, overwrite, null, null);
    }

    public void insert(Dataset<Row> featureData, boolean overwrite, Map<String, String> writeOptions) throws FeatureStoreException, IOException, ParseException {
        this.insert(featureData, null, overwrite, null, writeOptions);
    }

    public void insert(Dataset<Row> featureData, HudiOperationType operation) throws FeatureStoreException, IOException, ParseException {
        this.insert(featureData, null, false, operation, null);
    }

    public void insert(Dataset<Row> featureData, Storage storage, boolean overwrite, HudiOperationType operation, Map<String, String> writeOptions) throws FeatureStoreException, IOException, ParseException {
        if (operation != null && this.timeTravelFormat == TimeTravelFormat.NONE) {
            throw new IllegalArgumentException("operation argument is valid only for time travel enable feature groups");
        }
        if (operation == null && this.timeTravelFormat == TimeTravelFormat.HUDI) {
            operation = overwrite ? HudiOperationType.BULK_INSERT : HudiOperationType.UPSERT;
        }
        this.featureGroupEngine.insert(this, featureData, storage, operation, overwrite ? SaveMode.Overwrite : SaveMode.Append, this.partitionKeys, this.hudiPrecombineKey, writeOptions);
        this.codeEngine.saveCode(this);
        this.computeStatistics();
    }

    @Deprecated
    public StreamingQuery insertStream(Dataset<Row> featureData) throws StreamingQueryException, IOException, FeatureStoreException, TimeoutException, ParseException {
        return this.insertStream(featureData, null);
    }

    @Deprecated
    public StreamingQuery insertStream(Dataset<Row> featureData, String queryName) throws StreamingQueryException, IOException, FeatureStoreException, TimeoutException, ParseException {
        return this.insertStream(featureData, queryName, "append");
    }

    @Deprecated
    public StreamingQuery insertStream(Dataset<Row> featureData, String queryName, String outputMode) throws StreamingQueryException, IOException, FeatureStoreException, TimeoutException, ParseException {
        return this.insertStream(featureData, queryName, outputMode, false, null, null, null);
    }

    @Deprecated
    public StreamingQuery insertStream(Dataset<Row> featureData, String queryName, String outputMode, boolean awaitTermination, Long timeout) throws StreamingQueryException, IOException, FeatureStoreException, TimeoutException, ParseException {
        return this.insertStream(featureData, queryName, outputMode, awaitTermination, timeout, null, null);
    }

    @Deprecated
    public StreamingQuery insertStream(Dataset<Row> featureData, String queryName, String outputMode, boolean awaitTermination, String checkpointLocation) throws StreamingQueryException, IOException, FeatureStoreException, TimeoutException, ParseException {
        return this.insertStream(featureData, queryName, outputMode, awaitTermination, null, checkpointLocation, null);
    }

    @Deprecated
    public StreamingQuery insertStream(Dataset<Row> featureData, String queryName, String outputMode, boolean awaitTermination, Long timeout, String checkpointLocation, Map<String, String> writeOptions) throws FeatureStoreException, IOException, StreamingQueryException, TimeoutException, ParseException {
        if (!featureData.isStreaming()) {
            throw new FeatureStoreException("Features have to be a streaming type spark dataframe. Use `insert()` method instead.");
        }
        LOGGER.info("StatisticsWarning: Stream ingestion for feature group `" + this.name + "`, with version `" + this.version + "` will not compute statistics.");
        return this.featureGroupEngine.insertStream(this, featureData, queryName, outputMode, awaitTermination, timeout, checkpointLocation, this.partitionKeys, this.hudiPrecombineKey, writeOptions);
    }

    public void commitDeleteRecord(Dataset<Row> featureData) throws FeatureStoreException, IOException, ParseException {
        this.utils.commitDelete(this, featureData, null);
    }

    public void commitDeleteRecord(Dataset<Row> featureData, Map<String, String> writeOptions) throws FeatureStoreException, IOException, ParseException {
        this.utils.commitDelete(this, featureData, writeOptions);
    }

    public Map<Long, Map<String, String>> commitDetails() throws IOException, FeatureStoreException, ParseException {
        return this.utils.commitDetails(this, null);
    }

    public Map<Long, Map<String, String>> commitDetails(Integer limit) throws IOException, FeatureStoreException, ParseException {
        return this.utils.commitDetails(this, limit);
    }

    public Map<Long, Map<String, String>> commitDetails(String wallclockTime) throws IOException, FeatureStoreException, ParseException {
        return this.utils.commitDetailsByWallclockTime(this, wallclockTime, null);
    }

    public Map<Long, Map<String, String>> commitDetails(String wallclockTime, Integer limit) throws IOException, FeatureStoreException, ParseException {
        return this.utils.commitDetailsByWallclockTime(this, wallclockTime, limit);
    }

    @JsonIgnore
    public String getAvroSchema() throws FeatureStoreException, IOException {
        return this.getSubject().getSchema();
    }

    @Override
    @JsonIgnore
    public List<String> getComplexFeatures() {
        return this.utils.getComplexFeatures(this.features);
    }

    @Override
    @JsonIgnore
    public String getFeatureAvroSchema(String featureName) throws FeatureStoreException, IOException {
        return this.utils.getFeatureAvroSchema(featureName, this.utils.getDeserializedAvroSchema(this.getAvroSchema()));
    }

    @Override
    @JsonIgnore
    public String getEncodedAvroSchema() throws FeatureStoreException, IOException {
        return this.utils.getEncodedAvroSchema(this.getDeserializedAvroSchema(), this.utils.getComplexFeatures(this.features));
    }

    @Override
    @JsonIgnore
    public Schema getDeserializedAvroSchema() throws FeatureStoreException, IOException {
        return this.utils.getDeserializedAvroSchema(this.getAvroSchema());
    }

    public Statistics computeStatistics(String wallclockTime) throws FeatureStoreException, IOException, ParseException {
        if (this.statisticsConfig.getEnabled().booleanValue()) {
            Map<Long, Map<String, String>> latestCommitMetaData = this.utils.commitDetailsByWallclockTime(this, wallclockTime, 1);
            Dataset featureData = (Dataset)this.selectAll().asOf(wallclockTime).read(false, null);
            Long commitId = (Long)latestCommitMetaData.keySet().toArray()[0];
            return this.statisticsEngine.computeStatistics(this, featureData, commitId);
        }
        LOGGER.info("StorageWarning: The statistics are not enabled of feature group `" + this.name + "`, with version `" + this.version + "`. No statistics computed.");
        return null;
    }

    public static FeatureGroupBuilder builder() {
        return new FeatureGroupBuilder();
    }

    public FeatureGroup(Boolean onlineEnabled, String type, List<String> statisticColumns, List<String> partitionKeys, String hudiPrecombineKey, String onlineTopicName) {
        this.onlineEnabled = onlineEnabled;
        this.type = type;
        this.statisticColumns = statisticColumns;
        this.partitionKeys = partitionKeys;
        this.hudiPrecombineKey = hudiPrecombineKey;
        this.onlineTopicName = onlineTopicName;
    }

    public Boolean getOnlineEnabled() {
        return this.onlineEnabled;
    }

    public void setOnlineEnabled(Boolean onlineEnabled) {
        this.onlineEnabled = onlineEnabled;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    public List<String> getStatisticColumns() {
        return this.statisticColumns;
    }

    public void setStatisticColumns(List<String> statisticColumns) {
        this.statisticColumns = statisticColumns;
    }

    @Override
    public String getOnlineTopicName() {
        return this.onlineTopicName;
    }

    public void setOnlineTopicName(String onlineTopicName) {
        this.onlineTopicName = onlineTopicName;
    }

    public static class FeatureGroupBuilder {
        private FeatureStore featureStore;
        private String name;
        private Integer version;
        private String description;
        private List<String> primaryKeys;
        private List<String> partitionKeys;
        private String hudiPrecombineKey;
        private boolean onlineEnabled;
        private TimeTravelFormat timeTravelFormat;
        private List<Feature> features;
        private StatisticsConfig statisticsConfig;
        private String onlineTopicName;
        private String eventTime;

        FeatureGroupBuilder() {
        }

        public FeatureGroupBuilder featureStore(FeatureStore featureStore) {
            this.featureStore = featureStore;
            return this;
        }

        public FeatureGroupBuilder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        public FeatureGroupBuilder version(Integer version) {
            this.version = version;
            return this;
        }

        public FeatureGroupBuilder description(String description) {
            this.description = description;
            return this;
        }

        public FeatureGroupBuilder primaryKeys(List<String> primaryKeys) {
            this.primaryKeys = primaryKeys;
            return this;
        }

        public FeatureGroupBuilder partitionKeys(List<String> partitionKeys) {
            this.partitionKeys = partitionKeys;
            return this;
        }

        public FeatureGroupBuilder hudiPrecombineKey(String hudiPrecombineKey) {
            this.hudiPrecombineKey = hudiPrecombineKey;
            return this;
        }

        public FeatureGroupBuilder onlineEnabled(boolean onlineEnabled) {
            this.onlineEnabled = onlineEnabled;
            return this;
        }

        public FeatureGroupBuilder timeTravelFormat(TimeTravelFormat timeTravelFormat) {
            this.timeTravelFormat = timeTravelFormat;
            return this;
        }

        public FeatureGroupBuilder features(List<Feature> features) {
            this.features = features;
            return this;
        }

        public FeatureGroupBuilder statisticsConfig(StatisticsConfig statisticsConfig) {
            this.statisticsConfig = statisticsConfig;
            return this;
        }

        public FeatureGroupBuilder onlineTopicName(String onlineTopicName) {
            this.onlineTopicName = onlineTopicName;
            return this;
        }

        public FeatureGroupBuilder eventTime(String eventTime) {
            this.eventTime = eventTime;
            return this;
        }

        public FeatureGroup build() {
            return new FeatureGroup(this.featureStore, this.name, this.version, this.description, this.primaryKeys, this.partitionKeys, this.hudiPrecombineKey, this.onlineEnabled, this.timeTravelFormat, this.features, this.statisticsConfig, this.onlineTopicName, this.eventTime);
        }

        public String toString() {
            return "FeatureGroup.FeatureGroupBuilder(featureStore=" + this.featureStore + ", name=" + this.name + ", version=" + this.version + ", description=" + this.description + ", primaryKeys=" + this.primaryKeys + ", partitionKeys=" + this.partitionKeys + ", hudiPrecombineKey=" + this.hudiPrecombineKey + ", onlineEnabled=" + this.onlineEnabled + ", timeTravelFormat=" + (Object)((Object)this.timeTravelFormat) + ", features=" + this.features + ", statisticsConfig=" + this.statisticsConfig + ", onlineTopicName=" + this.onlineTopicName + ", eventTime=" + this.eventTime + ")";
        }
    }
}

