/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.base.Strings;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.SecurityProtocol;
import com.logicalclocks.hsfs.SslEndpointIdentificationAlgorithm;
import com.logicalclocks.hsfs.StorageConnectorType;
import com.logicalclocks.hsfs.engine.SparkEngine;
import com.logicalclocks.hsfs.metadata.Option;
import com.logicalclocks.hsfs.metadata.StorageConnectorApi;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.NotSupportedException;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="storageConnectorType", visible=true)
@JsonSubTypes(value={@JsonSubTypes.Type(value=HopsFsConnector.class, name="HOPSFS"), @JsonSubTypes.Type(value=S3Connector.class, name="S3"), @JsonSubTypes.Type(value=RedshiftConnector.class, name="REDSHIFT"), @JsonSubTypes.Type(value=AdlsConnector.class, name="ADLS"), @JsonSubTypes.Type(value=SnowflakeConnector.class, name="SNOWFLAKE"), @JsonSubTypes.Type(value=JdbcConnector.class, name="JDBC"), @JsonSubTypes.Type(value=KafkaConnector.class, name="KAFKA"), @JsonSubTypes.Type(value=GcsConnector.class, name="GCS"), @JsonSubTypes.Type(value=BigqueryConnector.class, name="BIGQUERY")})
public abstract class StorageConnector {
    protected StorageConnectorType storageConnectorType;
    private Integer id;
    private String name;
    private String description;
    private Integer featurestoreId;
    protected StorageConnectorApi storageConnectorApi = new StorageConnectorApi();

    public Object read(String query, String dataFormat, Map<String, String> options, String path) throws FeatureStoreException, IOException {
        return SparkEngine.getInstance().read(this, dataFormat, options, path);
    }

    public StorageConnector refetch() throws FeatureStoreException, IOException {
        return this.storageConnectorApi.get(this.getFeaturestoreId(), this.getName());
    }

    @JsonIgnore
    public abstract String getPath(String var1) throws FeatureStoreException;

    public abstract Map<String, String> sparkOptions() throws IOException;

    public StorageConnector(StorageConnectorType storageConnectorType, Integer id, String name, String description, Integer featurestoreId, StorageConnectorApi storageConnectorApi) {
        this.storageConnectorType = storageConnectorType;
        this.id = id;
        this.name = name;
        this.description = description;
        this.featurestoreId = featurestoreId;
        this.storageConnectorApi = storageConnectorApi;
    }

    public StorageConnector() {
    }

    public String toString() {
        return "StorageConnector(storageConnectorType=" + (Object)((Object)this.getStorageConnectorType()) + ", id=" + this.getId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", featurestoreId=" + this.getFeaturestoreId() + ", storageConnectorApi=" + this.storageConnectorApi + ")";
    }

    public StorageConnectorType getStorageConnectorType() {
        return this.storageConnectorType;
    }

    public void setStorageConnectorType(StorageConnectorType storageConnectorType) {
        this.storageConnectorType = storageConnectorType;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Integer getFeaturestoreId() {
        return this.featurestoreId;
    }

    public void setFeaturestoreId(Integer featurestoreId) {
        this.featurestoreId = featurestoreId;
    }

    public static class BigqueryConnector
    extends StorageConnector {
        private String keyPath;
        private String parentProject;
        private String queryProject;
        private String dataset;
        private String queryTable;
        private String materializationDataset;
        private List<Option> arguments;

        @Override
        public Map<String, String> sparkOptions() throws IOException {
            HashMap<String, String> options = new HashMap<String, String>();
            String localKeyPath = SparkEngine.getInstance().addFile(this.keyPath);
            byte[] fileContent = Files.readAllBytes(Paths.get(localKeyPath, new String[0]));
            options.put("credentials", Base64.getEncoder().encodeToString(fileContent));
            options.put("parentProject", this.parentProject);
            if (!Strings.isNullOrEmpty((String)this.materializationDataset)) {
                options.put("materializationDataset", this.materializationDataset);
                options.put("viewsEnabled", "true");
            }
            if (!Strings.isNullOrEmpty((String)this.queryProject)) {
                options.put("project", this.queryProject);
            }
            if (!Strings.isNullOrEmpty((String)this.dataset)) {
                options.put("dataset", this.dataset);
            }
            if (this.arguments != null && !this.arguments.isEmpty()) {
                Map<String, String> argOptions = this.arguments.stream().collect(Collectors.toMap(Option::getName, Option::getValue));
                options.putAll(argOptions);
            }
            return options;
        }

        @Override
        public Object read(String query, String dataFormat, Map<String, String> options, String path) throws FeatureStoreException, IOException {
            Map<String, String> readOptions = this.sparkOptions();
            if (options != null && !options.isEmpty()) {
                readOptions.putAll(options);
            }
            if (!Strings.isNullOrEmpty((String)query)) {
                path = query;
            } else if (!Strings.isNullOrEmpty((String)this.queryTable)) {
                path = this.queryTable;
            } else if (Strings.isNullOrEmpty((String)path)) {
                throw new IllegalArgumentException("Either query should be provided or Query Project,Dataset and Table should be set");
            }
            return SparkEngine.getInstance().read(this, "bigquery", readOptions, path);
        }

        @Override
        @JsonIgnore
        public String getPath(String subPath) {
            return null;
        }

        public String getKeyPath() {
            return this.keyPath;
        }

        public void setKeyPath(String keyPath) {
            this.keyPath = keyPath;
        }

        public String getParentProject() {
            return this.parentProject;
        }

        public void setParentProject(String parentProject) {
            this.parentProject = parentProject;
        }

        public String getQueryProject() {
            return this.queryProject;
        }

        public void setQueryProject(String queryProject) {
            this.queryProject = queryProject;
        }

        public String getDataset() {
            return this.dataset;
        }

        public void setDataset(String dataset) {
            this.dataset = dataset;
        }

        public String getQueryTable() {
            return this.queryTable;
        }

        public void setQueryTable(String queryTable) {
            this.queryTable = queryTable;
        }

        public String getMaterializationDataset() {
            return this.materializationDataset;
        }

        public void setMaterializationDataset(String materializationDataset) {
            this.materializationDataset = materializationDataset;
        }

        public List<Option> getArguments() {
            return this.arguments;
        }

        public void setArguments(List<Option> arguments) {
            this.arguments = arguments;
        }
    }

    public static class GcsConnector
    extends StorageConnector {
        private String keyPath;
        private String algorithm;
        private String encryptionKey;
        private String encryptionKeyHash;
        private String bucket;

        @Override
        @JsonIgnore
        public String getPath(String subPath) {
            return "gs://" + this.bucket + "/" + (Strings.isNullOrEmpty((String)subPath) ? "" : subPath);
        }

        @Override
        public Map<String, String> sparkOptions() {
            return new HashMap<String, String>();
        }

        public void prepareSpark() throws FeatureStoreException, IOException {
            SparkEngine.getInstance().setupConnectorHadoopConf(this);
        }

        public String getKeyPath() {
            return this.keyPath;
        }

        public void setKeyPath(String keyPath) {
            this.keyPath = keyPath;
        }

        public String getAlgorithm() {
            return this.algorithm;
        }

        public void setAlgorithm(String algorithm) {
            this.algorithm = algorithm;
        }

        public String getEncryptionKey() {
            return this.encryptionKey;
        }

        public void setEncryptionKey(String encryptionKey) {
            this.encryptionKey = encryptionKey;
        }

        public String getEncryptionKeyHash() {
            return this.encryptionKeyHash;
        }

        public void setEncryptionKeyHash(String encryptionKeyHash) {
            this.encryptionKeyHash = encryptionKeyHash;
        }

        public String getBucket() {
            return this.bucket;
        }

        public void setBucket(String bucket) {
            this.bucket = bucket;
        }
    }

    public static class KafkaConnector
    extends StorageConnector {
        public static final String sparkFormat = "kafka";
        private String bootstrapServers;
        private SecurityProtocol securityProtocol;
        private String sslTruststoreLocation;
        private String sslTruststorePassword;
        private String sslKeystoreLocation;
        private String sslKeystorePassword;
        private String sslKeyPassword;
        private SslEndpointIdentificationAlgorithm sslEndpointIdentificationAlgorithm;
        private List<Option> options;

        public void setSslTruststoreLocation(String sslTruststoreLocation) {
            this.sslTruststoreLocation = SparkEngine.getInstance().addFile(sslTruststoreLocation);
        }

        public void setSslKeystoreLocation(String sslKeystoreLocation) {
            this.sslKeystoreLocation = SparkEngine.getInstance().addFile(sslKeystoreLocation);
        }

        @Override
        public Map<String, String> sparkOptions() {
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("kafka.bootstrap.servers", this.bootstrapServers);
            options.put("kafka.security.protocol", this.securityProtocol.toString());
            if (!Strings.isNullOrEmpty((String)this.sslTruststoreLocation)) {
                options.put("kafka.ssl.truststore.location", this.sslTruststoreLocation);
            }
            if (!Strings.isNullOrEmpty((String)this.sslTruststorePassword)) {
                options.put("kafka.ssl.truststore.password", this.sslTruststorePassword);
            }
            if (!Strings.isNullOrEmpty((String)this.sslKeystoreLocation)) {
                options.put("kafka.ssl.keystore.location", this.sslKeystoreLocation);
            }
            if (!Strings.isNullOrEmpty((String)this.sslKeystorePassword)) {
                options.put("kafka.ssl.keystore.password", this.sslKeystorePassword);
            }
            if (!Strings.isNullOrEmpty((String)this.sslKeyPassword)) {
                options.put("kafka.ssl.key.password", this.sslKeyPassword);
            }
            if (this.sslEndpointIdentificationAlgorithm != null) {
                options.put("kafka.ssl.endpoint.identification.algorithm", this.sslEndpointIdentificationAlgorithm.getValue());
            }
            if (this.options != null && !this.options.isEmpty()) {
                Map<String, String> argOptions = this.options.stream().collect(Collectors.toMap(Option::getName, Option::getValue));
                options.putAll(argOptions);
            }
            return options;
        }

        @Override
        @JsonIgnore
        public String getPath(String subPath) {
            return null;
        }

        @Override
        public Object read(String query, String dataFormat, Map<String, String> options, String path) {
            throw new NotSupportedException("Reading a Kafka Stream into a static Spark Dataframe is not supported.");
        }

        public Object readStream(String topic, boolean topicPattern, String messageFormat, String schema, Map<String, String> options, boolean includeMetadata) throws FeatureStoreException, IOException {
            if (!Arrays.asList("avro", "json", null).contains(messageFormat.toLowerCase())) {
                throw new IllegalArgumentException("Can only read JSON and AVRO encoded records from Kafka.");
            }
            if (topicPattern) {
                options.put("subscribePattern", topic);
            } else {
                options.put("subscribe", topic);
            }
            return SparkEngine.getInstance().readStream(this, sparkFormat, messageFormat.toLowerCase(), schema, options, includeMetadata);
        }

        public String getBootstrapServers() {
            return this.bootstrapServers;
        }

        public void setBootstrapServers(String bootstrapServers) {
            this.bootstrapServers = bootstrapServers;
        }

        public SecurityProtocol getSecurityProtocol() {
            return this.securityProtocol;
        }

        public void setSecurityProtocol(SecurityProtocol securityProtocol) {
            this.securityProtocol = securityProtocol;
        }

        public String getSslTruststoreLocation() {
            return this.sslTruststoreLocation;
        }

        public String getSslTruststorePassword() {
            return this.sslTruststorePassword;
        }

        public void setSslTruststorePassword(String sslTruststorePassword) {
            this.sslTruststorePassword = sslTruststorePassword;
        }

        public String getSslKeystoreLocation() {
            return this.sslKeystoreLocation;
        }

        public String getSslKeystorePassword() {
            return this.sslKeystorePassword;
        }

        public void setSslKeystorePassword(String sslKeystorePassword) {
            this.sslKeystorePassword = sslKeystorePassword;
        }

        public String getSslKeyPassword() {
            return this.sslKeyPassword;
        }

        public void setSslKeyPassword(String sslKeyPassword) {
            this.sslKeyPassword = sslKeyPassword;
        }

        public SslEndpointIdentificationAlgorithm getSslEndpointIdentificationAlgorithm() {
            return this.sslEndpointIdentificationAlgorithm;
        }

        public void setSslEndpointIdentificationAlgorithm(SslEndpointIdentificationAlgorithm sslEndpointIdentificationAlgorithm) {
            this.sslEndpointIdentificationAlgorithm = sslEndpointIdentificationAlgorithm;
        }

        public List<Option> getOptions() {
            return this.options;
        }

        public void setOptions(List<Option> options) {
            this.options = options;
        }
    }

    public static class JdbcConnector
    extends StorageConnector {
        private String connectionString;
        private List<Option> arguments;

        @Override
        public Map<String, String> sparkOptions() {
            Map<String, String> readOptions = this.arguments.stream().collect(Collectors.toMap(arg -> arg.getName(), arg -> arg.getValue()));
            readOptions.put("url", this.connectionString);
            return readOptions;
        }

        @Override
        public Object read(String query, String dataFormat, Map<String, String> options, String path) throws FeatureStoreException, IOException {
            this.update();
            Map<String, String> readOptions = this.sparkOptions();
            if (!Strings.isNullOrEmpty((String)query)) {
                readOptions.put("query", query);
            }
            return SparkEngine.getInstance().read(this, "jdbc", readOptions, null);
        }

        public void update() throws FeatureStoreException, IOException {
            JdbcConnector updatedConnector = (JdbcConnector)this.refetch();
            this.connectionString = updatedConnector.connectionString;
            this.arguments = updatedConnector.arguments;
        }

        @Override
        @JsonIgnore
        public String getPath(String subPath) {
            return null;
        }

        public String getConnectionString() {
            return this.connectionString;
        }

        public void setConnectionString(String connectionString) {
            this.connectionString = connectionString;
        }

        public List<Option> getArguments() {
            return this.arguments;
        }

        public void setArguments(List<Option> arguments) {
            this.arguments = arguments;
        }
    }

    public static class SnowflakeConnector
    extends StorageConnector {
        private String url;
        private String user;
        private String password;
        private String token;
        private String database;
        private String schema;
        private String warehouse;
        private String role;
        private String table;
        private String application;
        private List<Option> sfOptions;

        public String account() {
            return this.url.replace("https://", "").replace(".snowflakecomputing.com", "");
        }

        @Override
        public Map<String, String> sparkOptions() {
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("sfURL", this.url);
            options.put("sfSchema", this.schema);
            options.put("sfDatabase", this.database);
            options.put("sfUser", this.user);
            if (!Strings.isNullOrEmpty((String)this.password)) {
                options.put("sfPassword", this.password);
            } else {
                options.put("sfAuthenticator", "oauth");
                options.put("sfToken", this.token);
            }
            if (!Strings.isNullOrEmpty((String)this.warehouse)) {
                options.put("sfWarehouse", this.warehouse);
            }
            if (!Strings.isNullOrEmpty((String)this.role)) {
                options.put("sfRole", this.role);
            }
            if (!Strings.isNullOrEmpty((String)this.table)) {
                options.put("dbtable", this.table);
            }
            if (!Strings.isNullOrEmpty((String)this.application)) {
                options.put("application", this.application);
            }
            if (this.sfOptions != null && !this.sfOptions.isEmpty()) {
                Map<String, String> argOptions = this.sfOptions.stream().collect(Collectors.toMap(Option::getName, Option::getValue));
                options.putAll(argOptions);
            }
            return options;
        }

        @Override
        public Object read(String query, String dataFormat, Map<String, String> options, String path) throws FeatureStoreException, IOException {
            Map<String, String> readOptions = this.sparkOptions();
            if (!Strings.isNullOrEmpty((String)query)) {
                readOptions.remove("dbtable");
                readOptions.put("query", query);
            }
            return SparkEngine.getInstance().read(this, "net.snowflake.spark.snowflake", readOptions, null);
        }

        @Override
        @JsonIgnore
        public String getPath(String subPath) {
            return null;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getUser() {
            return this.user;
        }

        public void setUser(String user) {
            this.user = user;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getToken() {
            return this.token;
        }

        public void setToken(String token) {
            this.token = token;
        }

        public String getDatabase() {
            return this.database;
        }

        public void setDatabase(String database) {
            this.database = database;
        }

        public String getSchema() {
            return this.schema;
        }

        public void setSchema(String schema) {
            this.schema = schema;
        }

        public String getWarehouse() {
            return this.warehouse;
        }

        public void setWarehouse(String warehouse) {
            this.warehouse = warehouse;
        }

        public String getRole() {
            return this.role;
        }

        public void setRole(String role) {
            this.role = role;
        }

        public String getTable() {
            return this.table;
        }

        public void setTable(String table) {
            this.table = table;
        }

        public String getApplication() {
            return this.application;
        }

        public void setApplication(String application) {
            this.application = application;
        }

        public List<Option> getSfOptions() {
            return this.sfOptions;
        }

        public void setSfOptions(List<Option> sfOptions) {
            this.sfOptions = sfOptions;
        }
    }

    public static class AdlsConnector
    extends StorageConnector {
        private Integer generation;
        private String directoryId;
        private String applicationId;
        private String serviceCredential;
        private String accountName;
        private String containerName;
        private List<Option> sparkOptions;

        @Override
        @JsonIgnore
        public String getPath(String subPath) {
            return (this.generation == 2 ? "abfss://" + this.containerName + "@" + this.accountName + ".dfs.core.windows.net/" : "adl://" + this.accountName + ".azuredatalakestore.net/") + (Strings.isNullOrEmpty((String)subPath) ? "" : subPath);
        }

        @Override
        public Map<String, String> sparkOptions() {
            HashMap<String, String> options = new HashMap<String, String>();
            this.sparkOptions.stream().forEach(option -> options.put(option.getName(), option.getValue()));
            return options;
        }

        public Integer getGeneration() {
            return this.generation;
        }

        public void setGeneration(Integer generation) {
            this.generation = generation;
        }

        public String getDirectoryId() {
            return this.directoryId;
        }

        public void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        public String getApplicationId() {
            return this.applicationId;
        }

        public void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public String getServiceCredential() {
            return this.serviceCredential;
        }

        public void setServiceCredential(String serviceCredential) {
            this.serviceCredential = serviceCredential;
        }

        public String getAccountName() {
            return this.accountName;
        }

        public void setAccountName(String accountName) {
            this.accountName = accountName;
        }

        public String getContainerName() {
            return this.containerName;
        }

        public void setContainerName(String containerName) {
            this.containerName = containerName;
        }

        public List<Option> getSparkOptions() {
            return this.sparkOptions;
        }

        public void setSparkOptions(List<Option> sparkOptions) {
            this.sparkOptions = sparkOptions;
        }
    }

    public static class RedshiftConnector
    extends StorageConnector {
        private String clusterIdentifier;
        private String databaseDriver;
        private String databaseEndpoint;
        private String databaseName;
        private Integer databasePort;
        private String tableName;
        private String databaseUserName;
        private Boolean autoCreate;
        private String databasePassword;
        private String databaseGroup;
        private String iamRole;
        private List<Option> arguments;
        private Instant expiration;

        @Override
        public Map<String, String> sparkOptions() {
            String constr = "jdbc:redshift://" + this.clusterIdentifier + "." + this.databaseEndpoint + ":" + this.databasePort + "/" + this.databaseName;
            if (this.arguments != null && !this.arguments.isEmpty()) {
                constr = constr + "?" + this.arguments.stream().map(arg -> arg.getName() + (arg.getValue() != null ? "=" + arg.getValue() : "")).collect(Collectors.joining(","));
            }
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("driver", this.databaseDriver);
            options.put("url", constr);
            options.put("user", this.databaseUserName);
            options.put("password", this.databasePassword);
            if (!Strings.isNullOrEmpty((String)this.tableName)) {
                options.put("dbtable", this.tableName);
            }
            return options;
        }

        @Override
        public Object read(String query, String dataFormat, Map<String, String> options, String path) throws FeatureStoreException, IOException {
            this.update();
            Map<String, String> readOptions = this.sparkOptions();
            if (!Strings.isNullOrEmpty((String)query)) {
                readOptions.put("query", query);
            }
            return SparkEngine.getInstance().read(this, "jdbc", readOptions, null);
        }

        @Override
        @JsonIgnore
        public String getPath(String subPath) {
            return null;
        }

        public void update() throws FeatureStoreException, IOException {
            RedshiftConnector updatedConnector = (RedshiftConnector)this.refetch();
            this.databaseUserName = updatedConnector.getDatabaseUserName();
            this.expiration = updatedConnector.getExpiration();
            this.databasePassword = updatedConnector.getDatabasePassword();
        }

        public String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        public void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        public String getDatabaseDriver() {
            return this.databaseDriver;
        }

        public void setDatabaseDriver(String databaseDriver) {
            this.databaseDriver = databaseDriver;
        }

        public String getDatabaseEndpoint() {
            return this.databaseEndpoint;
        }

        public void setDatabaseEndpoint(String databaseEndpoint) {
            this.databaseEndpoint = databaseEndpoint;
        }

        public String getDatabaseName() {
            return this.databaseName;
        }

        public void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        public Integer getDatabasePort() {
            return this.databasePort;
        }

        public void setDatabasePort(Integer databasePort) {
            this.databasePort = databasePort;
        }

        public String getTableName() {
            return this.tableName;
        }

        public void setTableName(String tableName) {
            this.tableName = tableName;
        }

        public String getDatabaseUserName() {
            return this.databaseUserName;
        }

        public void setDatabaseUserName(String databaseUserName) {
            this.databaseUserName = databaseUserName;
        }

        public Boolean getAutoCreate() {
            return this.autoCreate;
        }

        public void setAutoCreate(Boolean autoCreate) {
            this.autoCreate = autoCreate;
        }

        public String getDatabasePassword() {
            return this.databasePassword;
        }

        public void setDatabasePassword(String databasePassword) {
            this.databasePassword = databasePassword;
        }

        public String getDatabaseGroup() {
            return this.databaseGroup;
        }

        public void setDatabaseGroup(String databaseGroup) {
            this.databaseGroup = databaseGroup;
        }

        public String getIamRole() {
            return this.iamRole;
        }

        public void setIamRole(String iamRole) {
            this.iamRole = iamRole;
        }

        public List<Option> getArguments() {
            return this.arguments;
        }

        public void setArguments(List<Option> arguments) {
            this.arguments = arguments;
        }

        public Instant getExpiration() {
            return this.expiration;
        }

        public void setExpiration(Instant expiration) {
            this.expiration = expiration;
        }
    }

    public static class S3Connector
    extends StorageConnector {
        private String accessKey;
        private String secretKey;
        private String serverEncryptionAlgorithm;
        private String serverEncryptionKey;
        private String bucket;
        private String sessionToken;
        private String iamRole;

        @Override
        @JsonIgnore
        public String getPath(String subPath) {
            return "s3://" + this.bucket + "/" + (Strings.isNullOrEmpty((String)subPath) ? "" : subPath);
        }

        @Override
        public Map<String, String> sparkOptions() {
            return new HashMap<String, String>();
        }

        @Override
        public Object read(String query, String dataFormat, Map<String, String> options, String path) throws FeatureStoreException, IOException {
            this.update();
            return SparkEngine.getInstance().read(this, dataFormat, options, path);
        }

        public void update() throws FeatureStoreException, IOException {
            S3Connector updatedConnector = (S3Connector)this.refetch();
            this.accessKey = updatedConnector.getAccessKey();
            this.secretKey = updatedConnector.getSecretKey();
            this.sessionToken = updatedConnector.getSessionToken();
        }

        public String getAccessKey() {
            return this.accessKey;
        }

        public void setAccessKey(String accessKey) {
            this.accessKey = accessKey;
        }

        public String getSecretKey() {
            return this.secretKey;
        }

        public void setSecretKey(String secretKey) {
            this.secretKey = secretKey;
        }

        public String getServerEncryptionAlgorithm() {
            return this.serverEncryptionAlgorithm;
        }

        public void setServerEncryptionAlgorithm(String serverEncryptionAlgorithm) {
            this.serverEncryptionAlgorithm = serverEncryptionAlgorithm;
        }

        public String getServerEncryptionKey() {
            return this.serverEncryptionKey;
        }

        public void setServerEncryptionKey(String serverEncryptionKey) {
            this.serverEncryptionKey = serverEncryptionKey;
        }

        public String getBucket() {
            return this.bucket;
        }

        public void setBucket(String bucket) {
            this.bucket = bucket;
        }

        public String getSessionToken() {
            return this.sessionToken;
        }

        public void setSessionToken(String sessionToken) {
            this.sessionToken = sessionToken;
        }

        public String getIamRole() {
            return this.iamRole;
        }

        public void setIamRole(String iamRole) {
            this.iamRole = iamRole;
        }
    }

    public static class HopsFsConnector
    extends StorageConnector {
        private String hopsfsPath;
        private String datasetName;

        @Override
        public Map<String, String> sparkOptions() {
            return new HashMap<String, String>();
        }

        @Override
        @JsonIgnore
        public String getPath(String subPath) {
            return this.hopsfsPath + "/" + (Strings.isNullOrEmpty((String)subPath) ? "" : subPath);
        }

        public String getHopsfsPath() {
            return this.hopsfsPath;
        }

        public void setHopsfsPath(String hopsfsPath) {
            this.hopsfsPath = hopsfsPath;
        }

        public String getDatasetName() {
            return this.datasetName;
        }

        public void setDatasetName(String datasetName) {
            this.datasetName = datasetName;
        }
    }
}

