/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.logicalclocks.hsfs.DataFormat;
import com.logicalclocks.hsfs.EntityEndpointType;
import com.logicalclocks.hsfs.FeatureStore;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.Split;
import com.logicalclocks.hsfs.StatisticsConfig;
import com.logicalclocks.hsfs.Storage;
import com.logicalclocks.hsfs.StorageConnector;
import com.logicalclocks.hsfs.TrainingDatasetFeature;
import com.logicalclocks.hsfs.TrainingDatasetType;
import com.logicalclocks.hsfs.constructor.Filter;
import com.logicalclocks.hsfs.constructor.FilterLogic;
import com.logicalclocks.hsfs.constructor.Query;
import com.logicalclocks.hsfs.engine.CodeEngine;
import com.logicalclocks.hsfs.engine.FeatureGroupUtils;
import com.logicalclocks.hsfs.engine.StatisticsEngine;
import com.logicalclocks.hsfs.engine.TrainingDatasetEngine;
import com.logicalclocks.hsfs.engine.TrainingDatasetUtils;
import com.logicalclocks.hsfs.engine.VectorServer;
import com.logicalclocks.hsfs.metadata.Statistics;
import java.io.IOException;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrainingDataset {
    private Integer id;
    private String name;
    private Integer version;
    private String description;
    private DataFormat dataFormat;
    private Boolean coalesce;
    private TrainingDatasetType trainingDatasetType = TrainingDatasetType.HOPSFS_TRAINING_DATASET;
    private List<TrainingDatasetFeature> features;
    @JsonIgnore
    private FeatureStore featureStore;
    private StorageConnector storageConnector;
    private String location;
    private Long seed;
    private List<Split> splits;
    private String trainSplit;
    private StatisticsConfig statisticsConfig = new StatisticsConfig();
    @JsonProperty(value="queryDTO")
    private Query queryInt;
    @JsonIgnore
    private List<String> label;
    private Date eventStartTime;
    private Date eventEndTime;
    private FilterLogic extraFilter;
    private String type = "trainingDatasetDTO";
    private TrainingDatasetEngine trainingDatasetEngine = new TrainingDatasetEngine();
    private StatisticsEngine statisticsEngine = new StatisticsEngine(EntityEndpointType.TRAINING_DATASET);
    private CodeEngine codeEngine = new CodeEngine(EntityEndpointType.TRAINING_DATASET);
    private TrainingDatasetUtils utils = new TrainingDatasetUtils();
    private VectorServer vectorServer = new VectorServer();
    private static final Logger LOGGER = LoggerFactory.getLogger(TrainingDataset.class);

    public TrainingDataset(@NonNull String name, Integer version, String description, DataFormat dataFormat, Boolean coalesce, StorageConnector storageConnector, String location, List<Split> splits, String trainSplit, Long seed, FeatureStore featureStore, StatisticsConfig statisticsConfig, List<String> label, String eventStartTime, String eventEndTime, TrainingDatasetType trainingDatasetType, Float validationSize, Float testSize, String trainStart, String trainEnd, String validationStart, String validationEnd, String testStart, String testEnd, Integer timeSplitSize, FilterLogic extraFilterLogic, Filter extraFilter) throws FeatureStoreException, ParseException {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
        this.version = version;
        this.description = description;
        this.dataFormat = dataFormat != null ? dataFormat : DataFormat.PARQUET;
        this.coalesce = coalesce != null ? coalesce : false;
        this.location = location;
        this.storageConnector = storageConnector;
        this.trainSplit = trainSplit;
        this.splits = splits == null ? Lists.newArrayList() : splits;
        this.seed = seed;
        this.featureStore = featureStore;
        this.statisticsConfig = statisticsConfig != null ? statisticsConfig : new StatisticsConfig();
        this.label = label != null ? label.stream().map(String::toLowerCase).collect(Collectors.toList()) : null;
        this.eventStartTime = eventStartTime != null ? FeatureGroupUtils.getDateFromDateString(eventStartTime) : null;
        this.eventEndTime = eventEndTime != null ? FeatureGroupUtils.getDateFromDateString(eventEndTime) : null;
        this.trainingDatasetType = trainingDatasetType != null ? trainingDatasetType : this.utils.getTrainingDatasetType(storageConnector);
        this.setValTestSplit(validationSize, testSize);
        this.setTimeSeriesSplits(timeSplitSize, trainStart, trainEnd, validationStart, validationEnd, testStart, testEnd);
        if (extraFilter != null) {
            this.extraFilter = new FilterLogic(extraFilter);
        }
        if (extraFilterLogic != null) {
            this.extraFilter = extraFilterLogic;
        }
    }

    private void setTimeSeriesSplits(Integer timeSplitSize, String trainStart, String trainEnd, String valStart, String valEnd, String testStart, String testEnd) throws FeatureStoreException, ParseException {
        ArrayList splits = Lists.newArrayList();
        this.appendTimeSeriesSplit(splits, "train", trainStart, trainEnd != null ? trainEnd : (valStart != null ? valStart : testStart));
        if (timeSplitSize != null && timeSplitSize == 3) {
            this.appendTimeSeriesSplit(splits, "validataion", valStart != null ? valStart : trainEnd, valEnd != null ? valEnd : testStart);
        }
        this.appendTimeSeriesSplit(splits, "test", testStart != null ? testStart : (valEnd != null ? valEnd : trainEnd), testEnd);
        if (!splits.isEmpty()) {
            this.splits = splits;
        }
    }

    private void appendTimeSeriesSplit(List<Split> splits, String splitName, String startTime, String endTime) throws FeatureStoreException, ParseException {
        if (startTime != null || endTime != null) {
            splits.add(new Split(splitName, FeatureGroupUtils.getDateFromDateString(startTime), FeatureGroupUtils.getDateFromDateString(endTime)));
        }
    }

    private void setValTestSplit(Float valSize, Float testSize) {
        if (valSize != null && testSize != null) {
            this.splits = Lists.newArrayList();
            this.splits.add(new Split("train", Float.valueOf(1.0f - valSize.floatValue() - testSize.floatValue())));
            this.splits.add(new Split("validataion", valSize));
            this.splits.add(new Split("test", testSize));
        } else if (testSize != null) {
            this.splits = Lists.newArrayList();
            this.splits.add(new Split("train", Float.valueOf(1.0f - testSize.floatValue())));
            this.splits.add(new Split("test", testSize));
        }
    }

    public void save(Query query) throws FeatureStoreException, IOException {
        this.save(query, null);
    }

    public void save(Query query, Map<String, String> writeOptions) throws FeatureStoreException, IOException {
        this.queryInt = query;
        TrainingDataset trainingDataset = this.trainingDatasetEngine.save(this, query, writeOptions, this.label);
        this.setStorageConnector(trainingDataset.getStorageConnector());
        this.codeEngine.saveCode(this);
        this.computeStatistics();
    }

    public Dataset<Row> read() throws FeatureStoreException, IOException {
        return this.read("");
    }

    public Dataset<Row> read(Map<String, String> readOptions) throws FeatureStoreException, IOException {
        return this.read("", readOptions);
    }

    public Dataset<Row> read(String split) throws FeatureStoreException, IOException {
        return this.read(split, null);
    }

    public Dataset<Row> read(String split, Map<String, String> readOptions) throws FeatureStoreException, IOException {
        if (this.splits != null && !this.splits.isEmpty() && Strings.isNullOrEmpty((String)split)) {
            throw new FeatureStoreException("The training dataset has splits, please specify the split you want to read");
        }
        return this.trainingDatasetEngine.read(this, split, readOptions);
    }

    public void show(int numRows) throws FeatureStoreException, IOException {
        this.read("").show(numRows);
    }

    public Statistics computeStatistics() throws FeatureStoreException, IOException {
        if (this.statisticsConfig.getEnabled().booleanValue()) {
            if (this.splits != null && !this.splits.isEmpty()) {
                return this.statisticsEngine.registerSplitStatistics(this);
            }
            return this.statisticsEngine.computeStatistics(this, this.read());
        }
        return null;
    }

    public void updateStatisticsConfig() throws FeatureStoreException, IOException {
        this.trainingDatasetEngine.updateStatisticsConfig(this);
    }

    @JsonIgnore
    public Statistics getStatistics() throws FeatureStoreException, IOException {
        return this.statisticsEngine.getLast(this);
    }

    @JsonIgnore
    public Statistics getStatistics(String commitTime) throws FeatureStoreException, IOException {
        return this.statisticsEngine.get(this, commitTime);
    }

    public void addTag(String name, Object value) throws FeatureStoreException, IOException {
        this.trainingDatasetEngine.addTag(this, name, value);
    }

    @JsonIgnore
    public Map<String, Object> getTags() throws FeatureStoreException, IOException {
        return this.trainingDatasetEngine.getTags(this);
    }

    @JsonIgnore
    public Object getTag(String name) throws FeatureStoreException, IOException {
        return this.trainingDatasetEngine.getTag(this, name);
    }

    public void deleteTag(String name) throws FeatureStoreException, IOException {
        this.trainingDatasetEngine.deleteTag(this, name);
    }

    @JsonIgnore
    public String getQuery() throws FeatureStoreException, IOException {
        return this.getQuery(Storage.ONLINE, false);
    }

    @JsonIgnore
    public String getQuery(boolean withLabel) throws FeatureStoreException, IOException {
        return this.getQuery(Storage.ONLINE, withLabel);
    }

    @JsonIgnore
    public String getQuery(Storage storage) throws FeatureStoreException, IOException {
        return this.getQuery(storage, false);
    }

    @JsonIgnore
    public String getQuery(Storage storage, boolean withLabel) throws FeatureStoreException, IOException {
        return this.trainingDatasetEngine.getQuery(this, storage, withLabel, false);
    }

    @JsonIgnore
    public List<String> getLabel() {
        return this.features.stream().filter(TrainingDatasetFeature::getLabel).map(TrainingDatasetFeature::getName).collect(Collectors.toList());
    }

    @JsonIgnore
    public void setLabel(List<String> label) {
        this.label = label.stream().map(String::toLowerCase).collect(Collectors.toList());
    }

    public void initPreparedStatement() throws SQLException, IOException, FeatureStoreException, ClassNotFoundException {
        this.initPreparedStatement(false);
    }

    public void initPreparedStatement(boolean external) throws SQLException, IOException, FeatureStoreException, ClassNotFoundException {
        this.vectorServer.initPreparedStatement(this, false, external);
    }

    public void initPreparedStatement(boolean external, boolean batch) throws SQLException, IOException, FeatureStoreException, ClassNotFoundException {
        this.vectorServer.initPreparedStatement(this, batch, external);
    }

    @JsonIgnore
    public List<Object> getServingVector(Map<String, Object> entry) throws SQLException, FeatureStoreException, IOException, ClassNotFoundException {
        return this.vectorServer.getFeatureVector(this, entry);
    }

    @JsonIgnore
    public List<Object> getServingVector(Map<String, Object> entry, boolean external) throws SQLException, FeatureStoreException, IOException, ClassNotFoundException {
        return this.vectorServer.getFeatureVector(this, entry, external);
    }

    @JsonIgnore
    public List<List<Object>> getServingVectors(Map<String, List<Object>> entry) throws SQLException, FeatureStoreException, IOException, ClassNotFoundException {
        return this.vectorServer.getFeatureVectors(this, entry);
    }

    @JsonIgnore
    public List<List<Object>> getServingVectors(Map<String, List<Object>> entry, boolean external) throws SQLException, FeatureStoreException, IOException, ClassNotFoundException {
        return this.vectorServer.getFeatureVectors(this, entry, external);
    }

    public void delete() throws FeatureStoreException, IOException {
        LOGGER.warn("JobWarning: All jobs associated to training dataset `" + this.name + "`, version `" + this.version + "` will be removed.");
        this.trainingDatasetEngine.delete(this);
    }

    @JsonIgnore
    public HashSet<String> getServingKeys() throws SQLException, IOException, FeatureStoreException, ClassNotFoundException {
        if (this.vectorServer.getServingKeys().isEmpty()) {
            this.initPreparedStatement();
        }
        return this.vectorServer.getServingKeys();
    }

    public static TrainingDatasetBuilder builder() {
        return new TrainingDatasetBuilder();
    }

    public TrainingDataset() {
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public DataFormat getDataFormat() {
        return this.dataFormat;
    }

    public void setDataFormat(DataFormat dataFormat) {
        this.dataFormat = dataFormat;
    }

    public Boolean getCoalesce() {
        return this.coalesce;
    }

    public void setCoalesce(Boolean coalesce) {
        this.coalesce = coalesce;
    }

    public TrainingDatasetType getTrainingDatasetType() {
        return this.trainingDatasetType;
    }

    public void setTrainingDatasetType(TrainingDatasetType trainingDatasetType) {
        this.trainingDatasetType = trainingDatasetType;
    }

    public List<TrainingDatasetFeature> getFeatures() {
        return this.features;
    }

    public void setFeatures(List<TrainingDatasetFeature> features) {
        this.features = features;
    }

    public FeatureStore getFeatureStore() {
        return this.featureStore;
    }

    public void setFeatureStore(FeatureStore featureStore) {
        this.featureStore = featureStore;
    }

    public StorageConnector getStorageConnector() {
        return this.storageConnector;
    }

    public void setStorageConnector(StorageConnector storageConnector) {
        this.storageConnector = storageConnector;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public Long getSeed() {
        return this.seed;
    }

    public void setSeed(Long seed) {
        this.seed = seed;
    }

    public List<Split> getSplits() {
        return this.splits;
    }

    public void setSplits(List<Split> splits) {
        this.splits = splits;
    }

    public String getTrainSplit() {
        return this.trainSplit;
    }

    public void setTrainSplit(String trainSplit) {
        this.trainSplit = trainSplit;
    }

    public StatisticsConfig getStatisticsConfig() {
        return this.statisticsConfig;
    }

    public void setStatisticsConfig(StatisticsConfig statisticsConfig) {
        this.statisticsConfig = statisticsConfig;
    }

    public Query getQueryInt() {
        return this.queryInt;
    }

    @JsonProperty(value="queryDTO")
    public void setQueryInt(Query queryInt) {
        this.queryInt = queryInt;
    }

    public Date getEventStartTime() {
        return this.eventStartTime;
    }

    public void setEventStartTime(Date eventStartTime) {
        this.eventStartTime = eventStartTime;
    }

    public Date getEventEndTime() {
        return this.eventEndTime;
    }

    public void setEventEndTime(Date eventEndTime) {
        this.eventEndTime = eventEndTime;
    }

    public FilterLogic getExtraFilter() {
        return this.extraFilter;
    }

    public void setExtraFilter(FilterLogic extraFilter) {
        this.extraFilter = extraFilter;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public static class TrainingDatasetBuilder {
        private String name;
        private Integer version;
        private String description;
        private DataFormat dataFormat;
        private Boolean coalesce;
        private StorageConnector storageConnector;
        private String location;
        private List<Split> splits;
        private String trainSplit;
        private Long seed;
        private FeatureStore featureStore;
        private StatisticsConfig statisticsConfig;
        private List<String> label;
        private String eventStartTime;
        private String eventEndTime;
        private TrainingDatasetType trainingDatasetType;
        private Float validationSize;
        private Float testSize;
        private String trainStart;
        private String trainEnd;
        private String validationStart;
        private String validationEnd;
        private String testStart;
        private String testEnd;
        private Integer timeSplitSize;
        private FilterLogic extraFilterLogic;
        private Filter extraFilter;

        TrainingDatasetBuilder() {
        }

        public TrainingDatasetBuilder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        public TrainingDatasetBuilder version(Integer version) {
            this.version = version;
            return this;
        }

        public TrainingDatasetBuilder description(String description) {
            this.description = description;
            return this;
        }

        public TrainingDatasetBuilder dataFormat(DataFormat dataFormat) {
            this.dataFormat = dataFormat;
            return this;
        }

        public TrainingDatasetBuilder coalesce(Boolean coalesce) {
            this.coalesce = coalesce;
            return this;
        }

        public TrainingDatasetBuilder storageConnector(StorageConnector storageConnector) {
            this.storageConnector = storageConnector;
            return this;
        }

        public TrainingDatasetBuilder location(String location) {
            this.location = location;
            return this;
        }

        public TrainingDatasetBuilder splits(List<Split> splits) {
            this.splits = splits;
            return this;
        }

        public TrainingDatasetBuilder trainSplit(String trainSplit) {
            this.trainSplit = trainSplit;
            return this;
        }

        public TrainingDatasetBuilder seed(Long seed) {
            this.seed = seed;
            return this;
        }

        public TrainingDatasetBuilder featureStore(FeatureStore featureStore) {
            this.featureStore = featureStore;
            return this;
        }

        public TrainingDatasetBuilder statisticsConfig(StatisticsConfig statisticsConfig) {
            this.statisticsConfig = statisticsConfig;
            return this;
        }

        public TrainingDatasetBuilder label(List<String> label) {
            this.label = label;
            return this;
        }

        public TrainingDatasetBuilder eventStartTime(String eventStartTime) {
            this.eventStartTime = eventStartTime;
            return this;
        }

        public TrainingDatasetBuilder eventEndTime(String eventEndTime) {
            this.eventEndTime = eventEndTime;
            return this;
        }

        public TrainingDatasetBuilder trainingDatasetType(TrainingDatasetType trainingDatasetType) {
            this.trainingDatasetType = trainingDatasetType;
            return this;
        }

        public TrainingDatasetBuilder validationSize(Float validationSize) {
            this.validationSize = validationSize;
            return this;
        }

        public TrainingDatasetBuilder testSize(Float testSize) {
            this.testSize = testSize;
            return this;
        }

        public TrainingDatasetBuilder trainStart(String trainStart) {
            this.trainStart = trainStart;
            return this;
        }

        public TrainingDatasetBuilder trainEnd(String trainEnd) {
            this.trainEnd = trainEnd;
            return this;
        }

        public TrainingDatasetBuilder validationStart(String validationStart) {
            this.validationStart = validationStart;
            return this;
        }

        public TrainingDatasetBuilder validationEnd(String validationEnd) {
            this.validationEnd = validationEnd;
            return this;
        }

        public TrainingDatasetBuilder testStart(String testStart) {
            this.testStart = testStart;
            return this;
        }

        public TrainingDatasetBuilder testEnd(String testEnd) {
            this.testEnd = testEnd;
            return this;
        }

        public TrainingDatasetBuilder timeSplitSize(Integer timeSplitSize) {
            this.timeSplitSize = timeSplitSize;
            return this;
        }

        public TrainingDatasetBuilder extraFilterLogic(FilterLogic extraFilterLogic) {
            this.extraFilterLogic = extraFilterLogic;
            return this;
        }

        public TrainingDatasetBuilder extraFilter(Filter extraFilter) {
            this.extraFilter = extraFilter;
            return this;
        }

        public TrainingDataset build() throws FeatureStoreException, ParseException {
            return new TrainingDataset(this.name, this.version, this.description, this.dataFormat, this.coalesce, this.storageConnector, this.location, this.splits, this.trainSplit, this.seed, this.featureStore, this.statisticsConfig, this.label, this.eventStartTime, this.eventEndTime, this.trainingDatasetType, this.validationSize, this.testSize, this.trainStart, this.trainEnd, this.validationStart, this.validationEnd, this.testStart, this.testEnd, this.timeSplitSize, this.extraFilterLogic, this.extraFilter);
        }

        public String toString() {
            return "TrainingDataset.TrainingDatasetBuilder(name=" + this.name + ", version=" + this.version + ", description=" + this.description + ", dataFormat=" + (Object)((Object)this.dataFormat) + ", coalesce=" + this.coalesce + ", storageConnector=" + this.storageConnector + ", location=" + this.location + ", splits=" + this.splits + ", trainSplit=" + this.trainSplit + ", seed=" + this.seed + ", featureStore=" + this.featureStore + ", statisticsConfig=" + this.statisticsConfig + ", label=" + this.label + ", eventStartTime=" + this.eventStartTime + ", eventEndTime=" + this.eventEndTime + ", trainingDatasetType=" + (Object)((Object)this.trainingDatasetType) + ", validationSize=" + this.validationSize + ", testSize=" + this.testSize + ", trainStart=" + this.trainStart + ", trainEnd=" + this.trainEnd + ", validationStart=" + this.validationStart + ", validationEnd=" + this.validationEnd + ", testStart=" + this.testStart + ", testEnd=" + this.testEnd + ", timeSplitSize=" + this.timeSplitSize + ", extraFilterLogic=" + this.extraFilterLogic + ", extraFilter=" + this.extraFilter + ")";
        }
    }
}

