/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.engine;

import com.logicalclocks.hsfs.Feature;
import com.logicalclocks.hsfs.FeatureGroup;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.HudiOperationType;
import com.logicalclocks.hsfs.Storage;
import com.logicalclocks.hsfs.TimeTravelFormat;
import com.logicalclocks.hsfs.engine.FeatureGroupUtils;
import com.logicalclocks.hsfs.engine.SparkEngine;
import com.logicalclocks.hsfs.engine.hudi.HudiEngine;
import com.logicalclocks.hsfs.metadata.FeatureGroupApi;
import com.logicalclocks.hsfs.metadata.KafkaApi;
import java.io.IOException;
import java.text.ParseException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.streaming.StreamingQuery;
import org.apache.spark.sql.streaming.StreamingQueryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureGroupEngine {
    private FeatureGroupApi featureGroupApi = new FeatureGroupApi();
    private HudiEngine hudiEngine = new HudiEngine();
    protected KafkaApi kafkaApi = new KafkaApi();
    private FeatureGroupUtils utils = new FeatureGroupUtils();
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureGroupEngine.class);

    public FeatureGroup save(FeatureGroup featureGroup, Dataset<Row> dataset, List<String> partitionKeys, String hudiPrecombineKey, Map<String, String> writeOptions) throws FeatureStoreException, IOException, ParseException {
        this.insert(featureGroup, dataset, null, (featureGroup = this.saveFeatureGroupMetaData(featureGroup, partitionKeys, hudiPrecombineKey, dataset = this.utils.convertToDefaultDataframe(dataset), false)).getTimeTravelFormat() == TimeTravelFormat.HUDI ? HudiOperationType.BULK_INSERT : null, SaveMode.Append, partitionKeys, hudiPrecombineKey, writeOptions);
        return featureGroup;
    }

    public void insert(FeatureGroup featureGroup, Dataset<Row> featureData, Storage storage, HudiOperationType operation, SaveMode saveMode, List<String> partitionKeys, String hudiPrecombineKey, Map<String, String> writeOptions) throws FeatureStoreException, IOException, ParseException {
        Integer validationId = null;
        if (featureGroup.getId() == null) {
            featureGroup = this.saveFeatureGroupMetaData(featureGroup, partitionKeys, hudiPrecombineKey, featureData, false);
        }
        if (saveMode == SaveMode.Overwrite) {
            this.featureGroupApi.deleteContent(featureGroup);
        }
        this.saveDataframe(featureGroup, this.utils.convertToDefaultDataframe(featureData), storage, operation, writeOptions, this.utils.getKafkaConfig(featureGroup, writeOptions), validationId);
    }

    @Deprecated
    public StreamingQuery insertStream(FeatureGroup featureGroup, Dataset<Row> featureData, String queryName, String outputMode, boolean awaitTermination, Long timeout, String checkpointLocation, List<String> partitionKeys, String hudiPrecombineKey, Map<String, String> writeOptions) throws FeatureStoreException, IOException, StreamingQueryException, TimeoutException, ParseException {
        if (!featureGroup.getOnlineEnabled().booleanValue()) {
            throw new FeatureStoreException("Online storage is not enabled for this feature group. It is currently only possible to stream to the online storage.");
        }
        if (featureGroup.getId() == null) {
            featureGroup = this.saveFeatureGroupMetaData(featureGroup, partitionKeys, hudiPrecombineKey, featureData, true);
        }
        StreamingQuery streamingQuery = SparkEngine.getInstance().writeStreamDataframe(featureGroup, this.utils.convertToDefaultDataframe(featureData), queryName, outputMode, awaitTermination, timeout, checkpointLocation, this.utils.getKafkaConfig(featureGroup, writeOptions));
        return streamingQuery;
    }

    public void saveDataframe(FeatureGroup featureGroup, Dataset<Row> dataset, Storage storage, HudiOperationType operation, Map<String, String> offlineWriteOptions, Map<String, String> onlineWriteOptions, Integer validationId) throws IOException, FeatureStoreException, ParseException {
        if (!featureGroup.getOnlineEnabled().booleanValue() && storage == Storage.ONLINE) {
            throw new FeatureStoreException("Online storage is not enabled for this feature group. Set `online=false` to write to the offline storage.");
        }
        if (storage == Storage.OFFLINE || !featureGroup.getOnlineEnabled().booleanValue()) {
            SparkEngine.getInstance().writeOfflineDataframe(featureGroup, dataset, operation, offlineWriteOptions, validationId);
        } else if (storage == Storage.ONLINE) {
            SparkEngine.getInstance().writeOnlineDataframe(featureGroup, dataset, featureGroup.getOnlineTopicName(), onlineWriteOptions);
        } else if (featureGroup.getOnlineEnabled().booleanValue() && storage == null) {
            SparkEngine.getInstance().writeOfflineDataframe(featureGroup, dataset, operation, offlineWriteOptions, validationId);
            SparkEngine.getInstance().writeOnlineDataframe(featureGroup, dataset, featureGroup.getOnlineTopicName(), onlineWriteOptions);
        } else {
            throw new FeatureStoreException("Error writing to offline and online feature store.");
        }
    }

    public FeatureGroup saveFeatureGroupMetaData(FeatureGroup featureGroup, List<String> partitionKeys, String hudiPrecombineKey, Dataset<Row> featureData, boolean saveEmpty) throws FeatureStoreException, IOException, ParseException {
        if (featureGroup.getFeatures() == null) {
            featureGroup.setFeatures(this.utils.parseFeatureGroupSchema(featureData, featureGroup.getTimeTravelFormat()));
        }
        LOGGER.info("Featuregroup features: " + featureGroup.getFeatures());
        this.utils.verifyAttributeKeyNames(featureGroup, partitionKeys, hudiPrecombineKey);
        if (featureGroup.getPrimaryKeys() != null) {
            featureGroup.getPrimaryKeys().forEach(pk -> featureGroup.getFeatures().forEach(f -> {
                if (f.getName().equals(pk)) {
                    f.setPrimary(true);
                }
            }));
        }
        if (partitionKeys != null) {
            partitionKeys.forEach(pk -> featureGroup.getFeatures().forEach(f -> {
                if (f.getName().equals(pk)) {
                    f.setPartition(true);
                }
            }));
        }
        if (hudiPrecombineKey != null) {
            featureGroup.getFeatures().forEach(f -> {
                if (f.getName().equals(hudiPrecombineKey)) {
                    f.setHudiPrecombineKey(true);
                }
            });
        }
        FeatureGroup apiFG = this.featureGroupApi.save(featureGroup);
        if (featureGroup.getVersion() == null) {
            LOGGER.info("VersionWarning: No version provided for creating feature group `" + featureGroup.getName() + "`, incremented version to `" + apiFG.getVersion() + "`.");
        }
        featureGroup.setId(apiFG.getId());
        featureGroup.setVersion(apiFG.getVersion());
        featureGroup.setLocation(apiFG.getLocation());
        featureGroup.setId(apiFG.getId());
        featureGroup.setStatisticsConfig(apiFG.getStatisticsConfig());
        featureGroup.setOnlineTopicName(apiFG.getOnlineTopicName());
        if (featureGroup.getTimeTravelFormat() == TimeTravelFormat.HUDI & hudiPrecombineKey == null) {
            List<Feature> features = apiFG.getFeatures();
            featureGroup.setFeatures(features);
        }
        if (saveEmpty) {
            SparkEngine.getInstance().writeOfflineDataframe(featureGroup, SparkEngine.getInstance().createEmptyDataFrame(featureData), featureGroup.getTimeTravelFormat() == TimeTravelFormat.HUDI ? HudiOperationType.BULK_INSERT : null, null, null);
        }
        return featureGroup;
    }
}

