/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.logicalclocks.hsfs.ExternalFeatureGroup;
import com.logicalclocks.hsfs.FeatureGroup;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.FeatureView;
import com.logicalclocks.hsfs.StatisticsConfig;
import com.logicalclocks.hsfs.StorageConnector;
import com.logicalclocks.hsfs.StreamFeatureGroup;
import com.logicalclocks.hsfs.TimeTravelFormat;
import com.logicalclocks.hsfs.TrainingDataset;
import com.logicalclocks.hsfs.constructor.Query;
import com.logicalclocks.hsfs.engine.FeatureViewEngine;
import com.logicalclocks.hsfs.engine.SparkEngine;
import com.logicalclocks.hsfs.metadata.FeatureGroupApi;
import com.logicalclocks.hsfs.metadata.StorageConnectorApi;
import com.logicalclocks.hsfs.metadata.TrainingDatasetApi;
import java.io.IOException;
import java.util.List;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.JavaConverters;
import scala.collection.Seq;
import scala.collection.mutable.Buffer;

public class FeatureStore {
    @JsonProperty(value="featurestoreId")
    private Integer id;
    @JsonProperty(value="featurestoreName")
    private String name;
    private Integer projectId;
    private FeatureGroupApi featureGroupApi = new FeatureGroupApi();
    private TrainingDatasetApi trainingDatasetApi = new TrainingDatasetApi();
    private StorageConnectorApi storageConnectorApi = new StorageConnectorApi();
    private FeatureViewEngine featureViewEngine = new FeatureViewEngine();
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureStore.class);
    private static final Integer DEFAULT_VERSION = 1;

    public FeatureGroup getFeatureGroup(@NonNull String name, @NonNull Integer version) throws FeatureStoreException, IOException {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        return this.featureGroupApi.getFeatureGroup(this, name, version);
    }

    public FeatureGroup getFeatureGroup(String name) throws FeatureStoreException, IOException {
        LOGGER.info("VersionWarning: No version provided for getting feature group `" + name + "`, defaulting to `" + DEFAULT_VERSION + "`.");
        return this.getFeatureGroup(name, DEFAULT_VERSION);
    }

    public Seq<FeatureGroup> getFeatureGroups(@NonNull String name) throws FeatureStoreException, IOException {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return ((Buffer)JavaConverters.asScalaBufferConverter(this.featureGroupApi.getFeatureGroups(this, name)).asScala()).toSeq();
    }

    public StreamFeatureGroup getStreamFeatureGroup(@NonNull String name, @NonNull Integer version) throws FeatureStoreException, IOException {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        return this.featureGroupApi.getStreamFeatureGroup(this, name, version);
    }

    public StreamFeatureGroup getStreamFeatureGroup(String name) throws FeatureStoreException, IOException {
        LOGGER.info("VersionWarning: No version provided for getting feature group `" + name + "`, defaulting to `" + DEFAULT_VERSION + "`.");
        return this.getStreamFeatureGroup(name, DEFAULT_VERSION);
    }

    public ExternalFeatureGroup getExternalFeatureGroup(@NonNull String name, @NonNull Integer version) throws FeatureStoreException, IOException {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        return this.featureGroupApi.getExternalFeatureGroup(this, name, version);
    }

    public ExternalFeatureGroup getExternalFeatureGroup(String name) throws FeatureStoreException, IOException {
        LOGGER.info("VersionWarning: No version provided for getting feature group `" + name + "`, defaulting to `" + DEFAULT_VERSION + "`.");
        return this.getExternalFeatureGroup(name, DEFAULT_VERSION);
    }

    public Seq<ExternalFeatureGroup> getExternalFeatureGroups(@NonNull String name) throws FeatureStoreException, IOException {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return ((Buffer)JavaConverters.asScalaBufferConverter(this.featureGroupApi.getExternalFeatureGroups(this, name)).asScala()).toSeq();
    }

    @Deprecated
    public ExternalFeatureGroup getOnDemandFeatureGroup(@NonNull String name, @NonNull Integer version) throws FeatureStoreException, IOException {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        return this.featureGroupApi.getExternalFeatureGroup(this, name, version);
    }

    @Deprecated
    public ExternalFeatureGroup getOnDemandFeatureGroup(String name) throws FeatureStoreException, IOException {
        LOGGER.info("VersionWarning: No version provided for getting feature group `" + name + "`, defaulting to `" + DEFAULT_VERSION + "`.");
        return this.getExternalFeatureGroup(name, DEFAULT_VERSION);
    }

    @Deprecated
    public Seq<ExternalFeatureGroup> getOnDemandFeatureGroups(@NonNull String name) throws FeatureStoreException, IOException {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return ((Buffer)JavaConverters.asScalaBufferConverter(this.featureGroupApi.getExternalFeatureGroups(this, name)).asScala()).toSeq();
    }

    public Object sql(String query) {
        return SparkEngine.getInstance().sql(query);
    }

    public StorageConnector getStorageConnector(String name) throws FeatureStoreException, IOException {
        return this.storageConnectorApi.getByName(this, name);
    }

    public StorageConnector.JdbcConnector getJdbcConnector(String name) throws FeatureStoreException, IOException {
        return (StorageConnector.JdbcConnector)this.storageConnectorApi.getByName(this, name);
    }

    public StorageConnector.S3Connector getS3Connector(String name) throws FeatureStoreException, IOException {
        return (StorageConnector.S3Connector)this.storageConnectorApi.getByName(this, name);
    }

    public StorageConnector.HopsFsConnector getHopsFsConnector(String name) throws FeatureStoreException, IOException {
        return (StorageConnector.HopsFsConnector)this.storageConnectorApi.getByName(this, name);
    }

    public StorageConnector.RedshiftConnector getRedshiftConnector(String name) throws FeatureStoreException, IOException {
        return (StorageConnector.RedshiftConnector)this.storageConnectorApi.getByName(this, name);
    }

    public StorageConnector.SnowflakeConnector getSnowflakeConnector(String name) throws FeatureStoreException, IOException {
        return (StorageConnector.SnowflakeConnector)this.storageConnectorApi.getByName(this, name);
    }

    public StorageConnector.AdlsConnector getAdlsConnector(String name) throws FeatureStoreException, IOException {
        return (StorageConnector.AdlsConnector)this.storageConnectorApi.getByName(this, name);
    }

    public StorageConnector.KafkaConnector getKafkaConnector(String name) throws FeatureStoreException, IOException {
        return (StorageConnector.KafkaConnector)this.storageConnectorApi.getByName(this, name);
    }

    public StorageConnector.BigqueryConnector getBigqueryConnector(String name) throws FeatureStoreException, IOException {
        return (StorageConnector.BigqueryConnector)this.storageConnectorApi.getByName(this, name);
    }

    public StorageConnector.JdbcConnector getOnlineStorageConnector() throws FeatureStoreException, IOException {
        return this.storageConnectorApi.getOnlineStorageConnector(this);
    }

    public StorageConnector.GcsConnector getGcsConnector(String name) throws FeatureStoreException, IOException {
        return (StorageConnector.GcsConnector)this.storageConnectorApi.getByName(this, name);
    }

    public FeatureGroup.FeatureGroupBuilder createFeatureGroup() {
        return FeatureGroup.builder().featureStore(this);
    }

    public FeatureGroup getOrCreateFeatureGroup(String name, Integer version) throws IOException, FeatureStoreException {
        return this.featureGroupApi.getOrCreateFeatureGroup(this, name, version, null, null, null, null, false, null, null, null);
    }

    public FeatureGroup getOrCreateFeatureGroup(String name, Integer version, List<String> primaryKeys, boolean onlineEnabled, String eventTime) throws IOException, FeatureStoreException {
        return this.featureGroupApi.getOrCreateFeatureGroup(this, name, version, null, primaryKeys, null, null, onlineEnabled, null, null, eventTime);
    }

    public FeatureGroup getOrCreateFeatureGroup(String name, Integer version, List<String> primaryKeys, List<String> partitionKeys, boolean onlineEnabled, String eventTime) throws IOException, FeatureStoreException {
        return this.featureGroupApi.getOrCreateFeatureGroup(this, name, version, null, primaryKeys, partitionKeys, null, onlineEnabled, null, null, eventTime);
    }

    public FeatureGroup getOrCreateFeatureGroup(String name, Integer version, String description, List<String> primaryKeys, List<String> partitionKeys, String hudiPrecombineKey, boolean onlineEnabled, TimeTravelFormat timeTravelFormat, StatisticsConfig statisticsConfig, String eventTime) throws IOException, FeatureStoreException {
        return this.featureGroupApi.getOrCreateFeatureGroup(this, name, version, description, primaryKeys, partitionKeys, hudiPrecombineKey, onlineEnabled, timeTravelFormat, statisticsConfig, eventTime);
    }

    public StreamFeatureGroup.StreamFeatureGroupBuilder createStreamFeatureGroup() {
        return StreamFeatureGroup.builder().featureStore(this);
    }

    public StreamFeatureGroup getOrCreateStreamFeatureGroup(String name, Integer version) throws IOException, FeatureStoreException {
        return this.featureGroupApi.getOrCreateStreamFeatureGroup(this, name, version, null, null, null, null, false, null, null);
    }

    public StreamFeatureGroup getOrCreateStreamFeatureGroup(String name, Integer version, List<String> primaryKeys, boolean onlineEnabled, String eventTime) throws IOException, FeatureStoreException {
        return this.featureGroupApi.getOrCreateStreamFeatureGroup(this, name, version, null, primaryKeys, null, null, onlineEnabled, null, eventTime);
    }

    public StreamFeatureGroup getOrCreateStreamFeatureGroup(String name, Integer version, List<String> primaryKeys, List<String> partitionKeys, boolean onlineEnabled, String eventTime) throws IOException, FeatureStoreException {
        return this.featureGroupApi.getOrCreateStreamFeatureGroup(this, name, version, null, primaryKeys, partitionKeys, null, onlineEnabled, null, eventTime);
    }

    public StreamFeatureGroup getOrCreateStreamFeatureGroup(String name, Integer version, String description, List<String> primaryKeys, List<String> partitionKeys, String hudiPrecombineKey, boolean onlineEnabled, StatisticsConfig statisticsConfig, String eventTime) throws IOException, FeatureStoreException {
        return this.featureGroupApi.getOrCreateStreamFeatureGroup(this, name, version, description, primaryKeys, partitionKeys, hudiPrecombineKey, onlineEnabled, statisticsConfig, eventTime);
    }

    public ExternalFeatureGroup.ExternalFeatureGroupBuilder createExternalFeatureGroup() {
        return ExternalFeatureGroup.builder().featureStore(this);
    }

    @Deprecated
    public ExternalFeatureGroup.ExternalFeatureGroupBuilder createOnDemandFeatureGroup() {
        return ExternalFeatureGroup.builder().featureStore(this);
    }

    public FeatureView.FeatureViewBuilder createFeatureView() {
        return new FeatureView.FeatureViewBuilder(this);
    }

    public FeatureView getOrCreateFeatureView(String name, Query query, Integer version) throws FeatureStoreException, IOException {
        return this.featureViewEngine.getOrCreateFeatureView(this, name, version, query, null, null);
    }

    public FeatureView getOrCreateFeatureView(String name, Query query, Integer version, String description, List<String> labels) throws FeatureStoreException, IOException {
        return this.featureViewEngine.getOrCreateFeatureView(this, name, version, query, description, labels);
    }

    public FeatureView getFeatureView(@NonNull String name, @NonNull Integer version) throws FeatureStoreException, IOException {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        return this.featureViewEngine.get(this, name, version);
    }

    public FeatureView getFeatureView(String name) throws FeatureStoreException, IOException {
        LOGGER.info("VersionWarning: No version provided for getting feature view `" + name + "`, defaulting to `" + DEFAULT_VERSION + "`.");
        return this.getFeatureView(name, DEFAULT_VERSION);
    }

    public TrainingDataset.TrainingDatasetBuilder createTrainingDataset() {
        return TrainingDataset.builder().featureStore(this);
    }

    public TrainingDataset getTrainingDataset(@NonNull String name, @NonNull Integer version) throws FeatureStoreException, IOException {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (version == null) {
            throw new NullPointerException("version is marked non-null but is null");
        }
        return this.trainingDatasetApi.getTrainingDataset(this, name, version);
    }

    public TrainingDataset getTrainingDataset(String name) throws FeatureStoreException, IOException {
        LOGGER.info("VersionWarning: No version provided for getting training dataset `" + name + "`, defaulting to `" + DEFAULT_VERSION + "`.");
        return this.getTrainingDataset(name, DEFAULT_VERSION);
    }

    public Seq<TrainingDataset> getTrainingDatasets(@NonNull String name) throws FeatureStoreException, IOException {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return ((Buffer)JavaConverters.asScalaBufferConverter(this.trainingDatasetApi.get(this, name, null)).asScala()).toSeq();
    }

    public String toString() {
        return "FeatureStore{id=" + this.id + ", name='" + this.name + '\'' + ", projectId=" + this.projectId + ", featureGroupApi=" + this.featureGroupApi + '}';
    }

    public Integer getId() {
        return this.id;
    }

    @JsonProperty(value="featurestoreId")
    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    @JsonProperty(value="featurestoreName")
    public void setName(String name) {
        this.name = name;
    }

    public Integer getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Integer projectId) {
        this.projectId = projectId;
    }
}

