/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.engine;

import com.logicalclocks.hsfs.EntityEndpointType;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.FeatureView;
import com.logicalclocks.hsfs.Split;
import com.logicalclocks.hsfs.TrainingDataset;
import com.logicalclocks.hsfs.engine.SparkEngine;
import com.logicalclocks.hsfs.metadata.FeatureGroupBase;
import com.logicalclocks.hsfs.metadata.SplitStatistics;
import com.logicalclocks.hsfs.metadata.Statistics;
import com.logicalclocks.hsfs.metadata.StatisticsApi;
import java.io.IOException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticsEngine {
    private StatisticsApi statisticsApi;
    private static final Logger LOGGER = LoggerFactory.getLogger(StatisticsEngine.class);

    public StatisticsEngine(EntityEndpointType entityType) {
        this.statisticsApi = new StatisticsApi(entityType);
    }

    public Statistics computeStatistics(TrainingDataset trainingDataset, Dataset<Row> dataFrame) throws IOException, FeatureStoreException {
        Optional<Statistics> statistics = this.computeStatistics(dataFrame, trainingDataset.getStatisticsConfig().getColumns(), trainingDataset.getStatisticsConfig().getHistograms(), trainingDataset.getStatisticsConfig().getCorrelations(), trainingDataset.getStatisticsConfig().getExactUniqueness(), null);
        if (statistics.isPresent()) {
            return this.statisticsApi.post(trainingDataset, statistics.get());
        }
        return null;
    }

    public Statistics computeStatistics(FeatureView featureView, TrainingDataset trainingDataset, Dataset<Row> dataFrame) throws FeatureStoreException, IOException {
        Optional<Statistics> statistics = this.computeStatistics(dataFrame, trainingDataset.getStatisticsConfig().getColumns(), trainingDataset.getStatisticsConfig().getHistograms(), trainingDataset.getStatisticsConfig().getCorrelations(), trainingDataset.getStatisticsConfig().getExactUniqueness(), null);
        if (statistics.isPresent()) {
            return this.statisticsApi.post(featureView, trainingDataset.getVersion(), statistics.get());
        }
        return null;
    }

    public <S> Statistics computeStatistics(FeatureGroupBase featureGroup, S genericDataFrame, Long commitId) throws FeatureStoreException, IOException {
        Optional<Statistics> statistics = this.computeStatistics((Dataset<Row>)((Dataset)genericDataFrame), featureGroup.getStatisticsConfig().getColumns(), featureGroup.getStatisticsConfig().getHistograms(), featureGroup.getStatisticsConfig().getCorrelations(), featureGroup.getStatisticsConfig().getExactUniqueness(), commitId);
        if (statistics.isPresent()) {
            return this.statisticsApi.post(featureGroup, statistics.get());
        }
        return null;
    }

    private Optional<Statistics> computeStatistics(Dataset<Row> dataFrame, List<String> statisticColumns, Boolean histograms, Boolean correlations, Boolean exactUniqueness, Long commitId) {
        if (dataFrame.isEmpty()) {
            LOGGER.warn("There is no data in the entity that you are trying to compute statistics for. A possible cause might be that you inserted only data to the online storage of a feature group.");
            return Optional.empty();
        }
        Long commitTime = Timestamp.valueOf(LocalDateTime.now()).getTime();
        String content = SparkEngine.getInstance().profile(dataFrame, statisticColumns, histograms, correlations, exactUniqueness);
        return Optional.of(new Statistics(commitTime, commitId, content, null));
    }

    public Statistics registerSplitStatistics(TrainingDataset trainingDataset) throws FeatureStoreException, IOException {
        Statistics statistics = this.getSplitStatistics(trainingDataset);
        return this.statisticsApi.post(trainingDataset, statistics);
    }

    public Statistics registerSplitStatistics(FeatureView featureView, TrainingDataset trainingDataset, Map<String, Dataset<Row>> splitDatasets) throws FeatureStoreException, IOException {
        Statistics statistics = this.getSplitStatistics(trainingDataset, splitDatasets);
        return this.statisticsApi.post(featureView, trainingDataset.getVersion(), statistics);
    }

    public Statistics getSplitStatistics(TrainingDataset trainingDataset) throws FeatureStoreException, IOException {
        ArrayList<SplitStatistics> splitStatistics = new ArrayList<SplitStatistics>();
        for (Split split : trainingDataset.getSplits()) {
            Optional<Statistics> statistics = this.computeStatistics(trainingDataset.read(split.getName()), trainingDataset.getStatisticsConfig().getColumns(), trainingDataset.getStatisticsConfig().getHistograms(), trainingDataset.getStatisticsConfig().getCorrelations(), trainingDataset.getStatisticsConfig().getExactUniqueness(), null);
            if (!statistics.isPresent()) continue;
            splitStatistics.add(new SplitStatistics(split.getName(), statistics.get().getContent()));
        }
        Long commitTime = Timestamp.valueOf(LocalDateTime.now()).getTime();
        return new Statistics(commitTime, null, null, splitStatistics);
    }

    public Statistics getSplitStatistics(TrainingDataset trainingDataset, Map<String, Dataset<Row>> splitDatasets) throws FeatureStoreException {
        ArrayList<SplitStatistics> splitStatistics = new ArrayList<SplitStatistics>();
        for (Map.Entry<String, Dataset<Row>> entry : splitDatasets.entrySet()) {
            Optional<Statistics> statistics = this.computeStatistics(entry.getValue(), trainingDataset.getStatisticsConfig().getColumns(), trainingDataset.getStatisticsConfig().getHistograms(), trainingDataset.getStatisticsConfig().getCorrelations(), trainingDataset.getStatisticsConfig().getExactUniqueness(), null);
            if (statistics.isPresent()) {
                splitStatistics.add(new SplitStatistics(entry.getKey(), statistics.get().getContent()));
                continue;
            }
            splitStatistics.add(new SplitStatistics(entry.getKey(), "{}"));
        }
        Long commitTime = Timestamp.valueOf(LocalDateTime.now()).getTime();
        return new Statistics(commitTime, null, null, splitStatistics);
    }

    public Statistics get(FeatureGroupBase featureGroup, String commitTime) throws FeatureStoreException, IOException {
        return this.statisticsApi.get(featureGroup, commitTime);
    }

    public Statistics get(TrainingDataset trainingDataset, String commitTime) throws FeatureStoreException, IOException {
        return this.statisticsApi.get(trainingDataset, commitTime);
    }

    public Statistics getLast(FeatureGroupBase featureGroup) throws FeatureStoreException, IOException {
        return this.statisticsApi.getLast(featureGroup);
    }

    public Statistics getLast(TrainingDataset trainingDataset) throws FeatureStoreException, IOException {
        return this.statisticsApi.getLast(trainingDataset);
    }
}

