/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.engine;

import com.logicalclocks.hsfs.EntityEndpointType;
import com.logicalclocks.hsfs.Feature;
import com.logicalclocks.hsfs.FeatureGroupBase;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.engine.FeatureGroupUtils;
import com.logicalclocks.hsfs.metadata.FeatureGroupApi;
import com.logicalclocks.hsfs.metadata.HopsworksClient;
import com.logicalclocks.hsfs.metadata.TagsApi;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureGroupEngineBase {
    protected FeatureGroupApi featureGroupApi = new FeatureGroupApi();
    protected FeatureGroupUtils utils = new FeatureGroupUtils();
    protected TagsApi tagsApi = new TagsApi(EntityEndpointType.FEATURE_GROUP);
    protected static final Logger LOGGER = LoggerFactory.getLogger(FeatureGroupEngineBase.class);

    public FeatureGroupEngineBase() {
    }

    public FeatureGroupEngineBase(FeatureGroupApi featureGroupApi, TagsApi tagsApi) {
        this.featureGroupApi = featureGroupApi;
        this.tagsApi = tagsApi;
    }

    public void delete(FeatureGroupBase featureGroupBase) throws FeatureStoreException, IOException {
        this.featureGroupApi.delete(featureGroupBase);
    }

    public void addTag(FeatureGroupBase featureGroupBase, String name, Object value) throws FeatureStoreException, IOException {
        this.tagsApi.add(featureGroupBase, name, value);
    }

    public Object getTag(FeatureGroupBase featureGroupBase, String name) throws FeatureStoreException, IOException {
        return this.tagsApi.get(featureGroupBase, name);
    }

    public Map<String, Object> getTags(FeatureGroupBase featureGroupBase) throws FeatureStoreException, IOException {
        return this.tagsApi.get(featureGroupBase);
    }

    public void deleteTag(FeatureGroupBase featureGroupBase, String name) throws FeatureStoreException, IOException {
        this.tagsApi.deleteTag(featureGroupBase, name);
    }

    public <T extends FeatureGroupBase> void updateDescription(FeatureGroupBase featureGroup, String description, Class<T> fgClass) throws FeatureStoreException, IOException {
        featureGroup.setDescription(description);
        T apiFG = this.featureGroupApi.updateMetadata(featureGroup, "updateMetadata", fgClass);
        featureGroup.setDescription(((FeatureGroupBase)apiFG).getDescription());
    }

    public <T extends FeatureGroupBase> void updateFeatures(FeatureGroupBase featureGroup, List<Feature> features, Class<T> fgClass) throws FeatureStoreException, IOException {
        ArrayList<Feature> newFeatures = new ArrayList<Feature>();
        for (Feature feature : featureGroup.getFeatures()) {
            Optional<Feature> match = features.stream().filter(updated -> updated.getName().equalsIgnoreCase(feature.getName())).findAny();
            if (!match.isPresent()) {
                newFeatures.add(feature);
                continue;
            }
            match.get().setType(feature.getType());
            newFeatures.add(match.get());
        }
        newFeatures.addAll(features);
        featureGroup.setFeatures(newFeatures);
        T apiFG = this.featureGroupApi.updateMetadata(featureGroup, "updateMetadata", fgClass);
        featureGroup.setFeatures(((FeatureGroupBase)apiFG).getFeatures());
        featureGroup.unloadSubject();
    }

    public <T extends FeatureGroupBase> void updateStatisticsConfig(FeatureGroupBase featureGroup, Class<T> fgClass) throws FeatureStoreException, IOException {
        T apiFG = this.featureGroupApi.updateMetadata(featureGroup, "updateStatsConfig", fgClass);
        featureGroup.setStatisticsConfig(((FeatureGroupBase)apiFG).getStatisticsConfig());
    }

    protected <T extends FeatureGroupBase> T saveExtennalFeatureGroupMetaData(T externalFeatureGroup, Class<T> fgClass) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String featureGroupJson = hopsworksClient.getObjectMapper().writeValueAsString(externalFeatureGroup);
        return (T)this.featureGroupApi.saveInternal(externalFeatureGroup, new StringEntity(featureGroupJson), fgClass);
    }
}

