/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs;

import com.google.common.base.Strings;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.Project;
import com.logicalclocks.hsfs.SecretStore;
import com.logicalclocks.hsfs.metadata.FeatureStoreApi;
import com.logicalclocks.hsfs.metadata.ProjectApi;
import java.io.Closeable;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.regions.Region;

public abstract class HopsworksConnectionBase
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(HopsworksConnectionBase.class);
    protected String host;
    protected int port;
    protected String project;
    protected Region region;
    protected SecretStore secretStore;
    protected boolean hostnameVerification;
    protected String trustStorePath;
    protected String certPath;
    protected String apiKeyFilePath;
    protected String apiKeyValue;
    protected FeatureStoreApi featureStoreApi = new FeatureStoreApi();
    protected ProjectApi projectApi = new ProjectApi();
    protected Project projectObj;

    public abstract Object getFeatureStore() throws IOException, FeatureStoreException;

    public abstract Object getFeatureStore(String var1) throws IOException, FeatureStoreException;

    @Override
    public void close() {
    }

    public String rewriteFeatureStoreName(String name) {
        if ((name = name.toLowerCase()).endsWith("_featurestore")) {
            return name;
        }
        return name + "_featurestore";
    }

    public Project getProject() throws IOException, FeatureStoreException {
        LOGGER.info("Getting information for project name: " + this.project);
        return this.projectApi.get(this.project);
    }

    public String getProjectName(String project) {
        if (Strings.isNullOrEmpty((String)project)) {
            return System.getProperty("hopsworks.projectname");
        }
        return project;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public Region getRegion() {
        return this.region;
    }

    public SecretStore getSecretStore() {
        return this.secretStore;
    }

    public boolean isHostnameVerification() {
        return this.hostnameVerification;
    }

    public String getTrustStorePath() {
        return this.trustStorePath;
    }

    public String getCertPath() {
        return this.certPath;
    }

    public String getApiKeyFilePath() {
        return this.apiKeyFilePath;
    }

    public String getApiKeyValue() {
        return this.apiKeyValue;
    }
}

