/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.metadata;

import com.damnhandy.uri.template.UriTemplate;
import com.logicalclocks.hsfs.EntityEndpointType;
import com.logicalclocks.hsfs.FeatureGroupBase;
import com.logicalclocks.hsfs.FeatureStoreBase;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.FeatureViewBase;
import com.logicalclocks.hsfs.TrainingDatasetBase;
import com.logicalclocks.hsfs.metadata.HopsworksClient;
import com.logicalclocks.hsfs.metadata.Statistics;
import java.io.IOException;
import lombok.NonNull;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatisticsApi {
    private static final String ENTITY_ROOT_PATH = "{/entityType}";
    private static final String ENTITY_ID_PATH = "{/entityType}{/entityId}";
    private static final String STATISTICS_PATH = "{/entityType}{/entityId}/statistics{?filter_by,fields,sort_by,offset,limit}";
    private static final String FV_STATISTICS_PATH = "/featureview{/fvName}/version{/fvVersion}/trainingdatasets/version{/tdVersion}/statistics{?filter_by,fields,sort_by,offset,limit}";
    private static final Logger LOGGER = LoggerFactory.getLogger(StatisticsApi.class);
    private EntityEndpointType entityType;

    public StatisticsApi(@NonNull EntityEndpointType entityType) {
        if (entityType == null) {
            throw new NullPointerException("entityType is marked non-null but is null");
        }
        this.entityType = entityType;
    }

    public Statistics post(FeatureGroupBase featureGroup, Statistics statistics) throws FeatureStoreException, IOException {
        return this.post(featureGroup.getFeatureStore().getProjectId(), featureGroup.getFeatureStore().getId(), featureGroup.getId(), statistics);
    }

    public Statistics post(TrainingDatasetBase trainingDatasetBase, Statistics statistics) throws FeatureStoreException, IOException {
        return this.post(trainingDatasetBase.getFeatureStore().getProjectId(), trainingDatasetBase.getFeatureStore().getId(), trainingDatasetBase.getId(), statistics);
    }

    private Statistics post(Integer projectId, Integer featurestoreId, Integer entityId, Statistics statistics) throws FeatureStoreException, IOException {
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}{/entityType}{/entityId}/statistics{?filter_by,fields,sort_by,offset,limit}";
        String uri = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)projectId).set("fsId", (Object)featurestoreId).set("entityType", (Object)this.entityType.getValue()).set("entityId", (Object)entityId).expand();
        return this.post(uri, statistics);
    }

    public Statistics post(FeatureViewBase featureViewBase, Integer trainingDataVersion, Statistics statistics) throws FeatureStoreException, IOException {
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}/featureview{/fvName}/version{/fvVersion}/trainingdatasets/version{/tdVersion}/statistics{?filter_by,fields,sort_by,offset,limit}";
        String uri = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)((FeatureStoreBase)featureViewBase.getFeatureStore()).getProjectId()).set("fsId", (Object)((FeatureStoreBase)featureViewBase.getFeatureStore()).getId()).set("fvName", (Object)featureViewBase.getName()).set("fvVersion", (Object)featureViewBase.getVersion()).set("tdVersion", (Object)trainingDataVersion).expand();
        return this.post(uri, statistics);
    }

    private Statistics post(String uri, Statistics statistics) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        LOGGER.info("Sending metadata request: " + uri);
        HttpPost postRequest = new HttpPost(uri);
        postRequest.setEntity((HttpEntity)hopsworksClient.buildStringEntity(statistics));
        return hopsworksClient.handleRequest((HttpRequest)postRequest, Statistics.class);
    }

    public Statistics get(FeatureGroupBase featureGroup, String commitTime) throws FeatureStoreException, IOException {
        return this.get(featureGroup.getFeatureStore().getProjectId(), featureGroup.getFeatureStore().getId(), featureGroup.getId(), commitTime);
    }

    public Statistics get(TrainingDatasetBase trainingDatasetBase, String commitTime) throws FeatureStoreException, IOException {
        return this.get(trainingDatasetBase.getFeatureStore().getProjectId(), trainingDatasetBase.getFeatureStore().getId(), trainingDatasetBase.getId(), commitTime);
    }

    private Statistics get(Integer projectId, Integer featurestoreId, Integer entityId, String commitTime) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}{/entityType}{/entityId}/statistics{?filter_by,fields,sort_by,offset,limit}";
        String uri = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)projectId).set("fsId", (Object)featurestoreId).set("entityType", (Object)this.entityType.getValue()).set("entityId", (Object)entityId).set("filter_by", (Object)("commit_time_eq:" + commitTime)).set("fields", (Object)"content").expand();
        LOGGER.info("Sending metadata request: " + uri);
        HttpGet getRequest = new HttpGet(uri);
        Statistics statistics = hopsworksClient.handleRequest((HttpRequest)getRequest, Statistics.class);
        if (statistics.getItems().size() == 1) {
            return (Statistics)statistics.getItems().get(0);
        }
        return null;
    }

    public Statistics getLast(FeatureGroupBase featureGroup) throws FeatureStoreException, IOException {
        return this.getLast(featureGroup.getFeatureStore().getProjectId(), featureGroup.getFeatureStore().getId(), featureGroup.getId());
    }

    public Statistics getLast(TrainingDatasetBase trainingDatasetBase) throws FeatureStoreException, IOException {
        return this.getLast(trainingDatasetBase.getFeatureStore().getProjectId(), trainingDatasetBase.getFeatureStore().getId(), trainingDatasetBase.getId());
    }

    private Statistics getLast(Integer projectId, Integer featurestoreId, Integer entityId) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}{/entityType}{/entityId}/statistics{?filter_by,fields,sort_by,offset,limit}";
        String uri = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)projectId).set("fsId", (Object)featurestoreId).set("entityType", (Object)this.entityType.getValue()).set("entityId", (Object)entityId).set("sort_by", (Object)"commit_time:desc").set("offset", (Object)0).set("limit", (Object)1).set("fields", (Object)"content").expand();
        LOGGER.info("Sending metadata request: " + uri);
        HttpGet getRequest = new HttpGet(uri);
        Statistics statistics = hopsworksClient.handleRequest((HttpRequest)getRequest, Statistics.class);
        if (statistics.getItems().size() == 1) {
            return (Statistics)statistics.getItems().get(0);
        }
        return null;
    }
}

