/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.logicalclocks.hsfs.DeltaStreamerJobConf;
import com.logicalclocks.hsfs.Feature;
import com.logicalclocks.hsfs.FeatureStoreBase;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.HudiOperationType;
import com.logicalclocks.hsfs.JobConfiguration;
import com.logicalclocks.hsfs.StatisticsConfig;
import com.logicalclocks.hsfs.Storage;
import com.logicalclocks.hsfs.TimeTravelFormat;
import com.logicalclocks.hsfs.constructor.QueryBase;
import com.logicalclocks.hsfs.engine.FeatureGroupEngineBase;
import com.logicalclocks.hsfs.engine.FeatureGroupUtils;
import com.logicalclocks.hsfs.metadata.Statistics;
import com.logicalclocks.hsfs.metadata.Subject;
import com.logicalclocks.hsfs.metadata.User;
import java.io.IOException;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FeatureGroupBase<T> {
    protected Integer id;
    @JsonIgnore
    protected FeatureStoreBase featureStore;
    protected String type = "featuregroupDTO";
    protected String name;
    protected Integer version;
    protected String description;
    @JsonIgnore
    protected List<String> primaryKeys;
    protected List<Feature> features;
    protected String eventTime;
    protected Date created;
    protected User creator;
    protected StatisticsConfig statisticsConfig = new StatisticsConfig();
    protected List<String> expectationsNames;
    protected String location;
    protected TimeTravelFormat timeTravelFormat = TimeTravelFormat.HUDI;
    protected Boolean onlineEnabled;
    protected String onlineTopicName;
    protected List<String> statisticColumns;
    protected DeltaStreamerJobConf deltaStreamerJobConf;
    @JsonIgnore
    protected List<String> partitionKeys;
    @JsonIgnore
    protected String hudiPrecombineKey;
    @JsonIgnore
    protected Subject subject;
    protected FeatureGroupEngineBase featureGroupEngineBase = new FeatureGroupEngineBase();
    protected FeatureGroupUtils utils = new FeatureGroupUtils();
    protected static final Logger LOGGER = LoggerFactory.getLogger(FeatureGroupBase.class);

    public void delete() throws FeatureStoreException, IOException {
        LOGGER.warn("JobWarning: All jobs associated to feature group `" + this.name + "`, version `" + this.version + "` will be removed.");
        this.featureGroupEngineBase.delete(this);
    }

    public void addTag(String name, Object value) throws FeatureStoreException, IOException {
        this.featureGroupEngineBase.addTag(this, name, value);
    }

    @JsonIgnore
    public Map<String, Object> getTags() throws FeatureStoreException, IOException {
        return this.featureGroupEngineBase.getTags(this);
    }

    @JsonIgnore
    public Object getTag(String name) throws FeatureStoreException, IOException {
        return this.featureGroupEngineBase.getTag(this, name);
    }

    public void deleteTag(String name) throws FeatureStoreException, IOException {
        this.featureGroupEngineBase.deleteTag(this, name);
    }

    public void updateDescription(String description) throws FeatureStoreException, IOException {
        this.featureGroupEngineBase.updateDescription(this, description, this.getClass());
    }

    public void updateFeatureDescription(String featureName, String description) throws FeatureStoreException, IOException {
        this.featureGroupEngineBase.updateFeatures(this, Collections.singletonList(Feature.builder().name(featureName).description(description).type("tmp").build()), this.getClass());
    }

    public abstract T read() throws FeatureStoreException, IOException;

    public abstract T read(boolean var1) throws FeatureStoreException, IOException;

    public abstract T read(Map<String, String> var1) throws FeatureStoreException, IOException;

    public abstract T read(boolean var1, Map<String, String> var2) throws FeatureStoreException, IOException;

    public abstract T read(String var1) throws FeatureStoreException, IOException, ParseException;

    public abstract T read(String var1, Map<String, String> var2) throws FeatureStoreException, IOException, ParseException;

    public abstract QueryBase asOf(String var1) throws FeatureStoreException, ParseException;

    public abstract QueryBase asOf(String var1, String var2) throws FeatureStoreException, ParseException;

    public abstract void show(int var1) throws FeatureStoreException, IOException;

    public abstract void show(int var1, boolean var2) throws FeatureStoreException, IOException;

    public abstract void insert(T var1) throws IOException, FeatureStoreException, ParseException;

    public abstract void insert(T var1, Map<String, String> var2) throws FeatureStoreException, IOException, ParseException;

    public abstract void insert(T var1, Storage var2) throws IOException, FeatureStoreException, ParseException;

    public abstract void insert(T var1, boolean var2) throws IOException, FeatureStoreException, ParseException;

    public abstract void insert(T var1, Storage var2, boolean var3) throws IOException, FeatureStoreException, ParseException;

    public abstract void insert(T var1, boolean var2, Map<String, String> var3) throws FeatureStoreException, IOException, ParseException;

    public abstract void insert(T var1, HudiOperationType var2) throws FeatureStoreException, IOException, ParseException;

    public abstract void insert(T var1, Storage var2, boolean var3, HudiOperationType var4, Map<String, String> var5) throws FeatureStoreException, IOException, ParseException;

    public abstract void insert(T var1, JobConfiguration var2) throws FeatureStoreException, IOException, ParseException;

    public abstract void insert(T var1, boolean var2, Map<String, String> var3, JobConfiguration var4) throws FeatureStoreException, IOException, ParseException;

    public abstract void commitDeleteRecord(T var1) throws FeatureStoreException, IOException, ParseException;

    public abstract void commitDeleteRecord(T var1, Map<String, String> var2) throws FeatureStoreException, IOException, ParseException;

    public abstract Map<Long, Map<String, String>> commitDetails() throws IOException, FeatureStoreException, ParseException;

    public abstract Map<Long, Map<String, String>> commitDetails(Integer var1) throws IOException, FeatureStoreException, ParseException;

    public abstract Map<Long, Map<String, String>> commitDetails(String var1) throws IOException, FeatureStoreException, ParseException;

    public abstract Map<Long, Map<String, String>> commitDetails(String var1, Integer var2) throws IOException, FeatureStoreException, ParseException;

    public abstract QueryBase selectFeatures(List<Feature> var1);

    public abstract QueryBase select(List<String> var1);

    public abstract QueryBase selectAll();

    public abstract QueryBase selectExceptFeatures(List<Feature> var1);

    public abstract QueryBase selectExcept(List<String> var1);

    public abstract Object insertStream(T var1) throws Exception;

    public abstract Object insertStream(T var1, String var2) throws Exception;

    public abstract Object insertStream(T var1, Map<String, String> var2) throws Exception;

    public abstract Object insertStream(T var1, String var2, Map<String, String> var3) throws Exception;

    public abstract Object insertStream(T var1, String var2, String var3) throws Exception;

    public abstract Object insertStream(T var1, String var2, String var3, String var4) throws Exception;

    public abstract Object insertStream(T var1, String var2, String var3, boolean var4, Long var5) throws Exception;

    public abstract Object insertStream(T var1, String var2, String var3, boolean var4, Long var5, String var6) throws Exception;

    public abstract Object insertStream(T var1, String var2, String var3, boolean var4, Long var5, String var6, Map<String, String> var7) throws Exception;

    public abstract Object insertStream(T var1, String var2, String var3, boolean var4, String var5) throws Exception;

    public abstract Object insertStream(T var1, String var2, String var3, boolean var4, Long var5, String var6, Map<String, String> var7, JobConfiguration var8) throws Exception;

    public abstract void updateFeatures(List<Feature> var1) throws FeatureStoreException, IOException, ParseException;

    public abstract void updateFeatures(Feature var1) throws FeatureStoreException, IOException, ParseException;

    public abstract void appendFeatures(List<Feature> var1) throws FeatureStoreException, IOException, ParseException;

    public abstract void appendFeatures(Feature var1) throws FeatureStoreException, IOException, ParseException;

    public void updateStatisticsConfig() throws FeatureStoreException, IOException {
        this.featureGroupEngineBase.updateStatisticsConfig(this, this.getClass());
    }

    public abstract Statistics computeStatistics() throws FeatureStoreException, IOException, ParseException;

    public abstract Statistics computeStatistics(String var1) throws FeatureStoreException, IOException, ParseException;

    @JsonIgnore
    public abstract Statistics getStatistics() throws FeatureStoreException, IOException;

    @JsonIgnore
    public Subject getSubject() throws FeatureStoreException, IOException {
        if (this.subject == null) {
            this.subject = this.utils.getSubject(this);
        }
        return this.subject;
    }

    @JsonIgnore
    public void unloadSubject() {
        this.subject = null;
    }

    @JsonIgnore
    public Feature getFeature(String name) throws FeatureStoreException {
        return this.features.stream().filter(f -> f.getName().equalsIgnoreCase(name)).findFirst().orElseThrow(() -> new FeatureStoreException("Feature with name `" + name + "` not found in feature group `" + this.name + "`."));
    }

    @JsonIgnore
    public List<String> getPrimaryKeys() {
        if (this.primaryKeys == null) {
            this.primaryKeys = this.features.stream().filter(f -> f.getPrimary()).map(Feature::getName).collect(Collectors.toList());
        }
        return this.primaryKeys;
    }

    @JsonIgnore
    public List<String> getComplexFeatures() {
        return this.utils.getComplexFeatures(this.features);
    }

    @JsonIgnore
    public String getAvroSchema() throws FeatureStoreException, IOException {
        return this.getSubject().getSchema();
    }

    @JsonIgnore
    public String getFeatureAvroSchema(String featureName) throws FeatureStoreException, IOException {
        return this.utils.getFeatureAvroSchema(featureName, this.utils.getDeserializedAvroSchema(this.getAvroSchema()));
    }

    @JsonIgnore
    public String getEncodedAvroSchema() throws FeatureStoreException, IOException {
        return this.utils.getEncodedAvroSchema(this.getDeserializedAvroSchema(), this.utils.getComplexFeatures(this.features));
    }

    @JsonIgnore
    public Schema getDeserializedEncodedAvroSchema() throws FeatureStoreException, IOException {
        return this.utils.getDeserializedEncodedAvroSchema(this.getDeserializedAvroSchema(), this.utils.getComplexFeatures(this.features));
    }

    @JsonIgnore
    public Schema getDeserializedAvroSchema() throws FeatureStoreException, IOException {
        return this.utils.getDeserializedAvroSchema(this.getAvroSchema());
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public FeatureStoreBase getFeatureStore() {
        return this.featureStore;
    }

    public void setFeatureStore(FeatureStoreBase featureStore) {
        this.featureStore = featureStore;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<Feature> getFeatures() {
        return this.features;
    }

    public void setFeatures(List<Feature> features) {
        this.features = features;
    }

    public String getEventTime() {
        return this.eventTime;
    }

    public void setEventTime(String eventTime) {
        this.eventTime = eventTime;
    }

    public Date getCreated() {
        return this.created;
    }

    public User getCreator() {
        return this.creator;
    }

    public StatisticsConfig getStatisticsConfig() {
        return this.statisticsConfig;
    }

    public void setStatisticsConfig(StatisticsConfig statisticsConfig) {
        this.statisticsConfig = statisticsConfig;
    }

    public List<String> getExpectationsNames() {
        return this.expectationsNames;
    }

    public void setExpectationsNames(List<String> expectationsNames) {
        this.expectationsNames = expectationsNames;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public TimeTravelFormat getTimeTravelFormat() {
        return this.timeTravelFormat;
    }

    public void setTimeTravelFormat(TimeTravelFormat timeTravelFormat) {
        this.timeTravelFormat = timeTravelFormat;
    }

    public Boolean getOnlineEnabled() {
        return this.onlineEnabled;
    }

    public void setOnlineEnabled(Boolean onlineEnabled) {
        this.onlineEnabled = onlineEnabled;
    }

    public String getOnlineTopicName() {
        return this.onlineTopicName;
    }

    public void setOnlineTopicName(String onlineTopicName) {
        this.onlineTopicName = onlineTopicName;
    }

    public List<String> getStatisticColumns() {
        return this.statisticColumns;
    }

    public void setStatisticColumns(List<String> statisticColumns) {
        this.statisticColumns = statisticColumns;
    }

    public void setDeltaStreamerJobConf(DeltaStreamerJobConf deltaStreamerJobConf) {
        this.deltaStreamerJobConf = deltaStreamerJobConf;
    }
}

