/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.metadata;

import com.damnhandy.uri.template.UriTemplate;
import com.logicalclocks.hsfs.FeatureStoreBase;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.metadata.HopsworksClient;
import com.logicalclocks.hsfs.metadata.KafkaClusterInfo;
import com.logicalclocks.hsfs.metadata.PartitionDetails;
import com.logicalclocks.hsfs.metadata.Subject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpGet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaApi {
    private static final String KAFKA_PATH = "/kafka";
    private static final String TOPIC_PATH = "/topics{/topicName}";
    private static final String SUBJECT_PATH = "/subjects{/subjectName}";
    private static final String CLUSTERINFO_PATH = "/clusterinfo{?external}";
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaApi.class);

    public Subject getTopicSubject(FeatureStoreBase featureStoreBase, String topicName) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/kafka/topics{/topicName}/subjects{/subjectName}";
        String uri = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)featureStoreBase.getProjectId()).set("topicName", (Object)topicName).expand();
        LOGGER.info("Sending metadata request: " + uri);
        return hopsworksClient.handleRequest((HttpRequest)new HttpGet(uri), Subject.class);
    }

    public List<PartitionDetails> getTopicDetails(FeatureStoreBase featureStoreBase, String topicName) throws FeatureStoreException, IOException {
        List<PartitionDetails> partitionDetails;
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/kafka/topics{/topicName}";
        String uri = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)featureStoreBase.getProjectId()).set("topicName", (Object)topicName).expand();
        LOGGER.info("Sending metadata request: " + uri);
        PartitionDetails dto = hopsworksClient.handleRequest((HttpRequest)new HttpGet(uri), PartitionDetails.class);
        if (dto.getCount() == null) {
            partitionDetails = new ArrayList();
            partitionDetails.add(dto);
        } else {
            partitionDetails = dto.getItems();
        }
        LOGGER.info("Received partitions: " + partitionDetails);
        return partitionDetails;
    }

    public List<String> getBrokerEndpoints(FeatureStoreBase featureStoreBase) throws FeatureStoreException, IOException {
        return this.getBrokerEndpoints(featureStoreBase, false);
    }

    public List<String> getBrokerEndpoints(FeatureStoreBase featureStoreBase, boolean externalListeners) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/kafka/clusterinfo{?external}";
        String uri = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)featureStoreBase.getProjectId()).set("external", (Object)externalListeners).expand();
        LOGGER.info("Sending metadata request: " + uri);
        return hopsworksClient.handleRequest((HttpRequest)new HttpGet(uri), KafkaClusterInfo.class).getBrokers();
    }
}

