/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.metadata;

import com.damnhandy.uri.template.UriTemplate;
import com.logicalclocks.hsfs.FeatureGroupBase;
import com.logicalclocks.hsfs.FeatureStoreBase;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.constructor.FeatureGroupAlias;
import com.logicalclocks.hsfs.constructor.FsQueryBase;
import com.logicalclocks.hsfs.constructor.QueryBase;
import com.logicalclocks.hsfs.metadata.HopsworksClient;
import java.io.IOException;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryConstructorApi {
    public static final String QUERY_CONSTRUCTOR_PATH = "/query";
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryConstructorApi.class);

    public <T> FsQueryBase constructQuery(FeatureStoreBase featureStoreBase, QueryBase queryBase, Class<T> fsQueryType) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/featurestores/query";
        String uri = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)featureStoreBase.getProjectId()).expand();
        String queryJson = hopsworksClient.getObjectMapper().writeValueAsString((Object)queryBase);
        HttpPut putRequest = new HttpPut(uri);
        putRequest.setHeader("Content-Type", "application/json");
        putRequest.setEntity((HttpEntity)new StringEntity(queryJson));
        LOGGER.info("Sending metadata request: " + uri);
        LOGGER.info("Sending query: " + queryJson);
        FsQueryBase fsQueryBase = (FsQueryBase)hopsworksClient.handleRequest((HttpRequest)putRequest, fsQueryType);
        fsQueryBase.removeNewLines();
        List onDemandFeatureGroupAliases = fsQueryBase.getOnDemandFeatureGroups();
        for (FeatureGroupAlias onDemandFeatureGroupAlias : onDemandFeatureGroupAliases) {
            Object updatedFG = onDemandFeatureGroupAlias.getOnDemandFeatureGroup();
            ((FeatureGroupBase)updatedFG).setFeatureStore(featureStoreBase);
            onDemandFeatureGroupAlias.setOnDemandFeatureGroup(updatedFG);
        }
        List hudiCachedFeatureAliases = fsQueryBase.getHudiCachedFeatureGroups();
        for (FeatureGroupAlias hudiCachedFeatureAlias : hudiCachedFeatureAliases) {
            Object updatedFG = hudiCachedFeatureAlias.getFeatureGroup();
            ((FeatureGroupBase)updatedFG).setFeatureStore(featureStoreBase);
            hudiCachedFeatureAlias.setFeatureGroup(updatedFG);
        }
        fsQueryBase.setOnDemandFeatureGroups(onDemandFeatureGroupAliases);
        fsQueryBase.setHudiCachedFeatureGroups(hudiCachedFeatureAliases);
        return fsQueryBase;
    }
}

