/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.constructor;

import com.google.common.base.Strings;
import com.logicalclocks.hsfs.FeatureGroupBase;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.Storage;
import com.logicalclocks.hsfs.constructor.FeatureGroupAlias;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public abstract class FsQueryBase<T extends FeatureGroupBase, T2 extends FeatureGroupBase> {
    private String query;
    private String queryOnline;
    private String pitQuery;
    private List<FeatureGroupAlias<T2>> onDemandFeatureGroups;
    private List<FeatureGroupAlias<T>> hudiCachedFeatureGroups;

    public void removeNewLines() {
        this.query = this.query != null ? this.query.replace("\n", " ") : null;
        this.queryOnline = this.queryOnline != null ? this.queryOnline.replace("\n", " ") : null;
    }

    public String getStorageQuery(Storage storage) throws FeatureStoreException {
        switch (storage) {
            case OFFLINE: {
                if (!Strings.isNullOrEmpty((String)this.pitQuery)) {
                    return this.pitQuery;
                }
                return this.query;
            }
            case ONLINE: {
                return this.queryOnline;
            }
        }
        throw new FeatureStoreException("Cannot run query on ALL storages");
    }

    public abstract void registerOnDemandFeatureGroups() throws FeatureStoreException, IOException;

    public abstract void registerHudiFeatureGroups(Map<String, String> var1) throws FeatureStoreException;

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getQueryOnline() {
        return this.queryOnline;
    }

    public void setQueryOnline(String queryOnline) {
        this.queryOnline = queryOnline;
    }

    public String getPitQuery() {
        return this.pitQuery;
    }

    public void setPitQuery(String pitQuery) {
        this.pitQuery = pitQuery;
    }

    public List<FeatureGroupAlias<T2>> getOnDemandFeatureGroups() {
        return this.onDemandFeatureGroups;
    }

    public void setOnDemandFeatureGroups(List<FeatureGroupAlias<T2>> onDemandFeatureGroups) {
        this.onDemandFeatureGroups = onDemandFeatureGroups;
    }

    public List<FeatureGroupAlias<T>> getHudiCachedFeatureGroups() {
        return this.hudiCachedFeatureGroups;
    }

    public void setHudiCachedFeatureGroups(List<FeatureGroupAlias<T>> hudiCachedFeatureGroups) {
        this.hudiCachedFeatureGroups = hudiCachedFeatureGroups;
    }
}

