/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.metadata;

import com.damnhandy.uri.template.UriTemplate;
import com.logicalclocks.hsfs.DeltaStreamerJobConf;
import com.logicalclocks.hsfs.Feature;
import com.logicalclocks.hsfs.FeatureGroupBase;
import com.logicalclocks.hsfs.FeatureGroupCommit;
import com.logicalclocks.hsfs.FeatureStoreBase;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.JobConfiguration;
import com.logicalclocks.hsfs.metadata.HopsworksClient;
import com.logicalclocks.hsfs.metadata.Option;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeatureGroupApi {
    public static final String FEATURE_GROUP_ROOT_PATH = "/featuregroups";
    public static final String FEATURE_GROUP_PATH = "/featuregroups{/fgName}{?version}";
    public static final String FEATURE_GROUP_ID_PATH = "/featuregroups{/fgId}{?updateStatsConfig,updateMetadata,validationType,deprecate}";
    public static final String FEATURE_GROUP_COMMIT_PATH = "/featuregroups{/fgId}{?updateStatsConfig,updateMetadata,validationType,deprecate}/commits{?filter_by,sort_by,offset,limit}";
    public static final String FEATURE_GROUP_CLEAR_PATH = "/featuregroups{/fgId}{?updateStatsConfig,updateMetadata,validationType,deprecate}/clear";
    private static final Logger LOGGER = LoggerFactory.getLogger(FeatureGroupApi.class);

    public <T extends FeatureGroupBase> T[] getInternal(FeatureStoreBase featureStoreBase, String fgName, Integer fgVersion, Class<T[]> fgType) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}/featuregroups{/fgName}{?version}";
        UriTemplate uri = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)featureStoreBase.getProjectId()).set("fsId", (Object)featureStoreBase.getId()).set("fgName", (Object)fgName);
        if (fgVersion != null) {
            uri.set("version", (Object)fgVersion);
        }
        String uriString = uri.expand();
        LOGGER.info("Sending metadata request: " + uriString);
        FeatureGroupBase[] featureGroups = (FeatureGroupBase[])hopsworksClient.handleRequest((HttpRequest)new HttpGet(uriString), fgType);
        return featureGroups;
    }

    public <U extends FeatureGroupBase> FeatureGroupBase save(FeatureGroupBase featureGroup, Class<U> fgType) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        return this.saveInternal(featureGroup, hopsworksClient.buildStringEntity(featureGroup), fgType);
    }

    public <U extends FeatureGroupBase> FeatureGroupBase saveInternal(FeatureGroupBase featureGroupBase, StringEntity entity, Class<U> fgType) throws FeatureStoreException, IOException {
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}/featuregroups";
        String uri = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)featureGroupBase.getFeatureStore().getProjectId()).set("fsId", (Object)featureGroupBase.getFeatureStore().getId()).expand();
        HttpPost postRequest = new HttpPost(uri);
        postRequest.setHeader("Content-Type", "application/json");
        postRequest.setEntity((HttpEntity)entity);
        LOGGER.info("Sending metadata request: " + uri);
        return (FeatureGroupBase)HopsworksClient.getInstance().handleRequest((HttpRequest)postRequest, fgType);
    }

    public void delete(FeatureGroupBase featureGroupBase) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}/featuregroups{/fgId}{?updateStatsConfig,updateMetadata,validationType,deprecate}";
        String uri = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)featureGroupBase.getFeatureStore().getProjectId()).set("fsId", (Object)featureGroupBase.getFeatureStore().getId()).set("fgId", (Object)featureGroupBase.getId()).expand();
        HttpDelete deleteRequest = new HttpDelete(uri);
        LOGGER.info("Sending metadata request: " + uri);
        hopsworksClient.handleRequest((HttpRequest)deleteRequest);
    }

    public void deleteContent(FeatureGroupBase featureGroup) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}/featuregroups{/fgId}{?updateStatsConfig,updateMetadata,validationType,deprecate}/clear";
        String uri = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)featureGroup.getFeatureStore().getProjectId()).set("fsId", (Object)featureGroup.getFeatureStore().getId()).set("fgId", (Object)featureGroup.getId()).expand();
        LOGGER.info("Sending metadata request: " + uri);
        HttpPost postRequest = new HttpPost(uri);
        hopsworksClient.handleRequest((HttpRequest)postRequest);
    }

    public <T extends FeatureGroupBase> T updateMetadata(FeatureGroupBase featureGroup, String queryParameter, Class<T> fgType) throws FeatureStoreException, IOException {
        return this.updateMetadata(featureGroup, queryParameter, true, fgType);
    }

    public <T extends FeatureGroupBase> T updateMetadata(FeatureGroupBase featureGroup, String queryParameter, Object value, Class<T> fgType) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}/featuregroups{/fgId}{?updateStatsConfig,updateMetadata,validationType,deprecate}";
        String uri = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)featureGroup.getFeatureStore().getProjectId()).set("fsId", (Object)featureGroup.getFeatureStore().getId()).set("fgId", (Object)featureGroup.getId()).set(queryParameter, value).expand();
        HttpPut putRequest = new HttpPut(uri);
        putRequest.setHeader("Content-Type", "application/json");
        putRequest.setEntity((HttpEntity)hopsworksClient.buildStringEntity(featureGroup));
        LOGGER.info("Sending metadata request: " + uri);
        return (T)((FeatureGroupBase)hopsworksClient.handleRequest((HttpRequest)putRequest, fgType));
    }

    public FeatureGroupCommit featureGroupCommit(FeatureGroupBase featureGroup, FeatureGroupCommit featureGroupCommit) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}/featuregroups{/fgId}{?updateStatsConfig,updateMetadata,validationType,deprecate}/commits{?filter_by,sort_by,offset,limit}";
        String uri = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)featureGroup.getFeatureStore().getProjectId()).set("fsId", (Object)featureGroup.getFeatureStore().getId()).set("fgId", (Object)featureGroup.getId()).expand();
        HttpPost postRequest = new HttpPost(uri);
        postRequest.setHeader("Content-Type", "application/json");
        postRequest.setEntity((HttpEntity)hopsworksClient.buildStringEntity(featureGroupCommit));
        LOGGER.info("Sending metadata request: " + uri);
        return hopsworksClient.handleRequest((HttpRequest)postRequest, FeatureGroupCommit.class);
    }

    public List<FeatureGroupCommit> getCommitDetails(FeatureGroupBase featureGroupBase, Long wallclockTimestamp, Integer limit) throws IOException, FeatureStoreException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}/featuregroups{/fgId}{?updateStatsConfig,updateMetadata,validationType,deprecate}/commits{?filter_by,sort_by,offset,limit}";
        UriTemplate uriTemplate = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)featureGroupBase.getFeatureStore().getProjectId()).set("fsId", (Object)featureGroupBase.getFeatureStore().getId()).set("fgId", (Object)featureGroupBase.getId()).set("sort_by", (Object)"committed_on:desc").set("offset", (Object)0).set("limit", (Object)limit);
        if (wallclockTimestamp != null) {
            uriTemplate.set("filter_by", (Object)("commited_on_ltoeq:" + wallclockTimestamp));
        }
        String uri = uriTemplate.expand();
        LOGGER.info("Sending metadata request: " + uri);
        FeatureGroupCommit featureGroupCommit = hopsworksClient.handleRequest((HttpRequest)new HttpGet(uri), FeatureGroupCommit.class);
        return featureGroupCommit.getItems();
    }

    public <U extends FeatureGroupBase> FeatureGroupBase saveFeatureGroupMetaData(FeatureGroupBase featureGroup, List<String> partitionKeys, String hudiPrecombineKey, Map<String, String> writeOptions, JobConfiguration jobConfiguration, Class<U> fgType) throws FeatureStoreException, IOException {
        LOGGER.info("Featuregroup features: " + featureGroup.getFeatures());
        List<Feature> features = featureGroup.getFeatures();
        if (featureGroup.getPrimaryKeys() != null) {
            featureGroup.getPrimaryKeys().forEach(pk -> features.forEach(f -> {
                if (f.getName().equals(pk)) {
                    f.setPrimary(true);
                }
            }));
        }
        if (partitionKeys != null) {
            partitionKeys.forEach(pk -> features.forEach(f -> {
                if (f.getName().equals(pk)) {
                    f.setPartition(true);
                }
            }));
        }
        if (hudiPrecombineKey != null) {
            features.forEach(f -> {
                if (f.getName().equals(hudiPrecombineKey)) {
                    f.setHudiPrecombineKey(true);
                }
            });
        }
        if (writeOptions != null) {
            DeltaStreamerJobConf deltaStreamerJobConf = new DeltaStreamerJobConf();
            deltaStreamerJobConf.setWriteOptions(writeOptions != null ? writeOptions.entrySet().stream().map(e -> new Option((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList()) : null);
            deltaStreamerJobConf.setSparkJobConfiguration(jobConfiguration);
            featureGroup.setDeltaStreamerJobConf(deltaStreamerJobConf);
        }
        FeatureGroupBase apiFG = this.save(featureGroup, fgType);
        if (featureGroup.getVersion() == null) {
            LOGGER.info("VersionWarning: No version provided for creating feature group `" + featureGroup.getName() + "`, incremented version to `" + apiFG.getVersion() + "`.");
        }
        featureGroup.setId(apiFG.getId());
        featureGroup.setVersion(apiFG.getVersion());
        featureGroup.setLocation(apiFG.getLocation());
        featureGroup.setStatisticsConfig(apiFG.getStatisticsConfig());
        featureGroup.setOnlineTopicName(apiFG.getOnlineTopicName());
        if (hudiPrecombineKey == null) {
            List<Feature> updatedFeatures = apiFG.getFeatures();
            featureGroup.setFeatures(updatedFeatures);
        }
        return featureGroup;
    }
}

