/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.metadata;

import com.damnhandy.uri.template.UriTemplate;
import com.logicalclocks.hsfs.FeatureStoreBase;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.metadata.HopsworksClient;
import com.logicalclocks.hsfs.metadata.Subject;
import java.io.IOException;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpGet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaApi {
    private static final String KAFKA_PATH = "/kafka";
    private static final String SUBJECT_PATH = "/subjects/{subject}/versions/{version}";
    private static final Logger LOGGER = LoggerFactory.getLogger(KafkaApi.class);

    public Subject getSubject(FeatureStoreBase featureStoreBase, String subjectName) throws FeatureStoreException, IOException {
        return this.getSubject(featureStoreBase, subjectName, "latest");
    }

    public Subject getSubject(FeatureStoreBase featureStoreBase, String subjectName, String subjectVersion) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/kafka/subjects/{subject}/versions/{version}";
        String uri = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)featureStoreBase.getProjectId()).set("subject", (Object)subjectName).set("version", (Object)subjectVersion).expand();
        LOGGER.info("Sending metadata request: " + uri);
        return hopsworksClient.handleRequest((HttpRequest)new HttpGet(uri), Subject.class);
    }
}

