/*
 * Decompiled with CFR 0.152.
 */
package com.logicalclocks.hsfs.metadata;

import com.damnhandy.uri.template.UriTemplate;
import com.logicalclocks.hsfs.FeatureStoreBase;
import com.logicalclocks.hsfs.FeatureStoreException;
import com.logicalclocks.hsfs.TrainingDatasetBase;
import com.logicalclocks.hsfs.constructor.FsQueryBase;
import com.logicalclocks.hsfs.constructor.ServingPreparedStatement;
import com.logicalclocks.hsfs.metadata.HopsworksClient;
import com.logicalclocks.hsfs.metadata.TransformationFunctionAttached;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrainingDatasetApi {
    private static final String TRAINING_DATASETS_PATH = "/trainingdatasets";
    private static final String TRAINING_DATASET_PATH = "/trainingdatasets{/tdName}{?version}";
    private static final String TRAINING_QUERY_PATH = "/trainingdatasets{/tdId}/query{?withLabel}{&hiveQuery}";
    public static final String TRAINING_DATASET_ID_PATH = "/trainingdatasets{/fgId}{?updateStatsConfig,updateMetadata}";
    private static final String PREP_STATEMENT_PATH = "/trainingdatasets{/tdId}/preparedstatements{?batch}";
    private static final String TRANSFORMATION_FUNCTION_PATH = "/trainingdatasets{/tdId}/transformationfunctions";
    private static final Logger LOGGER = LoggerFactory.getLogger(TrainingDatasetApi.class);

    public List<TrainingDatasetBase> get(FeatureStoreBase featureStoreBase, String tdName, Integer tdVersion) throws IOException, FeatureStoreException {
        TrainingDatasetBase[] trainingDatasetBases;
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}/trainingdatasets{/tdName}{?version}";
        UriTemplate uri = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)featureStoreBase.getProjectId()).set("fsId", (Object)featureStoreBase.getId()).set("tdName", (Object)tdName);
        if (tdVersion != null) {
            uri.set("version", (Object)tdVersion);
        }
        String uriString = uri.expand();
        LOGGER.info("Sending metadata request: " + uriString);
        for (TrainingDatasetBase td : trainingDatasetBases = hopsworksClient.handleRequest((HttpRequest)new HttpGet(uriString), TrainingDatasetBase[].class)) {
            td.setFeatureStore(featureStoreBase);
            td.getFeatures().stream().filter(f -> f.getFeatureGroup() != null).forEach(f -> f.getFeatureGroup().setFeatureStore(featureStoreBase));
            this.rewriteLocation(td);
        }
        return Arrays.asList(trainingDatasetBases);
    }

    private void rewriteLocation(TrainingDatasetBase td) {
        String projectName = td.getFeatureStore().getName();
        if (td.getLocation().endsWith(String.format("/Projects/%s/%s_Training_Datasets", projectName, projectName))) {
            td.setLocation(String.format("%s/%s_%d", td.getLocation(), td.getName(), td.getVersion()));
        }
    }

    public TrainingDatasetBase getTrainingDataset(FeatureStoreBase featureStoreBase, String tdName, Integer tdVersion) throws IOException, FeatureStoreException {
        return this.get(featureStoreBase, tdName, tdVersion).get(0);
    }

    public TrainingDatasetBase createTrainingDataset(TrainingDatasetBase trainingDatasetBase) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}/trainingdatasets";
        String uri = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)trainingDatasetBase.getFeatureStore().getProjectId()).set("fsId", (Object)trainingDatasetBase.getFeatureStore().getId()).expand();
        LOGGER.info("Sending metadata request: " + uri);
        HttpPost postRequest = new HttpPost(uri);
        postRequest.setEntity((HttpEntity)hopsworksClient.buildStringEntity(trainingDatasetBase));
        TrainingDatasetBase td = hopsworksClient.handleRequest((HttpRequest)postRequest, TrainingDatasetBase.class);
        this.rewriteLocation(td);
        return td;
    }

    public FsQueryBase getQuery(TrainingDatasetBase trainingDatasetBase, boolean withLabel, boolean isHiveQuery) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}/trainingdatasets{/tdId}/query{?withLabel}{&hiveQuery}";
        String uri = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)trainingDatasetBase.getFeatureStore().getProjectId()).set("fsId", (Object)trainingDatasetBase.getFeatureStore().getId()).set("tdId", (Object)trainingDatasetBase.getId()).set("withLabel", (Object)withLabel).set("hiveQuery", (Object)isHiveQuery).expand();
        HttpGet getRequest = new HttpGet(uri);
        LOGGER.info("Sending metadata request: " + uri);
        return hopsworksClient.handleRequest((HttpRequest)getRequest, FsQueryBase.class);
    }

    public List<ServingPreparedStatement> getServingPreparedStatement(TrainingDatasetBase trainingDatasetBase, boolean batch) throws FeatureStoreException, IOException {
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}/trainingdatasets{/tdId}/preparedstatements{?batch}";
        String uri = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)trainingDatasetBase.getFeatureStore().getProjectId()).set("fsId", (Object)trainingDatasetBase.getFeatureStore().getId()).set("tdId", (Object)trainingDatasetBase.getId()).set("batch", (Object)batch).expand();
        HttpGet getRequest = new HttpGet(uri);
        LOGGER.info("Sending metadata request: " + uri);
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        ServingPreparedStatement servingPreparedStatement = hopsworksClient.handleRequest((HttpRequest)getRequest, ServingPreparedStatement.class);
        return servingPreparedStatement.getItems();
    }

    public TrainingDatasetBase updateMetadata(TrainingDatasetBase trainingDatasetBase, String queryParameter) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}/trainingdatasets{/fgId}{?updateStatsConfig,updateMetadata}";
        String uri = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)trainingDatasetBase.getFeatureStore().getProjectId()).set("fsId", (Object)trainingDatasetBase.getFeatureStore().getId()).set("fgId", (Object)trainingDatasetBase.getId()).set(queryParameter, (Object)true).expand();
        LOGGER.info("Sending metadata request: " + uri);
        HttpPut putRequest = new HttpPut(uri);
        putRequest.setEntity((HttpEntity)hopsworksClient.buildStringEntity(trainingDatasetBase));
        TrainingDatasetBase td = hopsworksClient.handleRequest((HttpRequest)putRequest, TrainingDatasetBase.class);
        this.rewriteLocation(td);
        return td;
    }

    public void delete(TrainingDatasetBase trainingDatasetBase) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}/trainingdatasets{/fgId}{?updateStatsConfig,updateMetadata}";
        String uri = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)trainingDatasetBase.getFeatureStore().getProjectId()).set("fsId", (Object)trainingDatasetBase.getFeatureStore().getId()).set("fgId", (Object)trainingDatasetBase.getId()).expand();
        HttpDelete deleteRequest = new HttpDelete(uri);
        LOGGER.info("Sending metadata request: " + uri);
        hopsworksClient.handleRequest((HttpRequest)deleteRequest);
    }

    public List<TransformationFunctionAttached> getTransformationFunctions(TrainingDatasetBase trainingDatasetBase) throws FeatureStoreException, IOException {
        HopsworksClient hopsworksClient = HopsworksClient.getInstance();
        String pathTemplate = "/hopsworks-api/api/project{/projectId}/featurestores{/fsId}/trainingdatasets{/tdId}/transformationfunctions";
        String uri = UriTemplate.fromTemplate((String)pathTemplate).set("projectId", (Object)trainingDatasetBase.getFeatureStore().getProjectId()).set("fsId", (Object)trainingDatasetBase.getFeatureStore().getId()).set("tdId", (Object)trainingDatasetBase.getId()).expand();
        LOGGER.info("Sending metadata request: " + uri);
        TransformationFunctionAttached transformationFunctionAttached = hopsworksClient.handleRequest((HttpRequest)new HttpGet(uri), TransformationFunctionAttached.class);
        return transformationFunctionAttached.getItems();
    }
}

